/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.eav;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Date;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEDataType;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.FetchType;
import org.eclipse.emf.teneo.hibernate.HbDataStore;
import org.eclipse.emf.teneo.hibernate.mapping.eav.EAVBlobValue;
import org.eclipse.emf.teneo.hibernate.mapping.eav.EAVTextValue;
import org.eclipse.emf.teneo.hibernate.mapping.eav.EAVValueHolder;

public class EAVSingleEAttributeValueHolder
extends EAVValueHolder {
    private static final int MAX_PRECISION = 38;
    private String type;
    private String typeNeutralValue;
    private String stringValue;
    private Date dateValue;
    private BigDecimal numericValue;
    private double doubleValue;
    private long longValue;
    private Object objectValue;
    private EAVBlobValue blobValue;
    private EAVTextValue textValue;

    @Override
    public void set(Object value) {
        this.stringValue = null;
        this.dateValue = null;
        this.numericValue = null;
        this.longValue = 0L;
        this.setValueIsSet(false);
        this.setMandatoryValue(null);
        this.objectValue = value;
        if (value == null) {
            return;
        }
        this.setMandatoryValue(NOT_NULL_VALUE);
        boolean isBlob = value instanceof byte[] || value instanceof String && this.isClob(this.getEStructuralFeature());
        EDataType eDataType = (EDataType)this.getEStructuralFeature().getEType();
        EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
        if (!isBlob) {
            this.typeNeutralValue = eFactory.convertToString(eDataType, value);
        }
        this.type = value.getClass().getName();
        if (value instanceof byte[]) {
            this.blobValue = new EAVBlobValue();
            this.blobValue.setBlobValue((byte[])value);
            this.blobValue.setValueHolder(this);
        } else if (value instanceof Enumerator) {
            this.stringValue = ((Enumerator)value).getName();
        } else if (value instanceof String && isBlob) {
            this.textValue = new EAVTextValue();
            this.textValue.setTextValue((String)value);
            this.textValue.setValueHolder(this);
        } else if (value instanceof String) {
            this.stringValue = (String)value;
        } else if (value instanceof Date) {
            this.dateValue = (Date)value;
        } else if (value instanceof Number) {
            if (value instanceof BigDecimal) {
                BigDecimal bdValue = (BigDecimal)value;
                if (bdValue.precision() > 38) {
                    MathContext mathContext = new MathContext(38);
                    this.numericValue = bdValue.round(mathContext);
                } else {
                    this.numericValue = bdValue;
                }
            } else if (value instanceof BigInteger) {
                this.longValue = ((BigInteger)value).longValue();
            } else if (value instanceof Double || value instanceof Float) {
                this.doubleValue = ((Number)value).doubleValue();
            } else if (value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Byte) {
                this.longValue = ((Number)value).longValue();
            } else {
                throw new UnsupportedOperationException("Primitive type " + value.getClass() + " not supported here.");
            }
        }
    }

    @Override
    public Object get(InternalEObject owner) {
        if (this.objectValue == null && this.blobValue != null) {
            this.objectValue = this.blobValue.getBlobValue();
        } else if (this.objectValue == null && this.textValue != null) {
            this.objectValue = this.textValue.getTextValue();
        } else if (this.objectValue == null && this.typeNeutralValue != null) {
            EDataType eDataType = (EDataType)this.getEStructuralFeature().getEType();
            EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
            this.objectValue = eFactory.createFromString(eDataType, this.typeNeutralValue);
        }
        return this.objectValue;
    }

    @Override
    public Object getValue() {
        return this.get(null);
    }

    @Override
    public void setValueInOwner(InternalEObject owner) {
        if (this.getEStructuralFeature().isUnsettable() && !this.isValueIsSet()) {
            owner.eUnset(this.getEStructuralFeature());
        } else {
            owner.eSet(this.getEStructuralFeature(), this.get(owner));
        }
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public Date getDateValue() {
        return this.dateValue;
    }

    public void setDateValue(Date dateValue) {
        this.dateValue = dateValue;
    }

    public BigDecimal getNumericValue() {
        return this.numericValue;
    }

    public void setNumericValue(BigDecimal numericValue) {
        this.numericValue = numericValue;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(long longValue) {
        this.longValue = longValue;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTypeNeutralValue() {
        return this.typeNeutralValue;
    }

    public void setTypeNeutralValue(String typeNeutralValue) {
        this.typeNeutralValue = typeNeutralValue;
    }

    public EAVBlobValue getBlobValue() {
        return this.blobValue;
    }

    public void setBlobValue(EAVBlobValue blobValue) {
        this.blobValue = blobValue;
    }

    public EAVTextValue getTextValue() {
        return this.textValue;
    }

    public void setTextValue(EAVTextValue textValue) {
        this.textValue = textValue;
    }

    private boolean isClob(EStructuralFeature eFeature) {
        PAnnotatedEDataType paDataType;
        block7: {
            EAttribute eAttribute;
            block6: {
                PAnnotatedEAttribute paEAttribute;
                block5: {
                    eAttribute = (EAttribute)eFeature;
                    try {
                        paEAttribute = this.getHbDataStore().getPaModel().getPAnnotated(eAttribute);
                        if (paEAttribute != null) break block5;
                        return false;
                    }
                    catch (IllegalArgumentException e) {
                        return false;
                    }
                }
                if (paEAttribute.getLob() == null) break block6;
                return true;
            }
            paDataType = this.getHbDataStore().getPaModel().getPAnnotated(eAttribute.getEAttributeType());
            if (paDataType != null) break block7;
            return false;
        }
        return paDataType.getLob() != null;
    }

    protected static boolean isFeatureExtraLazy(HbDataStore hbDataStore, EStructuralFeature eFeature) {
        if (hbDataStore.getPersistenceOptions().isFetchAssociationExtraLazy()) {
            return true;
        }
        PAnnotatedEStructuralFeature paFeature = hbDataStore.getPaModel().getPAnnotated(eFeature);
        if (paFeature.getOneToMany() != null && paFeature.getOneToMany().getFetch().equals((Object)FetchType.EXTRA)) {
            return Boolean.TRUE;
        }
        return false;
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(double doubleValue) {
        this.doubleValue = doubleValue;
    }
}

