/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.teneo.classloader.ClassLoaderResolver;
import org.eclipse.emf.teneo.classloader.StoreClassLoadException;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.mapping.ENumUserType;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;

public class ENumUserIntegerType
extends ENumUserType {
    private static final int[] SQL_TYPES = new int[]{4};
    private final HashMap<Integer, Enumerator> localCache = new HashMap();

    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor SharedSessionContractImplementor2, Object owner) throws HibernateException, SQLException {
        int value = rs.getInt(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        Integer objValue = value;
        Enumerator enumValue = this.localCache.get(objValue);
        if (enumValue != null) {
            return enumValue;
        }
        try {
            enumValue = (Enumerator)this.getMethod.invoke(null, objValue);
            this.localCache.put(objValue, enumValue);
            return enumValue;
        }
        catch (Exception e) {
            throw new HbMapperException("Exception when getting enum for class: " + this.enumType.getName() + " using int value: " + value, e);
        }
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor SharedSessionContractImplementor2) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 4);
        } else {
            st.setInt(index, ((Enumerator)value).getValue());
        }
    }

    @Override
    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    @Override
    public void setParameterValues(Properties parameters) {
        String enumClassName = parameters.getProperty("enumClass");
        try {
            this.enumType = ClassLoaderResolver.classForName((String)enumClassName);
            this.getMethod = this.enumType.getMethod("get", Integer.TYPE);
        }
        catch (StoreClassLoadException e) {
            throw new HbMapperException("Enum class " + enumClassName + " can not be found", e);
        }
        catch (NoSuchMethodException e) {
            throw new HbMapperException("Get method not present in enum class " + enumClassName, e);
        }
    }
}

