/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.auditing.model.teneoauditing;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TeneoAuditKind implements Enumerator
{
    ADD(0, "ADD", "ADD"),
    UPDATE(1, "UPDATE", "UPDATE"),
    DELETE(2, "DELETE", "DELETE");

    public static final int ADD_VALUE = 0;
    public static final int UPDATE_VALUE = 1;
    public static final int DELETE_VALUE = 2;
    private static final TeneoAuditKind[] VALUES_ARRAY;
    public static final List<TeneoAuditKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TeneoAuditKind[]{ADD, UPDATE, DELETE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TeneoAuditKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TeneoAuditKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TeneoAuditKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TeneoAuditKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TeneoAuditKind get(int value) {
        switch (value) {
            case 0: {
                return ADD;
            }
            case 1: {
                return UPDATE;
            }
            case 2: {
                return DELETE;
            }
        }
        return null;
    }

    private TeneoAuditKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

