/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import javax.persistence.SynchronizationType;
import javax.persistence.criteria.CriteriaBuilder;
import org.eclipse.emf.teneo.hibernate.HbDataStore;
import org.eclipse.emf.teneo.hibernate.HbHelper;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.TypeHelper;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.spi.CacheImplementor;
import org.hibernate.cfg.Settings;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunctionRegistry;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.query.spi.QueryPlanCache;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.spi.EventEngine;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.internal.FastSessionServices;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.query.spi.NamedQueryRepository;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;

public abstract class HbBaseSessionDataStore
extends HbDataStore
implements SessionFactory,
SessionFactoryImplementor {
    private static final long serialVersionUID = 1L;
    private SessionFactoryImplementor sessionFactory;

    @Override
    public void close() {
        if (this.isInitialized()) {
            this.closeSessionFactory();
            HbHelper.INSTANCE.deRegisterDataStore(this);
        }
    }

    public SessionFactoryImplementor getSessionFactory() {
        if (!this.isInitialized()) {
            this.initialize();
        }
        return this.sessionFactory;
    }

    protected void closeSessionFactory() {
        if (this.sessionFactory != null && !this.sessionFactory.isClosed()) {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
        this.setInitialized(false);
    }

    public void setSessionFactory(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Session getCurrentSession() throws HibernateException {
        return this.getSessionFactory().getCurrentSession();
    }

    public Set getDefinedFilterNames() {
        return this.getSessionFactory().getDefinedFilterNames();
    }

    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        return this.getSessionFactory().getFilterDefinition(filterName);
    }

    public Reference getReference() throws NamingException {
        return this.getSessionFactory().getReference();
    }

    public boolean isClosed() {
        return this.getSessionFactory().isClosed();
    }

    public Session openSession() throws HibernateException {
        return this.getSessionFactory().openSession();
    }

    public Session openSession(Connection connection, Interceptor interceptor) {
        return ((SessionFactoryImpl)this.getSessionFactory()).withOptions().interceptor(interceptor).connection(connection).openSession();
    }

    public Session openSession(Connection connection) {
        return ((SessionFactoryImpl)this.getSessionFactory()).withOptions().connection(connection).openSession();
    }

    public Session openSession(Interceptor interceptor) throws HibernateException {
        return ((SessionFactoryImpl)this.getSessionFactory()).withOptions().interceptor(interceptor).openSession();
    }

    public StatelessSession openStatelessSession() {
        return this.getSessionFactory().openStatelessSession();
    }

    public StatelessSession openStatelessSession(Connection connection) {
        return this.getSessionFactory().openStatelessSession(connection);
    }

    public SessionFactoryImplementor getSessionFactoryImplementor() {
        return this.getSessionFactory();
    }

    public void addObserver(SessionFactoryObserver arg0) {
        this.getSessionFactoryImplementor().addObserver(arg0);
    }

    public boolean containsFetchProfileDefinition(String arg0) {
        return this.getSessionFactoryImplementor().containsFetchProfileDefinition(arg0);
    }

    public CollectionPersister getCollectionPersister(String arg0) throws MappingException {
        return this.getSessionFactoryImplementor().getCollectionPersister(arg0);
    }

    public Set<String> getCollectionRolesByEntityParticipant(String arg0) {
        return this.getSessionFactoryImplementor().getCollectionRolesByEntityParticipant(arg0);
    }

    public CurrentTenantIdentifierResolver getCurrentTenantIdentifierResolver() {
        return this.getSessionFactoryImplementor().getCurrentTenantIdentifierResolver();
    }

    public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy() {
        return this.getSessionFactoryImplementor().getCustomEntityDirtinessStrategy();
    }

    public Dialect getDialect() {
        return this.getSessionFactoryImplementor().getDialect();
    }

    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.getSessionFactoryImplementor().getEntityNotFoundDelegate();
    }

    public EntityPersister getEntityPersister(String arg0) throws MappingException {
        return this.getSessionFactoryImplementor().getEntityPersister(arg0);
    }

    public FetchProfile getFetchProfile(String arg0) {
        return this.getSessionFactoryImplementor().getFetchProfile(arg0);
    }

    public IdentifierGenerator getIdentifierGenerator(String arg0) {
        return this.getSessionFactoryImplementor().getIdentifierGenerator(arg0);
    }

    @Deprecated
    public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return this.getSessionFactoryImplementor().getIdentifierGeneratorFactory();
    }

    public String getIdentifierPropertyName(String arg0) throws MappingException {
        return this.getSessionFactoryImplementor().getIdentifierPropertyName(arg0);
    }

    public Type getIdentifierType(String arg0) throws MappingException {
        return this.getSessionFactoryImplementor().getIdentifierType(arg0);
    }

    public String getImportedClassName(String arg0) {
        return this.getSessionFactoryImplementor().getImportedClassName(arg0);
    }

    public JdbcServices getJdbcServices() {
        return this.getSessionFactoryImplementor().getJdbcServices();
    }

    public NamedQueryDefinition getNamedQuery(String arg0) {
        return this.getSessionFactoryImplementor().getNamedQuery(arg0);
    }

    public NamedSQLQueryDefinition getNamedSQLQuery(String arg0) {
        return this.getSessionFactoryImplementor().getNamedSQLQuery(arg0);
    }

    public QueryPlanCache getQueryPlanCache() {
        return this.getSessionFactoryImplementor().getQueryPlanCache();
    }

    public Type getReferencedPropertyType(String arg0, String arg1) throws MappingException {
        return this.getSessionFactoryImplementor().getReferencedPropertyType(arg0, arg1);
    }

    public ResultSetMappingDefinition getResultSetMapping(String arg0) {
        return this.getSessionFactoryImplementor().getResultSetMapping(arg0);
    }

    public SQLExceptionConverter getSQLExceptionConverter() {
        return this.getSessionFactoryImplementor().getSQLExceptionConverter();
    }

    public SqlExceptionHelper getSQLExceptionHelper() {
        return this.getSessionFactoryImplementor().getSQLExceptionHelper();
    }

    public ServiceRegistryImplementor getServiceRegistry() {
        return this.getSessionFactoryImplementor().getServiceRegistry();
    }

    public SessionFactoryOptions getSessionFactoryOptions() {
        return this.getSessionFactoryImplementor().getSessionFactoryOptions();
    }

    public Settings getSettings() {
        return this.getSessionFactoryImplementor().getSettings();
    }

    public SQLFunctionRegistry getSqlFunctionRegistry() {
        return this.getSessionFactoryImplementor().getSqlFunctionRegistry();
    }

    public StatisticsImplementor getStatisticsImplementor() {
        return this.getSessionFactoryImplementor().getStatisticsImplementor();
    }

    public TypeHelper getTypeHelper() {
        return this.getSessionFactoryImplementor().getTypeHelper();
    }

    public TypeResolver getTypeResolver() {
        return this.getSessionFactoryImplementor().getTypeResolver();
    }

    public Session openTemporarySession() throws HibernateException {
        return this.getSessionFactoryImplementor().openTemporarySession();
    }

    public SessionBuilderImplementor withOptions() {
        return this.getSessionFactoryImplementor().withOptions();
    }

    public StatelessSessionBuilder withStatelessOptions() {
        return this.getSessionFactoryImplementor().withStatelessOptions();
    }

    public Map<String, CollectionPersister> getCollectionPersisters() {
        return this.getSessionFactoryImplementor().getCollectionPersisters();
    }

    public Map<String, EntityPersister> getEntityPersisters() {
        return this.getSessionFactoryImplementor().getEntityPersisters();
    }

    public Iterable<EntityNameResolver> iterateEntityNameResolvers() {
        return this.getSessionFactoryImplementor().iterateEntityNameResolvers();
    }

    public void registerNamedQueryDefinition(String arg0, NamedQueryDefinition arg1) {
        this.getSessionFactoryImplementor().registerNamedQueryDefinition(arg0, arg1);
    }

    public void registerNamedSQLQueryDefinition(String arg0, NamedSQLQueryDefinition arg1) {
        this.getSessionFactoryImplementor().registerNamedSQLQueryDefinition(arg0, arg1);
    }

    public <T> void addNamedEntityGraph(String arg0, EntityGraph<T> arg1) {
        this.getSessionFactory().addNamedEntityGraph(arg0, arg1);
    }

    public void addNamedQuery(String arg0, Query arg1) {
        this.getSessionFactory().addNamedQuery(arg0, arg1);
    }

    public EntityManager createEntityManager() {
        return this.getSessionFactory().createEntityManager();
    }

    public EntityManager createEntityManager(Map arg0) {
        return this.getSessionFactory().createEntityManager(arg0);
    }

    public EntityManager createEntityManager(SynchronizationType arg0, Map arg1) {
        return this.getSessionFactory().createEntityManager(arg0, arg1);
    }

    public EntityManager createEntityManager(SynchronizationType arg0) {
        return this.getSessionFactory().createEntityManager(arg0);
    }

    public CacheImplementor getCache() {
        return this.getSessionFactory().getCache();
    }

    public ClassMetadata getClassMetadata(Class entityClass) {
        return this.getSessionFactory().getClassMetadata(entityClass);
    }

    public ClassMetadata getClassMetadata(String entityName) {
        return this.getSessionFactory().getClassMetadata(entityName);
    }

    public SessionFactoryImplementor.DeserializationResolver getDeserializationResolver() {
        return this.getSessionFactory().getDeserializationResolver();
    }

    public CollectionMetadata getCollectionMetadata(String roleName) {
        return this.getSessionFactory().getCollectionMetadata(roleName);
    }

    public Map<String, ClassMetadata> getAllClassMetadata() {
        return this.getSessionFactory().getAllClassMetadata();
    }

    public Map getAllCollectionMetadata() {
        return this.getSessionFactory().getAllCollectionMetadata();
    }

    public <T> List<EntityGraph<? super T>> findEntityGraphsByType(Class<T> entityClass) {
        return this.getSessionFactory().findEntityGraphsByType(entityClass);
    }

    public <T> List<RootGraphImplementor<? super T>> findEntityGraphsByJavaType(Class<T> entityClass) {
        return this.getSessionFactory().findEntityGraphsByJavaType(entityClass);
    }

    public RootGraphImplementor<?> findEntityGraphByName(String name) {
        return this.getSessionFactory().findEntityGraphByName(name);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.getSessionFactory().getCriteriaBuilder();
    }

    public Type resolveParameterBindType(Object bindValue) {
        return this.getSessionFactory().resolveParameterBindType(bindValue);
    }

    public Type resolveParameterBindType(Class clazz) {
        return this.getSessionFactory().resolveParameterBindType(clazz);
    }

    public String getUuid() {
        return this.getSessionFactory().getUuid();
    }

    public StatisticsImplementor getStatistics() {
        return this.getSessionFactory().getStatistics();
    }

    public EventEngine getEventEngine() {
        return this.getSessionFactory().getEventEngine();
    }

    public NamedQueryRepository getNamedQueryRepository() {
        return this.getSessionFactory().getNamedQueryRepository();
    }

    public FastSessionServices getFastSessionServices() {
        return this.getSessionFactory().getFastSessionServices();
    }

    public Type[] getReturnTypes(String queryString) {
        return this.getSessionFactory().getReturnTypes(queryString);
    }

    public MetamodelImplementor getMetamodel() {
        return this.getSessionFactory().getMetamodel();
    }

    public String[] getImplementors(String entityName) {
        return this.getSessionFactory().getImplementors(entityName);
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.getSessionFactory().getPersistenceUnitUtil();
    }

    public Map<String, Object> getProperties() {
        return this.getSessionFactory().getProperties();
    }

    public String[] getReturnAliases(String queryString) {
        return this.getSessionFactory().getReturnAliases(queryString);
    }

    public boolean isOpen() {
        return this.getSessionFactory().isOpen();
    }

    public EntityPersister locateEntityPersister(Class byClass) {
        return this.getSessionFactory().locateEntityPersister(byClass);
    }

    public EntityPersister locateEntityPersister(String byName) {
        return this.getSessionFactory().locateEntityPersister(byName);
    }

    public <T> T unwrap(Class<T> arg0) {
        return (T)this.getSessionFactory().unwrap(arg0);
    }
}

