/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.GaugeData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.data.SumData;
import io.opentelemetry.sdk.metrics.export.CollectionRegistration;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.Assert;

public class InMemoryMetricReader
implements MetricReader {
    private static InMemoryMetricReader instance;
    private CollectionRegistration collectionRegistration;
    private boolean isShutdown = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InMemoryMetricReader current() {
        Class<InMemoryMetricReader> clazz = InMemoryMetricReader.class;
        synchronized (InMemoryMetricReader.class) {
            if (instance == null) {
                instance = new InMemoryMetricReader();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return AggregationTemporality.CUMULATIVE;
    }

    public void register(CollectionRegistration registration) {
        if (this.isShutdown) {
            throw new IllegalStateException("InMemoryMetricReader has been shutdown");
        }
        this.collectionRegistration = registration;
    }

    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableResultCode shutdown() {
        this.collectionRegistration = null;
        this.isShutdown = true;
        Class<InMemoryMetricReader> clazz = InMemoryMetricReader.class;
        synchronized (InMemoryMetricReader.class) {
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return CompletableResultCode.ofSuccess();
        }
    }

    public Optional<MetricData> getMetric(TelemetryMetricID id) {
        Optional<MetricData> result = this.getMetric(id.name);
        result.ifPresent(md -> InMemoryMetricReader.validateMetricType(md, id));
        return result;
    }

    private Optional<MetricData> getMetric(String name) {
        if (this.collectionRegistration == null) {
            throw new IllegalStateException("InMemoryMetricReader has not been registered");
        }
        Collection allMetrics = this.collectionRegistration.collectAllMetrics();
        List matchingMetrics = allMetrics.stream().filter(md -> md.getName().equals(name)).collect(Collectors.toList());
        MatcherAssert.assertThat((String)("More than one MetricData found for name: " + name), matchingMetrics, (Matcher)Matchers.hasSize((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(2))));
        return matchingMetrics.isEmpty() ? Optional.empty() : Optional.of((MetricData)matchingMetrics.get(0));
    }

    public long readLongData(TelemetryMetricID id) {
        return this.getMetric(id).flatMap(md -> InMemoryMetricReader.getLongPointData(md, id)).map(LongPointData::getValue).orElse(0L);
    }

    public String getUnit(String metricName) {
        return this.getMetric(metricName).orElseThrow(() -> new IllegalStateException("No metric found for name: " + metricName)).getUnit();
    }

    public static Optional<LongPointData> getLongPointData(MetricData md, TelemetryMetricID id) {
        switch (md.getType()) {
            case LONG_GAUGE: {
                GaugeData gaugeData = md.getLongGaugeData();
                return InMemoryMetricReader.getGaugePointData(gaugeData, id);
            }
            case LONG_SUM: {
                SumData sumData = md.getLongSumData();
                return InMemoryMetricReader.getSumPointData(sumData, id);
            }
        }
        throw new IllegalStateException("Metric " + id.name + " does not have long type data");
    }

    public static Optional<HistogramPointData> getHistogramPointData(MetricData md, TelemetryMetricID id) {
        Assert.assertEquals((Object)md.getType(), (Object)MetricDataType.HISTOGRAM, (String)("Metric " + id.name + " is not a histogram"));
        Assert.assertEquals((Object)md.getHistogramData().getAggregationTemporality(), (Object)AggregationTemporality.CUMULATIVE, (String)("Metric " + id.name + " has wrong temporality"));
        List data = md.getHistogramData().getPoints().stream().filter(InMemoryMetricReader.hasAllAttributes(id.attributes)).collect(Collectors.toList());
        MatcherAssert.assertThat((String)("Found more than one data point for metric: " + id), data, (Matcher)Matchers.hasSize((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(2))));
        return data.isEmpty() ? Optional.empty() : Optional.of((HistogramPointData)data.get(0));
    }

    private static <T extends PointData> Optional<T> getGaugePointData(GaugeData<T> gaugeData, TelemetryMetricID id) {
        List data = gaugeData.getPoints().stream().filter(InMemoryMetricReader.hasAllAttributes(id.attributes)).collect(Collectors.toList());
        MatcherAssert.assertThat((String)("Found more than one data point for metric: " + id), data, (Matcher)Matchers.hasSize((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(2))));
        return data.isEmpty() ? Optional.empty() : Optional.of((PointData)data.get(0));
    }

    private static <T extends PointData> Optional<T> getSumPointData(SumData<T> sumData, TelemetryMetricID id) {
        Assert.assertEquals((Object)sumData.getAggregationTemporality(), (Object)AggregationTemporality.CUMULATIVE, (String)("Wrong temporality type for metric " + id.name));
        List data = sumData.getPoints().stream().filter(InMemoryMetricReader.hasAllAttributes(id.attributes)).collect(Collectors.toList());
        MatcherAssert.assertThat((String)("Found more than one data point for metric: " + id), data, (Matcher)Matchers.hasSize((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(2))));
        return data.isEmpty() ? Optional.empty() : Optional.of((PointData)data.get(0));
    }

    static Predicate<PointData> hasAllAttributes(Attributes attributes) {
        return pointData -> {
            for (Map.Entry e : attributes.asMap().entrySet()) {
                if (!pointData.getAttributes().asMap().containsKey(e.getKey())) {
                    return false;
                }
                if (Objects.equals(pointData.getAttributes().get((AttributeKey)e.getKey()), e.getValue())) continue;
                return false;
            }
            return true;
        };
    }

    private static void validateMetricType(MetricData md, TelemetryMetricID id) {
        switch (id.type) {
            case COUNTER: {
                Assert.assertEquals((Object)md.getType(), (Object)MetricDataType.LONG_SUM, (String)("Wrong type for metric " + id.name));
                Assert.assertTrue((boolean)md.getLongSumData().isMonotonic(), (String)("Metric is not monotonic: " + id.name));
                break;
            }
            case UPDOWNCOUNTER: {
                Assert.assertEquals((Object)md.getType(), (Object)MetricDataType.LONG_SUM, (String)("Wrong type for metric " + id.name));
                Assert.assertFalse((boolean)md.getLongSumData().isMonotonic(), (String)("Metric should not be monotonic: " + id.name));
                break;
            }
            case GAUGE: {
                Assert.assertEquals((Object)md.getType(), (Object)MetricDataType.LONG_GAUGE, (String)("Wrong type for metric " + id.name));
                break;
            }
            case HISTOGRAM: {
                Assert.assertEquals((Object)md.getType(), (Object)MetricDataType.HISTOGRAM, (String)("Wrong type for metric " + id.name));
                break;
            }
            default: {
                throw new IllegalStateException("Invalid metric type: " + (Object)((Object)id.type));
            }
        }
    }
}

