/**
 * Copyright (c) 2016-2018 TypeFox and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j;

import java.util.List;
import org.eclipse.lsp4j.jsonrpc.ProtocolDraft;
import org.eclipse.lsp4j.jsonrpc.ProtocolSince;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;

/**
 * The client supports the following {@link CompletionList} specific
 * capabilities.
 */
@ProtocolSince("3.17.0")
@SuppressWarnings("all")
public class CompletionListCapabilities {
  /**
   * The client supports the following itemDefaults on
   * a completion list.
   * <p>
   * The value lists the supported property names of the
   * {@link CompletionList#itemDefaults} object. If omitted,
   * no properties are supported.
   */
  private List<String> itemDefaults;

  /**
   * Specifies whether the client supports {@link CompletionList#applyKind} to
   * indicate how supported values from {@link CompletionList#itemDefaults}
   * and a completion will be combined.
   * <p>
   * If a client supports {@link CompletionList#applyKind} it must support it
   * for all fields that it supports that are listed in {@link CompletionApplyKind}.
   * This means when clients add support for new/future fields in completion items
   * they MUST also support merge for them if those fields are defined in
   * {@link CompletionApplyKind}.
   */
  @ProtocolDraft
  @ProtocolSince("3.18.0")
  private Boolean applyKindSupport;

  public CompletionListCapabilities() {
  }

  public CompletionListCapabilities(final List<String> itemDefaults) {
    this.itemDefaults = itemDefaults;
  }

  /**
   * The client supports the following itemDefaults on
   * a completion list.
   * <p>
   * The value lists the supported property names of the
   * {@link CompletionList#itemDefaults} object. If omitted,
   * no properties are supported.
   */
  public List<String> getItemDefaults() {
    return this.itemDefaults;
  }

  /**
   * The client supports the following itemDefaults on
   * a completion list.
   * <p>
   * The value lists the supported property names of the
   * {@link CompletionList#itemDefaults} object. If omitted,
   * no properties are supported.
   */
  public void setItemDefaults(final List<String> itemDefaults) {
    this.itemDefaults = itemDefaults;
  }

  /**
   * Specifies whether the client supports {@link CompletionList#applyKind} to
   * indicate how supported values from {@link CompletionList#itemDefaults}
   * and a completion will be combined.
   * <p>
   * If a client supports {@link CompletionList#applyKind} it must support it
   * for all fields that it supports that are listed in {@link CompletionApplyKind}.
   * This means when clients add support for new/future fields in completion items
   * they MUST also support merge for them if those fields are defined in
   * {@link CompletionApplyKind}.
   */
  @ProtocolDraft
  @ProtocolSince("3.18.0")
  public Boolean getApplyKindSupport() {
    return this.applyKindSupport;
  }

  /**
   * Specifies whether the client supports {@link CompletionList#applyKind} to
   * indicate how supported values from {@link CompletionList#itemDefaults}
   * and a completion will be combined.
   * <p>
   * If a client supports {@link CompletionList#applyKind} it must support it
   * for all fields that it supports that are listed in {@link CompletionApplyKind}.
   * This means when clients add support for new/future fields in completion items
   * they MUST also support merge for them if those fields are defined in
   * {@link CompletionApplyKind}.
   */
  @ProtocolDraft
  @ProtocolSince("3.18.0")
  public void setApplyKindSupport(final Boolean applyKindSupport) {
    this.applyKindSupport = applyKindSupport;
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("itemDefaults", this.itemDefaults);
    b.add("applyKindSupport", this.applyKindSupport);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    CompletionListCapabilities other = (CompletionListCapabilities) obj;
    if (this.itemDefaults == null) {
      if (other.itemDefaults != null)
        return false;
    } else if (!this.itemDefaults.equals(other.itemDefaults))
      return false;
    if (this.applyKindSupport == null) {
      if (other.applyKindSupport != null)
        return false;
    } else if (!this.applyKindSupport.equals(other.applyKindSupport))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.itemDefaults== null) ? 0 : this.itemDefaults.hashCode());
    return prime * result + ((this.applyKindSupport== null) ? 0 : this.applyKindSupport.hashCode());
  }
}
