/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.parser;

import java.util.Objects;
import org.commonmark.node.SourceSpan;

public class SourceLine {
    private final CharSequence content;
    private final SourceSpan sourceSpan;

    public static SourceLine of(CharSequence content, SourceSpan sourceSpan) {
        return new SourceLine(content, sourceSpan);
    }

    private SourceLine(CharSequence content, SourceSpan sourceSpan) {
        this.content = Objects.requireNonNull(content, "content must not be null");
        this.sourceSpan = sourceSpan;
    }

    public CharSequence getContent() {
        return this.content;
    }

    public SourceSpan getSourceSpan() {
        return this.sourceSpan;
    }

    public SourceLine substring(int beginIndex, int endIndex) {
        int length;
        CharSequence newContent = this.content.subSequence(beginIndex, endIndex);
        SourceSpan newSourceSpan = null;
        if (this.sourceSpan != null && (length = endIndex - beginIndex) != 0) {
            int columnIndex = this.sourceSpan.getColumnIndex() + beginIndex;
            int inputIndex = this.sourceSpan.getInputIndex() + beginIndex;
            newSourceSpan = SourceSpan.of(this.sourceSpan.getLineIndex(), columnIndex, inputIndex, length);
        }
        return SourceLine.of(newContent, newSourceSpan);
    }
}

