/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.utils;

import java.lang.reflect.Method;
import org.eclipse.core.resources.IProject;
import org.eclipse.lsp4e.test.utils.AbstractTest;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

public abstract class AbstractTestWithProject
extends AbstractTest {
    protected IProject project;

    @BeforeEach
    public void setUpProject(TestInfo testInfo) throws Exception {
        String testClass = testInfo.getTestClass().map(Class::getSimpleName).orElse("UnknownTestClass");
        String testMethod = testInfo.getTestMethod().map(Method::getName).orElse("UnknownTestMethod");
        String projectName = testClass + "_" + testMethod + "_" + System.currentTimeMillis();
        this.project = TestUtils.createProject(projectName);
    }

    @AfterEach
    public void tearDownProject() throws Exception {
        if (this.project != null) {
            this.project.delete(1, null);
        }
    }
}

