/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package distributions.math;

import org.apache.commons.math3.distribution.GammaDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.random.RandomGenerator;

public class GammaModeDistribution extends GammaDistribution implements ModeDistribution {
    private static final long serialVersionUID = 1L;

    private final Double itsDefault;

    public GammaModeDistribution(RandomGenerator rng, double shape, double scale, Double inverseCumAccuracy,
            Double _default) throws NotStrictlyPositiveException
    {
        super(rng, shape, scale,
                inverseCumAccuracy == null
                        ? org.apache.commons.math3.distribution.GammaDistribution.DEFAULT_INVERSE_ABSOLUTE_ACCURACY
                        : inverseCumAccuracy);
        itsDefault = _default;
    }

    /**
     * Mode equals numerical mean for a gamma distribution
     *
     * @see distributions.math.ModeDistribution#getMode()
     */
    @Override
    public double getMode() {
        return getNumericalMean();
    }

    @Override
    public double getDefault() {
        if (null != itsDefault) {
            return itsDefault;
        }
        return getNumericalMean();
    }

    @Override
    public double getLowerBound() {
        return getSupportLowerBound();
    }

    @Override
    public double getUpperBound() {
        return getSupportUpperBound();
    }

    @Override
    public double nextSample() {
        return sample();
    }

    @Override
    public double[] nextSamples(int sampleSize) {
        return sample(sampleSize);
    }
}
