/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.conformance.ui;

import activity.ActivitySet;
import activity.util.Event2Resource;
import activity.util.PassiveClaimTransformer;
import common.ImportContainer;
import common.util.ImportsFlattener;
import dispatching.ActivityDispatching;
import dispatching.util.DispatchingUtil;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.lsat.common.emf.common.util.URIHelper;
import org.eclipse.lsat.common.emf.ecore.resource.Persistor;
import org.eclipse.lsat.common.emf.ecore.resource.PersistorFactory;
import org.eclipse.lsat.common.emf.ecore.resource.ResourceSetUtil;
import org.eclipse.lsat.common.qvto.util.QvtoTransformationException;
import org.eclipse.lsat.conformance.ConformanceCheckInput;
import org.eclipse.lsat.conformance.ConformanceCheckJava;
import org.eclipse.lsat.conformance.Dispatching2PetriNet;
import org.eclipse.lsat.conformance.ui.Activator;
import org.eclipse.lsat.conformance.ui.ConformanceCheckOptions;
import org.eclipse.lsat.petri_net.PetriNet;
import org.eclipse.lsat.trace.TraceModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class ConformanceCheckJob
extends Job {
    private final PersistorFactory factory = new PersistorFactory();
    private final ConformanceCheckOptions options;
    private final UISynchronize sync;
    private final Shell shell;

    public ConformanceCheckJob(ConformanceCheckOptions options, UISynchronize sync, Shell shell) {
        super("ConformanceCheckJob");
        this.options = options;
        this.sync = sync;
        this.shell = shell;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Performing conformance check on specification", 100);
            URI modelURI = URIHelper.asURI((IResource)this.options.getModelFile());
            IFolder saveIFolder = this.options.getModelFile().getProject().getFolder("analysis").getFolder("conformance");
            URI saveFolderURI = URIHelper.asURI((IResource)saveIFolder);
            URI saveBaseURI = saveFolderURI.appendSegment(URIHelper.baseName((URI)modelURI));
            URI intermediateURI = URIHelper.asURI((IResource)saveIFolder).appendSegment(".intermediate").appendSegment(URIHelper.baseName((URI)modelURI));
            Persistor savePersistor = this.factory.getPersistor(EObject.class);
            monitor.subTask("Creating a petri net from specification " + this.options.getModelFile().getName());
            Persistor dispatchingPersistor = this.factory.getPersistor(ActivityDispatching.class);
            ActivityDispatching activityDispatching = (ActivityDispatching)dispatchingPersistor.loadOne(modelURI);
            ResourceSet resourceSet = ImportsFlattener.flatten((URI)intermediateURI, (ImportContainer[])new ImportContainer[]{activityDispatching});
            activityDispatching = (ActivityDispatching)ResourceSetUtil.getObjectByType((ResourceSet)resourceSet, ActivityDispatching.class);
            ActivitySet activitySet = (ActivitySet)ResourceSetUtil.getObjectByType((ResourceSet)resourceSet, ActivitySet.class);
            Event2Resource.replaceEventsWithClaimRelease((ActivitySet)activitySet);
            PassiveClaimTransformer.transform((ActivitySet)activitySet);
            DispatchingUtil.expand((ActivityDispatching)activityDispatching);
            DispatchingUtil.removeUnusedActivities((ActivityDispatching)activityDispatching);
            Dispatching2PetriNet dispatching2PetriNet = new Dispatching2PetriNet(this.options.isDipatchingLoop());
            PetriNet petriNet = (PetriNet)dispatching2PetriNet.transformModel((Object)activityDispatching, monitor);
            if (Activator.DEBUG) {
                savePersistor.save(saveBaseURI.appendFileExtension("petrinet"), new EObject[]{petriNet});
            }
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            monitor.worked(40);
            monitor.subTask("Running conformance check on petri net");
            ConformanceCheckInput conformanceCheckInput = new ConformanceCheckInput(petriNet);
            Persistor tpPersistor = this.factory.getPersistor(TraceModel.class);
            for (IFile traceFile : this.options.getTraceFiles()) {
                URI traceURI = URIHelper.asURI((IResource)traceFile);
                conformanceCheckInput.getTraces().add((TraceModel)tpPersistor.loadOne(traceURI));
            }
            try {
                ConformanceCheckJava conformanceCheck = new ConformanceCheckJava(this.options.getConformanceLevel());
                petriNet = conformanceCheck.transformModel(conformanceCheckInput);
                if (Activator.DEBUG) {
                    savePersistor.save(saveBaseURI.appendFileExtension("petrinet"), new EObject[]{petriNet});
                }
            }
            catch (QvtoTransformationException e) {
                savePersistor.save(saveBaseURI.appendFileExtension("petrinet"), new EObject[]{petriNet});
                throw e;
            }
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            monitor.worked(60);
            this.sync.asyncExec(new Runnable(){

                @Override
                public void run() {
                    new SuccessDialog(ConformanceCheckJob.this.shell, "Perform conformance check on specification", "The trace(s) conform to the specification").open();
                }
            });
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.lsat.conformance.ui", e.getMessage(), (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
    }

    private static class SuccessDialog
    extends MessageDialog {
        public SuccessDialog(Shell parent, String title, String message) {
            super(parent, title, null, message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        }

        public Image getInfoImage() {
            Optional imageDescriptor = ResourceLocator.imageDescriptorFromBundle(SuccessDialog.class, (String)"icons/run_wiz.png");
            return imageDescriptor.isPresent() ? ((ImageDescriptor)imageDescriptor.get()).createImage() : super.getInfoImage();
        }
    }
}

