/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.emf.ecore.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsat.common.emf.ecore.resource.ResourceRenameFilter;

public final class ResourceSetUtil {
    public static final Object OPTION_RESOURCE_RENAME_FILTER = ResourceRenameFilter.class;
    public static final Object OPTION_PROGRESS_MONITOR = IProgressMonitor.class;

    private ResourceSetUtil() {
    }

    public static URI[] getNormalizedResourceURIs(ResourceSet aResourceSet) {
        EList resources = aResourceSet.getResources();
        URI[] result = new URI[resources.size()];
        int i = 0;
        while (i < resources.size()) {
            result[i] = aResourceSet.getURIConverter().normalize(((Resource)resources.get(i)).getURI());
            ++i;
        }
        return result;
    }

    public static void saveResources(ResourceSet aResourceSet, Map<?, ?> aOptions) throws IOException {
        IProgressMonitor progressMonitor = ResourceSetUtil.getProgressMonitor(aOptions);
        try {
            List<Resource> resources = ResourceSetUtil.getResourcesInSaveOrder(aResourceSet);
            progressMonitor.beginTask("Saving resources", resources.size());
            for (Resource resource : resources) {
                if (!resource.isLoaded()) continue;
                progressMonitor.subTask("Saving resource: " + String.valueOf(resource.getURI()));
                ResourceSetUtil.saveResource(resource, aOptions);
                progressMonitor.worked(1);
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private static IProgressMonitor getProgressMonitor(Map<?, ?> aOptions) {
        IProgressMonitor progressMonitor = aOptions == null ? null : (IProgressMonitor)aOptions.get(OPTION_PROGRESS_MONITOR);
        return progressMonitor == null ? new NullProgressMonitor() : progressMonitor;
    }

    public static void saveResource(Resource aResource, Map<?, ?> aOptions) throws IOException {
        URI normalizedURI;
        ResourceRenameFilter renameFilter;
        ResourceRenameFilter resourceRenameFilter = renameFilter = aOptions == null ? null : (ResourceRenameFilter)aOptions.get(OPTION_RESOURCE_RENAME_FILTER);
        if (renameFilter == null) {
            aResource.save(aOptions);
            return;
        }
        ResourceSet resourceSet = aResource.getResourceSet();
        URI resourceURI = aResource.getURI();
        boolean map = !resourceURI.equals(normalizedURI = resourceSet.getURIConverter().normalize(resourceURI));
        URI saveURI = renameFilter.renameAccept(normalizedURI);
        if (saveURI == null) {
            return;
        }
        if (saveURI.equals(normalizedURI)) {
            aResource.save(aOptions);
        } else if (map) {
            resourceSet.getURIConverter().getURIMap().put(resourceURI, saveURI);
            aResource.save(aOptions);
        } else {
            Resource saveResource = resourceSet.createResource(saveURI);
            saveResource.getContents().addAll((Collection)aResource.getContents());
            saveResource.save(aOptions);
            aResource.unload();
        }
    }

    public static List<Resource> getResourcesInSaveOrder(ResourceSet resourceSet) {
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        HashMap references = new HashMap();
        for (Resource resource : resourceSet.getResources()) {
            if (!references.containsKey(resource)) {
                references.put(resource, new HashSet());
            }
            if (!resource.isLoaded()) continue;
            for (EObject reference : EcoreUtil.ExternalCrossReferencer.find((Resource)resource).keySet()) {
                if (reference.eResource() == null) continue;
                if (!references.containsKey(reference.eResource())) {
                    references.put(reference.eResource(), new HashSet());
                }
                ((Set)references.get(reference.eResource())).add(resource);
            }
        }
        ArrayList<Resource> ordered = new ArrayList<Resource>(references.size());
        while (!references.isEmpty()) {
            Resource resourceWithoutReferences = null;
            for (Map.Entry resource : references.entrySet()) {
                if (!((Set)resource.getValue()).isEmpty()) continue;
                resourceWithoutReferences = (Resource)resource.getKey();
                break;
            }
            if (resourceWithoutReferences == null) {
                throw new IllegalArgumentException("Found dependency cycle in resources: " + String.valueOf(references));
            }
            ordered.add(0, resourceWithoutReferences);
            references.remove(resourceWithoutReferences);
            for (Set refs : references.values()) {
                refs.remove(resourceWithoutReferences);
            }
        }
        return ordered;
    }

    public static <T extends EObject> List<T> getObjectsByType(ResourceSet resourceSet, Class<T> clazz) {
        return resourceSet.getResources().stream().flatMap(r -> r.getContents().stream()).filter(c -> clazz.isInstance(c)).map(c -> (EObject)clazz.cast(c)).collect(Collectors.toList());
    }

    public static <T extends EObject> T getObjectByType(ResourceSet resourceSet, Class<T> clazz) {
        return (T)resourceSet.getResources().stream().flatMap(r -> r.getContents().stream()).filter(c -> clazz.isInstance(c)).map(c -> (EObject)clazz.cast(c)).findFirst().orElseGet(null);
    }
}

