/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class RangeMapDeserializer<T extends RangeMap<Comparable<?>, Object>>
extends StdDeserializer<T>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    private static final List<String> METHOD_NAMES = ImmutableList.of((Object)"copyOf", (Object)"create");
    private final MapLikeType type;
    private final KeyDeserializer keyDeserializer;
    private final TypeDeserializer elementTypeDeserializer;
    private final JsonDeserializer<?> elementDeserializer;
    private final NullValueProvider nullProvider;
    private final boolean isImmutable;
    private final boolean skipNullValues;
    private final Method creatorMethod;

    public RangeMapDeserializer(MapLikeType type, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer, boolean isImmutable) {
        this(type, keyDeserializer, elementTypeDeserializer, elementDeserializer, RangeMapDeserializer.findTransformer(type.getRawClass()), null, isImmutable);
    }

    public RangeMapDeserializer(MapLikeType type, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer, Method creatorMethod, NullValueProvider nvp, boolean isImmutable) {
        super((JavaType)type);
        this.type = type;
        this.keyDeserializer = keyDeserializer;
        this.elementTypeDeserializer = elementTypeDeserializer;
        this.elementDeserializer = elementDeserializer;
        this.creatorMethod = creatorMethod;
        this.nullProvider = nvp;
        this.isImmutable = isImmutable;
        this.skipNullValues = nvp == null ? false : NullsConstantProvider.isSkipper((NullValueProvider)nvp);
    }

    private static Method findTransformer(Class<?> rawType) {
        Method m2;
        if (rawType == TreeRangeMap.class) {
            return null;
        }
        for (String methodName : METHOD_NAMES) {
            try {
                m2 = rawType.getDeclaredMethod(methodName, RangeMap.class);
                if (m2 == null) continue;
                return m2;
            }
            catch (NoSuchMethodException m2) {
            }
        }
        for (String methodName : METHOD_NAMES) {
            try {
                m2 = rawType.getMethod(methodName, RangeMap.class);
                if (m2 == null) continue;
                return m2;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    public LogicalType logicalType() {
        return LogicalType.Map;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        KeyDeserializer kd = this.keyDeserializer;
        if (kd == null) {
            kd = ctxt.findKeyDeserializer(this.type.getKeyType(), property);
        }
        JsonDeserializer valueDeser = this.elementDeserializer;
        JavaType vt = this.type.getContentType();
        valueDeser = valueDeser == null ? ctxt.findContextualValueDeserializer(vt, property) : ctxt.handleSecondaryContextualization(valueDeser, property, vt);
        TypeDeserializer vtd = this.elementTypeDeserializer;
        if (vtd != null) {
            vtd = vtd.forProperty(property);
        }
        return new RangeMapDeserializer<T>(this.type, kd, vtd, valueDeser, this.creatorMethod, this.findContentNullProvider(ctxt, property, valueDeser), this.isImmutable);
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        TreeRangeMap rangeMap = TreeRangeMap.create();
        JsonToken currToken = p.currentToken();
        if (currToken != JsonToken.FIELD_NAME && currToken != JsonToken.END_OBJECT) {
            this.expect(p, JsonToken.START_OBJECT);
            currToken = p.nextToken();
        }
        while (currToken == JsonToken.FIELD_NAME) {
            block8: {
                Object value;
                Range key;
                block9: {
                    block7: {
                        key = (Range)this.keyDeserializer.deserializeKey(p.currentName(), ctxt);
                        p.nextToken();
                        if (p.currentToken() != JsonToken.VALUE_NULL) break block7;
                        if (this.skipNullValues) break block8;
                        value = this.nullProvider.getNullValue(ctxt);
                        break block9;
                    }
                    value = this.elementTypeDeserializer != null ? this.elementDeserializer.deserializeWithType(p, ctxt, this.elementTypeDeserializer) : this.elementDeserializer.deserialize(p, ctxt);
                }
                rangeMap.put(key, value);
            }
            currToken = p.nextToken();
        }
        if (this.creatorMethod == null) {
            return (T)rangeMap;
        }
        try {
            RangeMap map = (RangeMap)this.creatorMethod.invoke(null, rangeMap);
            return (T)map;
        }
        catch (InvocationTargetException e) {
            throw new JsonMappingException((Closeable)p, "Could not map to " + this.type, this._peel(e));
        }
        catch (IllegalArgumentException e) {
            throw new JsonMappingException((Closeable)p, "Could not map to " + this.type, this._peel(e));
        }
        catch (IllegalAccessException e) {
            throw new JsonMappingException((Closeable)p, "Could not map to " + this.type, this._peel(e));
        }
    }

    private void expect(JsonParser p, JsonToken token) throws IOException {
        if (p.currentToken() != token) {
            throw new JsonMappingException((Closeable)p, "Expecting " + token + " to start `RangeMap` value, found " + p.currentToken(), p.currentLocation());
        }
    }

    private Throwable _peel(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }
}

