/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.types;

import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.types.AnotherCalendarService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.types.AnotherDeliveryService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.types.CalendarService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.types.Delivery;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.types.DeliveryService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.types.Event;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.types.OfflineCalendarService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.types.OnlineCalendarService;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.types.ValidObject;
import org.hibernate.beanvalidation.tck.tests.integration.cdi.executable.types.YetAnotherCalendarService;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.IntegrationTest;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@IntegrationTest
@SpecVersion(spec="beanvalidation", version="4.0.0")
public class ExecutableTypesTest
extends AbstractTCKTest {
    @Inject
    private CalendarService calendar;
    @Inject
    private Instance<OnlineCalendarService> onlineCalendar;
    @Inject
    private Instance<OfflineCalendarService> offlineCalendar;
    @Inject
    private Instance<AnotherCalendarService> anotherCalendar;
    @Inject
    private Instance<YetAnotherCalendarService> yetAnotherCalendar;
    @Inject
    private DeliveryService deliveryService;
    @Inject
    private Instance<AnotherDeliveryService> anotherDeliveryService;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ExecutableTypesTest.webArchiveBuilder().withTestClassPackage(ExecutableTypesTest.class)).withBeansXml().build();
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="i")
    public void testValidationOfConstrainedMethodWithExecutableTypeNONE() {
        Event event = this.calendar.createEvent(null);
        Assert.assertNotNull((Object)event);
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="i")
    public void testValidationOfConstrainedMethodWithEmptyExecutableTypes() {
        Event event = this.calendar.createEvent(-10);
        Assert.assertNotNull((Object)event);
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="i")
    public void testValidationOfConstrainedMethodWithExecutableTypeNONEAndOther() {
        try {
            this.calendar.createEvent(-10L);
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="j")
    public void testValidationOfConstrainedConstructorParametersWithExecutableTypeCONSTRUCTORS() {
        try {
            this.onlineCalendar.get();
            Assert.fail((String)"Constructor invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="j")
    public void testValidationOfConstrainedConstructorReturnValueWithExecutableTypeCONSTRUCTORS() {
        try {
            this.offlineCalendar.get();
            Assert.fail((String)"Constructor invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidObject.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="j")
    public void testValidationOfConstrainedConstructorWithoutExecutableTypeCONSTRUCTORS() {
        AnotherCalendarService calendar = (AnotherCalendarService)this.anotherCalendar.get();
        Assert.assertNotNull((Object)calendar);
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="k")
    public void testValidationOfConstrainedMethodParametersWithExecutableTypeNON_GETTER_METHODS() {
        try {
            this.calendar.createEvent((short)-10);
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="k")
    public void testValidationOfConstrainedMethodReturnValueWithExecutableTypeNON_GETTER_METHODS() {
        try {
            this.calendar.createEvent((byte)-10);
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidObject.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="k")
    public void testValidationOfConstrainedGetterWithExecutableTypeNON_GETTER_METHODS() {
        Event event = this.calendar.getEvent();
        Assert.assertNotNull((Object)event);
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="l")
    public void testValidationOfConstrainedGetterReturnValueWithExecutableTypeGETTER_METHODS() {
        try {
            this.calendar.getSpecialEvent();
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidObject.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="l")
    public void testValidationOfConstrainedMethodWithExecutableTypeGETTER_METHODS() {
        Event event = this.calendar.getSpecialEvent(0);
        Assert.assertNotNull((Object)event);
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="m")
    public void testValidationOfConstrainedMethodWithExecutableTypeALL() {
        try {
            this.calendar.createEvent(-10.0);
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="m")
    public void testValidationOfConstrainedGetterWithExecutableTypeALL() {
        try {
            this.calendar.getVerySpecialEvent();
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(ValidObject.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="m")
    public void testValidationOfConstrainedConstructorWithExecutableTypeALL() {
        try {
            this.yetAnotherCalendar.get();
            Assert.fail((String)"Constructor invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="m")
    public void testValidationOfConstrainedMethodWithExecutableTypesALLAndNONE() {
        try {
            this.calendar.createEvent(-10.0f);
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(Min.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="n")
    public void testValidationOfConstrainedMethodWithExecutableTypeIMPLICIT() {
        try {
            this.deliveryService.findDelivery(null);
            Assert.fail((String)"Method invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="n")
    public void testValidationOfConstrainedGetterWithExecutableTypeIMPLICIT() {
        try {
            this.deliveryService.getDelivery();
            Assert.fail((String)"Getter invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class));
        }
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="n")
    public void testValidationOfConstrainedGetterWithExecutableTypeIMPLICITOnTypeLevel() {
        Delivery delivery = this.deliveryService.getAnotherDelivery();
        Assert.assertNull((Object)delivery);
    }

    @Test
    @SpecAssertion(section="integration-general-executable", id="n")
    public void testValidationOfConstrainedConstructorWithExecutableTypeIMPLICIT() {
        try {
            this.anotherDeliveryService.get();
            Assert.fail((String)"Constructor invocation should have caused a ConstraintViolationException");
        }
        catch (ConstraintViolationException e) {
            ConstraintViolationAssert.assertThat(e.getConstraintViolations()).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class));
        }
    }
}

