/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import jakarta.validation.Validator;
import jakarta.validation.constraints.Negative;
import jakarta.validation.constraints.NegativeOrZero;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class NegativePositiveConstraintsTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)NegativePositiveConstraintsTest.webArchiveBuilder().withTestClass(NegativePositiveConstraintsTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-negative", id="a")})
    public void testNegativeConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        NegativeEntity dummy = new NegativeEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Negative.class).withProperty("bytePrimitive"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("intPrimitive"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("longPrimitive"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("shortPrimitive"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("doublePrimitive"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("floatPrimitive"));
        dummy.intPrimitive = 101;
        dummy.longPrimitive = 1001L;
        dummy.bytePrimitive = (byte)111;
        dummy.shortPrimitive = (short)142;
        dummy.doublePrimitive = 123.34;
        dummy.floatPrimitive = 456.34f;
        dummy.intObject = 100;
        dummy.longObject = 15678L;
        dummy.byteObject = 50;
        dummy.shortObject = 3;
        dummy.doubleObject = 123.34;
        dummy.floatObject = Float.valueOf(5678.56f);
        dummy.bigDecimal = BigDecimal.valueOf(100.9);
        dummy.bigInteger = BigInteger.valueOf(100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Negative.class).withProperty("bytePrimitive"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("intPrimitive"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("longPrimitive"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("shortPrimitive"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("doublePrimitive"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("floatPrimitive"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("byteObject"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("intObject"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("longObject"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("shortObject"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("doubleObject"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("floatObject"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("bigDecimal"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("bigInteger"));
        dummy.intPrimitive = 0;
        dummy.longPrimitive = 0L;
        dummy.bytePrimitive = 0;
        dummy.shortPrimitive = 0;
        dummy.doublePrimitive = 0.0;
        dummy.floatPrimitive = 0.0f;
        dummy.intObject = 0;
        dummy.longObject = 0L;
        dummy.byteObject = 0;
        dummy.shortObject = 0;
        dummy.doubleObject = 0.0;
        dummy.floatObject = Float.valueOf(0.0f);
        dummy.bigDecimal = BigDecimal.valueOf(0L);
        dummy.bigInteger = BigInteger.valueOf(0L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Negative.class).withProperty("bytePrimitive"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("intPrimitive"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("longPrimitive"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("shortPrimitive"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("doublePrimitive"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("floatPrimitive"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("byteObject"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("intObject"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("longObject"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("shortObject"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("doubleObject"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("floatObject"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("bigDecimal"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("bigInteger"));
        dummy.intPrimitive = -101;
        dummy.longPrimitive = -1001L;
        dummy.bytePrimitive = (byte)-111;
        dummy.shortPrimitive = (short)-142;
        dummy.doublePrimitive = -123.34;
        dummy.floatPrimitive = -456.34f;
        dummy.intObject = -100;
        dummy.longObject = -15678L;
        dummy.byteObject = -50;
        dummy.shortObject = -3;
        dummy.doubleObject = -123.34;
        dummy.floatObject = Float.valueOf(-5678.56f);
        dummy.bigDecimal = BigDecimal.valueOf(-100.9);
        dummy.bigInteger = BigInteger.valueOf(-100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-negative", id="a")})
    public void testNegativeConstraintInfinityAndNaN() {
        Validator validator = TestUtil.getValidatorUnderTest();
        NegativeEntity dummy = new NegativeEntity();
        dummy.intPrimitive = -1;
        dummy.longPrimitive = -1L;
        dummy.bytePrimitive = (byte)-1;
        dummy.shortPrimitive = (short)-1;
        dummy.doublePrimitive = -1.0;
        dummy.floatPrimitive = -1.0f;
        dummy.floatObject = Float.valueOf(Float.NEGATIVE_INFINITY);
        dummy.doubleObject = Double.NEGATIVE_INFINITY;
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        dummy.floatObject = Float.valueOf(Float.POSITIVE_INFINITY);
        dummy.doubleObject = Double.POSITIVE_INFINITY;
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Negative.class).withProperty("doubleObject"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("floatObject"));
        dummy.floatObject = Float.valueOf(Float.NaN);
        dummy.doubleObject = Double.NaN;
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Negative.class).withProperty("doubleObject"), ConstraintViolationAssert.violationOf(Negative.class).withProperty("floatObject"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-negativeorzero", id="a")})
    public void testNegativeOrZeroConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        NegativeOrZeroEntity dummy = new NegativeOrZeroEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        dummy.intPrimitive = 101;
        dummy.longPrimitive = 1001L;
        dummy.bytePrimitive = (byte)111;
        dummy.shortPrimitive = (short)142;
        dummy.doublePrimitive = 123.34;
        dummy.floatPrimitive = 456.34f;
        dummy.intObject = 100;
        dummy.longObject = 15678L;
        dummy.byteObject = 50;
        dummy.shortObject = 3;
        dummy.doubleObject = 123.34;
        dummy.floatObject = Float.valueOf(5678.56f);
        dummy.bigDecimal = BigDecimal.valueOf(100.9);
        dummy.bigInteger = BigInteger.valueOf(100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NegativeOrZero.class).withProperty("bytePrimitive"), ConstraintViolationAssert.violationOf(NegativeOrZero.class).withProperty("intPrimitive"), ConstraintViolationAssert.violationOf(NegativeOrZero.class).withProperty("longPrimitive"), ConstraintViolationAssert.violationOf(NegativeOrZero.class).withProperty("shortPrimitive"), ConstraintViolationAssert.violationOf(NegativeOrZero.class).withProperty("doublePrimitive"), ConstraintViolationAssert.violationOf(NegativeOrZero.class).withProperty("floatPrimitive"), ConstraintViolationAssert.violationOf(NegativeOrZero.class).withProperty("byteObject"), ConstraintViolationAssert.violationOf(NegativeOrZero.class).withProperty("intObject"), ConstraintViolationAssert.violationOf(NegativeOrZero.class).withProperty("longObject"), ConstraintViolationAssert.violationOf(NegativeOrZero.class).withProperty("shortObject"), ConstraintViolationAssert.violationOf(NegativeOrZero.class).withProperty("doubleObject"), ConstraintViolationAssert.violationOf(NegativeOrZero.class).withProperty("floatObject"), ConstraintViolationAssert.violationOf(NegativeOrZero.class).withProperty("bigDecimal"), ConstraintViolationAssert.violationOf(NegativeOrZero.class).withProperty("bigInteger"));
        dummy.intPrimitive = 0;
        dummy.longPrimitive = 0L;
        dummy.bytePrimitive = 0;
        dummy.shortPrimitive = 0;
        dummy.doublePrimitive = 0.0;
        dummy.floatPrimitive = 0.0f;
        dummy.intObject = 0;
        dummy.longObject = 0L;
        dummy.byteObject = 0;
        dummy.shortObject = 0;
        dummy.doubleObject = 0.0;
        dummy.floatObject = Float.valueOf(0.0f);
        dummy.bigDecimal = BigDecimal.valueOf(0L);
        dummy.bigInteger = BigInteger.valueOf(0L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        dummy.intPrimitive = -101;
        dummy.longPrimitive = -1001L;
        dummy.bytePrimitive = (byte)-111;
        dummy.shortPrimitive = (short)-142;
        dummy.doublePrimitive = -123.34;
        dummy.floatPrimitive = -456.34f;
        dummy.intObject = -100;
        dummy.longObject = -15678L;
        dummy.byteObject = -50;
        dummy.shortObject = -3;
        dummy.doubleObject = -123.34;
        dummy.floatObject = Float.valueOf(-5678.56f);
        dummy.bigDecimal = BigDecimal.valueOf(-100.9);
        dummy.bigInteger = BigInteger.valueOf(-100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-negativeorzero", id="a")})
    public void testNegativeOrZeroConstraintInfinityAndNaN() {
        Validator validator = TestUtil.getValidatorUnderTest();
        NegativeOrZeroEntity dummy = new NegativeOrZeroEntity();
        dummy.floatObject = Float.valueOf(Float.NEGATIVE_INFINITY);
        dummy.doubleObject = Double.NEGATIVE_INFINITY;
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        dummy.floatObject = Float.valueOf(Float.POSITIVE_INFINITY);
        dummy.doubleObject = Double.POSITIVE_INFINITY;
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NegativeOrZero.class).withProperty("doubleObject"), ConstraintViolationAssert.violationOf(NegativeOrZero.class).withProperty("floatObject"));
        dummy.floatObject = Float.valueOf(Float.NaN);
        dummy.doubleObject = Double.NaN;
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NegativeOrZero.class).withProperty("doubleObject"), ConstraintViolationAssert.violationOf(NegativeOrZero.class).withProperty("floatObject"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-positive", id="a")})
    public void testPositiveConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        PositiveEntity dummy = new PositiveEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Positive.class).withProperty("bytePrimitive"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("intPrimitive"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("longPrimitive"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("shortPrimitive"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("doublePrimitive"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("floatPrimitive"));
        dummy.intPrimitive = 101;
        dummy.longPrimitive = 1001L;
        dummy.bytePrimitive = (byte)111;
        dummy.shortPrimitive = (short)142;
        dummy.doublePrimitive = 123.34;
        dummy.floatPrimitive = 456.34f;
        dummy.intObject = 100;
        dummy.longObject = 15678L;
        dummy.byteObject = 50;
        dummy.shortObject = 3;
        dummy.doubleObject = 123.34;
        dummy.floatObject = Float.valueOf(5678.56f);
        dummy.bigDecimal = BigDecimal.valueOf(100.9);
        dummy.bigInteger = BigInteger.valueOf(100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        dummy.intPrimitive = 0;
        dummy.longPrimitive = 0L;
        dummy.bytePrimitive = 0;
        dummy.shortPrimitive = 0;
        dummy.doublePrimitive = 0.0;
        dummy.floatPrimitive = 0.0f;
        dummy.intObject = 0;
        dummy.longObject = 0L;
        dummy.byteObject = 0;
        dummy.shortObject = 0;
        dummy.doubleObject = 0.0;
        dummy.floatObject = Float.valueOf(0.0f);
        dummy.bigDecimal = BigDecimal.valueOf(0L);
        dummy.bigInteger = BigInteger.valueOf(0L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Positive.class).withProperty("bytePrimitive"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("intPrimitive"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("longPrimitive"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("shortPrimitive"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("doublePrimitive"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("floatPrimitive"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("byteObject"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("intObject"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("longObject"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("shortObject"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("doubleObject"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("floatObject"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("bigDecimal"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("bigInteger"));
        dummy.intPrimitive = -101;
        dummy.longPrimitive = -1001L;
        dummy.bytePrimitive = (byte)-111;
        dummy.shortPrimitive = (short)-142;
        dummy.doublePrimitive = -123.34;
        dummy.floatPrimitive = -456.34f;
        dummy.intObject = -100;
        dummy.longObject = -15678L;
        dummy.byteObject = -50;
        dummy.shortObject = -3;
        dummy.doubleObject = -123.34;
        dummy.floatObject = Float.valueOf(-5678.56f);
        dummy.bigDecimal = BigDecimal.valueOf(-100.9);
        dummy.bigInteger = BigInteger.valueOf(-100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Positive.class).withProperty("bytePrimitive"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("intPrimitive"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("longPrimitive"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("shortPrimitive"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("doublePrimitive"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("floatPrimitive"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("byteObject"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("intObject"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("longObject"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("shortObject"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("doubleObject"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("floatObject"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("bigDecimal"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("bigInteger"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-positiveorzero", id="a")})
    public void testPositiveConstraintInfinityAndNaN() {
        Validator validator = TestUtil.getValidatorUnderTest();
        PositiveEntity dummy = new PositiveEntity();
        dummy.intPrimitive = 1;
        dummy.longPrimitive = 1L;
        dummy.bytePrimitive = 1;
        dummy.shortPrimitive = 1;
        dummy.doublePrimitive = 1.0;
        dummy.floatPrimitive = 1.0f;
        dummy.floatObject = Float.valueOf(Float.POSITIVE_INFINITY);
        dummy.doubleObject = Double.POSITIVE_INFINITY;
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        dummy.floatObject = Float.valueOf(Float.NEGATIVE_INFINITY);
        dummy.doubleObject = Double.NEGATIVE_INFINITY;
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Positive.class).withProperty("doubleObject"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("floatObject"));
        dummy.floatObject = Float.valueOf(Float.NaN);
        dummy.doubleObject = Double.NaN;
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Positive.class).withProperty("doubleObject"), ConstraintViolationAssert.violationOf(Positive.class).withProperty("floatObject"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-positiveorzero", id="a")})
    public void testPositiveOrZeroConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        PositiveOrZeroEntity dummy = new PositiveOrZeroEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        dummy.intPrimitive = 101;
        dummy.longPrimitive = 1001L;
        dummy.bytePrimitive = (byte)111;
        dummy.shortPrimitive = (short)142;
        dummy.doublePrimitive = 123.34;
        dummy.floatPrimitive = 456.34f;
        dummy.intObject = 100;
        dummy.longObject = 15678L;
        dummy.byteObject = 50;
        dummy.shortObject = 3;
        dummy.doubleObject = 123.34;
        dummy.floatObject = Float.valueOf(5678.56f);
        dummy.bigDecimal = BigDecimal.valueOf(100.9);
        dummy.bigInteger = BigInteger.valueOf(100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        dummy.intPrimitive = 0;
        dummy.longPrimitive = 0L;
        dummy.bytePrimitive = 0;
        dummy.shortPrimitive = 0;
        dummy.doublePrimitive = 0.0;
        dummy.floatPrimitive = 0.0f;
        dummy.intObject = 0;
        dummy.longObject = 0L;
        dummy.byteObject = 0;
        dummy.shortObject = 0;
        dummy.doubleObject = 0.0;
        dummy.floatObject = Float.valueOf(0.0f);
        dummy.bigDecimal = BigDecimal.valueOf(0L);
        dummy.bigInteger = BigInteger.valueOf(0L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        dummy.intPrimitive = -101;
        dummy.longPrimitive = -1001L;
        dummy.bytePrimitive = (byte)-111;
        dummy.shortPrimitive = (short)-142;
        dummy.doublePrimitive = -123.34;
        dummy.floatPrimitive = -456.34f;
        dummy.intObject = -100;
        dummy.longObject = -15678L;
        dummy.byteObject = -50;
        dummy.shortObject = -3;
        dummy.doubleObject = -123.34;
        dummy.floatObject = Float.valueOf(-5678.56f);
        dummy.bigDecimal = BigDecimal.valueOf(-100.9);
        dummy.bigInteger = BigInteger.valueOf(-100L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(PositiveOrZero.class).withProperty("bytePrimitive"), ConstraintViolationAssert.violationOf(PositiveOrZero.class).withProperty("intPrimitive"), ConstraintViolationAssert.violationOf(PositiveOrZero.class).withProperty("longPrimitive"), ConstraintViolationAssert.violationOf(PositiveOrZero.class).withProperty("shortPrimitive"), ConstraintViolationAssert.violationOf(PositiveOrZero.class).withProperty("doublePrimitive"), ConstraintViolationAssert.violationOf(PositiveOrZero.class).withProperty("floatPrimitive"), ConstraintViolationAssert.violationOf(PositiveOrZero.class).withProperty("byteObject"), ConstraintViolationAssert.violationOf(PositiveOrZero.class).withProperty("intObject"), ConstraintViolationAssert.violationOf(PositiveOrZero.class).withProperty("longObject"), ConstraintViolationAssert.violationOf(PositiveOrZero.class).withProperty("shortObject"), ConstraintViolationAssert.violationOf(PositiveOrZero.class).withProperty("doubleObject"), ConstraintViolationAssert.violationOf(PositiveOrZero.class).withProperty("floatObject"), ConstraintViolationAssert.violationOf(PositiveOrZero.class).withProperty("bigDecimal"), ConstraintViolationAssert.violationOf(PositiveOrZero.class).withProperty("bigInteger"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-positive", id="a")})
    public void testPositiveOrZeroConstraintInfinityAndNaN() {
        Validator validator = TestUtil.getValidatorUnderTest();
        PositiveOrZeroEntity dummy = new PositiveOrZeroEntity();
        dummy.floatObject = Float.valueOf(Float.POSITIVE_INFINITY);
        dummy.doubleObject = Double.POSITIVE_INFINITY;
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        dummy.floatObject = Float.valueOf(Float.NEGATIVE_INFINITY);
        dummy.doubleObject = Double.NEGATIVE_INFINITY;
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(PositiveOrZero.class).withProperty("doubleObject"), ConstraintViolationAssert.violationOf(PositiveOrZero.class).withProperty("floatObject"));
        dummy.floatObject = Float.valueOf(Float.NaN);
        dummy.doubleObject = Double.NaN;
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(PositiveOrZero.class).withProperty("doubleObject"), ConstraintViolationAssert.violationOf(PositiveOrZero.class).withProperty("floatObject"));
    }

    private static class NegativeEntity {
        @Negative
        private BigDecimal bigDecimal;
        @Negative
        private BigInteger bigInteger;
        @Negative
        private byte bytePrimitive;
        @Negative
        private short shortPrimitive;
        @Negative
        private int intPrimitive;
        @Negative
        private long longPrimitive;
        @Negative
        private double doublePrimitive;
        @Negative
        private float floatPrimitive;
        @Negative
        private Byte byteObject;
        @Negative
        private Short shortObject;
        @Negative
        private Integer intObject;
        @Negative
        private Long longObject;
        @Negative
        private Double doubleObject;
        @Negative
        private Float floatObject;

        private NegativeEntity() {
        }
    }

    private static class NegativeOrZeroEntity {
        @NegativeOrZero
        private BigDecimal bigDecimal;
        @NegativeOrZero
        private BigInteger bigInteger;
        @NegativeOrZero
        private byte bytePrimitive;
        @NegativeOrZero
        private short shortPrimitive;
        @NegativeOrZero
        private int intPrimitive;
        @NegativeOrZero
        private long longPrimitive;
        @NegativeOrZero
        private double doublePrimitive;
        @NegativeOrZero
        private float floatPrimitive;
        @NegativeOrZero
        private Byte byteObject;
        @NegativeOrZero
        private Short shortObject;
        @NegativeOrZero
        private Integer intObject;
        @NegativeOrZero
        private Long longObject;
        @NegativeOrZero
        private Double doubleObject;
        @NegativeOrZero
        private Float floatObject;

        private NegativeOrZeroEntity() {
        }
    }

    private static class PositiveEntity {
        @Positive
        private BigDecimal bigDecimal;
        @Positive
        private BigInteger bigInteger;
        @Positive
        private byte bytePrimitive;
        @Positive
        private short shortPrimitive;
        @Positive
        private int intPrimitive;
        @Positive
        private long longPrimitive;
        @Positive
        private double doublePrimitive;
        @Positive
        private float floatPrimitive;
        @Positive
        private Byte byteObject;
        @Positive
        private Short shortObject;
        @Positive
        private Integer intObject;
        @Positive
        private Long longObject;
        @Positive
        private Double doubleObject;
        @Positive
        private Float floatObject;

        private PositiveEntity() {
        }
    }

    private static class PositiveOrZeroEntity {
        @PositiveOrZero
        private BigDecimal bigDecimal;
        @PositiveOrZero
        private BigInteger bigInteger;
        @PositiveOrZero
        private byte bytePrimitive;
        @PositiveOrZero
        private short shortPrimitive;
        @PositiveOrZero
        private int intPrimitive;
        @PositiveOrZero
        private long longPrimitive;
        @PositiveOrZero
        private double doublePrimitive;
        @PositiveOrZero
        private float floatPrimitive;
        @PositiveOrZero
        private Byte byteObject;
        @PositiveOrZero
        private Short shortObject;
        @PositiveOrZero
        private Integer intObject;
        @PositiveOrZero
        private Long longObject;
        @PositiveOrZero
        private Double doubleObject;
        @PositiveOrZero
        private Float floatObject;

        private PositiveOrZeroEntity() {
        }
    }
}

