/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.navigation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class NavigationTarget {
    public static final String ELEMENT_IDS = "elementIds";
    public static final String ELEMENT_IDS_SEPARATOR = "&";
    public static final String TEXT_LINE = "line";
    public static final String TEXT_COLUMN = "column";
    private final String uri;
    private final String label;
    private Map<String, String> args;

    public NavigationTarget(String uri) {
        this(uri, new HashMap<String, String>());
    }

    public NavigationTarget(String uri, String label) {
        this(uri, label, new HashMap<String, String>());
    }

    public NavigationTarget(String uri, Map<String, String> args) {
        this(uri, null, args);
    }

    public NavigationTarget(String uri, String label, Map<String, String> args) {
        this.uri = uri;
        this.label = label;
        this.args = args;
    }

    public String getUri() {
        return this.uri;
    }

    public String getLabel() {
        return this.label;
    }

    public Map<String, String> getArgs() {
        return this.args;
    }

    public List<String> getElementIds() {
        if (this.args == null || this.args.get(ELEMENT_IDS) == null || this.args.get(ELEMENT_IDS).isEmpty()) {
            return Arrays.asList(new String[0]);
        }
        return Arrays.asList(this.args.get(ELEMENT_IDS).split(ELEMENT_IDS_SEPARATOR));
    }

    public void setElementIds(List<String> elementIds) {
        if (this.args == null) {
            this.args = new HashMap<String, String>();
        }
        this.args.put(ELEMENT_IDS, elementIds.stream().collect(Collectors.joining(ELEMENT_IDS_SEPARATOR)));
    }

    public boolean hasTextPosition() {
        boolean hasValues;
        boolean bl = hasValues = this.args != null && this.args.containsKey(TEXT_LINE) && this.args.containsKey(TEXT_COLUMN);
        if (!hasValues) {
            return false;
        }
        try {
            Double.valueOf(this.args.get(TEXT_LINE));
            Double.valueOf(this.args.get(TEXT_COLUMN));
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public void setTextPosition(int line, int column) {
        this.args.put(TEXT_LINE, String.valueOf(line));
        this.args.put(TEXT_COLUMN, String.valueOf(column));
    }

    public int getTextPositionLine() {
        return Double.valueOf(this.args.get(TEXT_LINE)).intValue();
    }

    public int getTextPositionColumn() {
        return Double.valueOf(this.args.get(TEXT_COLUMN)).intValue();
    }
}

