/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.directediting;

import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.glsp.server.actions.AbstractActionHandler;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.features.directediting.ContextEditValidatorRegistry;
import org.eclipse.glsp.server.features.directediting.RequestEditValidationAction;
import org.eclipse.glsp.server.features.directediting.SetEditValidationResultAction;
import org.eclipse.glsp.server.features.directediting.ValidationStatus;

public class RequestEditValidationHandler
extends AbstractActionHandler<RequestEditValidationAction> {
    private static Logger LOGGER = LogManager.getLogger(RequestEditValidationHandler.class);
    @Inject
    protected ContextEditValidatorRegistry contextEditValidatorRegistry;

    @Override
    public List<Action> executeAction(RequestEditValidationAction action) {
        Optional<ValidationStatus> validationResult = this.contextEditValidatorRegistry.get(action.getContextId()).map(provider -> provider.validate(action));
        if (!validationResult.isPresent()) {
            String message = "No validator registered for the context '" + action.getContextId() + "'";
            LOGGER.warn(message);
            return this.listOf(new SetEditValidationResultAction(ValidationStatus.warning(message)));
        }
        return this.listOf(new SetEditValidationResultAction(validationResult.get()));
    }
}

