/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.model;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.server.di.ClientId;
import org.eclipse.glsp.server.internal.gmodel.commandstack.GModelCommandStack;
import org.eclipse.glsp.server.model.GModelState;

public class DefaultGModelState
implements GModelState {
    @Inject
    @ClientId
    protected String clientId;
    protected Map<String, String> options;
    protected final Map<String, Object> properties = new HashMap<String, Object>();
    protected GModelRoot currentModel;
    protected CommandStack commandStack;
    protected String editMode;
    protected GModelIndex index = GModelIndex.empty();

    @Inject
    public void init() {
        this.setCommandStack((CommandStack)new GModelCommandStack());
    }

    @Override
    public Map<String, String> getClientOptions() {
        return this.options;
    }

    @Override
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public GModelRoot getRoot() {
        return this.currentModel;
    }

    @Override
    public void updateRoot(GModelRoot newRoot) {
        this.setRoot(newRoot);
        this.index = this.getOrUpdateIndex(newRoot);
    }

    protected GModelIndex getOrUpdateIndex(GModelRoot newRoot) {
        return GModelIndex.get((GModelElement)newRoot);
    }

    protected void setRoot(GModelRoot newRoot) {
        this.currentModel = newRoot;
    }

    protected void setCommandStack(CommandStack commandStack) {
        if (this.commandStack != null) {
            this.commandStack.flush();
        }
        this.commandStack = commandStack;
    }

    @Override
    public void setClientOptions(Map<String, String> options) {
        this.options = options;
    }

    @Override
    public GModelIndex getIndex() {
        return this.index;
    }

    @Override
    public void execute(Command command) {
        if (this.commandStack != null) {
            this.commandStack.execute(command);
        }
    }

    @Override
    public boolean canUndo() {
        return this.commandStack != null && this.commandStack.canUndo();
    }

    @Override
    public boolean canRedo() {
        return this.commandStack != null && this.commandStack.canRedo();
    }

    @Override
    public void undo() {
        if (this.commandStack != null) {
            this.commandStack.undo();
        }
    }

    @Override
    public void redo() {
        if (this.commandStack != null) {
            this.commandStack.redo();
        }
    }

    @Override
    public boolean isDirty() {
        return this.commandStack instanceof BasicCommandStack && ((BasicCommandStack)this.commandStack).isSaveNeeded();
    }

    @Override
    public void saveIsDone() {
        if (this.commandStack instanceof BasicCommandStack) {
            ((BasicCommandStack)this.commandStack).saveIsDone();
        }
    }

    @Override
    public String getEditMode() {
        return this.editMode;
    }

    @Override
    public void setEditMode(String editMode) {
        this.editMode = editMode;
    }

    @Override
    public <P> P setProperty(String key, P property) {
        return (P)this.properties.put(key, property);
    }

    @Override
    public <P> Optional<P> getProperty(String key, Class<P> type) {
        return Optional.ofNullable(type.cast(this.properties.get(key)));
    }

    @Override
    public void clearProperty(String key) {
        this.properties.remove(key);
    }
}

