/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.operations;

import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.command.Command;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.server.actions.AbstractActionHandler;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.features.core.model.ModelSubmissionHandler;
import org.eclipse.glsp.server.internal.gmodel.commandstack.GModelRecordingCommand;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.operations.CreateOperation;
import org.eclipse.glsp.server.operations.CreateOperationHandler;
import org.eclipse.glsp.server.operations.Operation;
import org.eclipse.glsp.server.operations.OperationHandler;
import org.eclipse.glsp.server.operations.OperationHandlerRegistry;
import org.eclipse.glsp.server.utils.ServerMessageUtil;

public class OperationActionHandler
extends AbstractActionHandler<Operation> {
    @Inject
    protected OperationHandlerRegistry operationHandlerRegistry;
    @Inject
    protected ModelSubmissionHandler modelSubmissionHandler;
    @Inject
    protected GModelState modelState;

    @Override
    public boolean handles(Action action) {
        return action instanceof Operation;
    }

    @Override
    public List<Action> executeAction(Operation operation) {
        if (this.modelState.isReadonly()) {
            return this.listOf(ServerMessageUtil.warn("Server is in readonly-mode! Could not execute operation: " + operation.getKind()));
        }
        Optional<? extends OperationHandler> operationHandler = OperationActionHandler.getOperationHandler(operation, this.operationHandlerRegistry);
        if (operationHandler.isPresent()) {
            return this.executeHandler(operation, operationHandler.get());
        }
        return this.none();
    }

    protected List<Action> executeHandler(Operation operation, OperationHandler handler) {
        GModelRecordingCommand command = new GModelRecordingCommand((GModelRoot)this.modelState.getRoot(), handler.getLabel(), () -> handler.execute(operation));
        this.modelState.execute((Command)command);
        return this.modelSubmissionHandler.submitModel("operation");
    }

    public static Optional<? extends OperationHandler> getOperationHandler(Operation operation, OperationHandlerRegistry registry) {
        Optional<Object> operationHandler = operation instanceof CreateOperation ? registry.get(operation).filter(CreateOperationHandler.class::isInstance).map(CreateOperationHandler.class::cast).filter(handler -> handler.getHandledElementTypeIds().contains(((CreateOperation)operation).getElementTypeId())) : registry.get(operation);
        return operationHandler;
    }
}

