/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.testing.extensions;

import com.google.common.annotations.Beta;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import com.google.inject.Injector;
import org.eclipse.xtext.testing.IInjectorProvider;
import org.eclipse.xtext.testing.IRegistryConfigurator;
import org.eclipse.xtext.testing.InjectWith;
import org.eclipse.xtext.util.Exceptions;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

@Beta
public class InjectionExtension
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private static ClassToInstanceMap<IInjectorProvider> injectorProviderClassCache = MutableClassToInstanceMap.create();

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        Injector injector;
        IInjectorProvider injectorProvider = InjectionExtension.getOrCreateInjectorProvider(context);
        if (injectorProvider instanceof IRegistryConfigurator) {
            IRegistryConfigurator registryConfigurator = (IRegistryConfigurator)((Object)injectorProvider);
            registryConfigurator.setupRegistry();
        }
        if (injectorProvider != null && (injector = injectorProvider.getInjector()) != null) {
            injector.injectMembers(context.getRequiredTestInstance());
        }
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        IInjectorProvider injectorProvider = InjectionExtension.getOrCreateInjectorProvider(context);
        if (injectorProvider instanceof IRegistryConfigurator) {
            IRegistryConfigurator registryConfigurator = (IRegistryConfigurator)((Object)injectorProvider);
            registryConfigurator.restoreRegistry();
        }
    }

    private static IInjectorProvider getOrCreateInjectorProvider(ExtensionContext context) {
        InjectWith injectWith = context.getRequiredTestClass().getAnnotation(InjectWith.class);
        if (injectWith != null) {
            Class<? extends IInjectorProvider> klass = injectWith.value();
            IInjectorProvider injectorProvider = (IInjectorProvider)injectorProviderClassCache.get(klass);
            if (injectorProvider == null) {
                try {
                    injectorProvider = klass.newInstance();
                    injectorProviderClassCache.put(klass, (Object)injectorProvider);
                }
                catch (Exception e) {
                    Exceptions.throwUncheckedException((Throwable)e);
                }
            }
            return injectorProvider;
        }
        return null;
    }
}

