/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.gemoc.traceaddon;

import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gemoc.commons.eclipse.emf.EMFResource;
import org.eclipse.gemoc.executionframework.engine.core.CommandExecution;
import org.eclipse.gemoc.trace.commons.model.launchconfiguration.LaunchConfiguration;
import org.eclipse.gemoc.trace.commons.model.trace.Dimension;
import org.eclipse.gemoc.trace.commons.model.trace.State;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.commons.model.trace.Trace;
import org.eclipse.gemoc.trace.commons.model.trace.TracedObject;
import org.eclipse.gemoc.trace.commons.model.trace.Value;
import org.eclipse.gemoc.trace.gemoc.api.IMultiDimensionalTraceAddon;
import org.eclipse.gemoc.trace.gemoc.api.IStateManager;
import org.eclipse.gemoc.trace.gemoc.api.ITraceConstructor;
import org.eclipse.gemoc.trace.gemoc.api.ITraceExplorer;
import org.eclipse.gemoc.trace.gemoc.api.ITraceExtractor;
import org.eclipse.gemoc.trace.gemoc.api.ITraceListener;
import org.eclipse.gemoc.trace.gemoc.api.ITraceNotifier;
import org.eclipse.gemoc.trace.gemoc.traceaddon.GenericTraceExplorer;
import org.eclipse.gemoc.trace.gemoc.traceaddon.GenericTraceExtractor;
import org.eclipse.gemoc.trace.gemoc.traceaddon.GenericTraceNotifier;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionContext;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.BatchModelChangeListener;
import org.eclipse.gemoc.xdsmlframework.api.extensions.engine_addon.EngineAddonSpecificationExtensionPoint;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public abstract class AbstractTraceAddon
implements IEngineAddon,
IMultiDimensionalTraceAddon<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> {
    private IExecutionContext<?, ?, ?> _executionContext;
    private ITraceExplorer<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> traceExplorer;
    private ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> traceExtractor;
    private ITraceConstructor traceConstructor;
    private ITraceNotifier traceNotifier;
    private BatchModelChangeListener traceListener;
    private boolean needTransaction = true;
    private BatchModelChangeListener listenerAddon;
    private Trace<Step<?>, TracedObject<?>, State<?, ?>> trace;

    protected abstract ITraceConstructor constructTraceConstructor(Resource var1, Resource var2, Map<EObject, TracedObject<?>> var3);

    protected abstract IStateManager<State<?, ?>> constructStateManager(Resource var1, Map<TracedObject<?>, EObject> var2);

    public ITraceExplorer<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> getTraceExplorer() {
        return this.traceExplorer;
    }

    public ITraceConstructor getTraceConstructor() {
        return this.traceConstructor;
    }

    public ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> getTraceExtractor() {
        return this.traceExtractor;
    }

    public ITraceNotifier getTraceNotifier() {
        return this.traceNotifier;
    }

    public void load(Resource traceResource) {
        EObject root = (EObject)IterableExtensions.head((Iterable)traceResource.getContents());
        if (root instanceof Trace) {
            GenericTraceExtractor _genericTraceExtractor;
            GenericTraceExplorer _genericTraceExplorer;
            this.trace = (Trace)root;
            this.traceExplorer = _genericTraceExplorer = new GenericTraceExplorer(this.trace);
            this.traceExtractor = _genericTraceExtractor = new GenericTraceExtractor(this.trace);
        } else {
            this.traceExplorer = null;
            this.traceExtractor = null;
        }
    }

    private static String getEPackageFQN(EPackage p, String separator) {
        EPackage superP = p.getESuperPackage();
        if (superP != null) {
            String _ePackageFQN = AbstractTraceAddon.getEPackageFQN(superP, separator);
            String _plus = String.valueOf(_ePackageFQN) + separator;
            String _name = p.getName();
            return String.valueOf(_plus) + _name;
        }
        return StringExtensions.toFirstUpper((String)p.getName());
    }

    public void aboutToExecuteStep(IExecutionEngine<?> executionEngine, Step<?> step) {
        this.manageStep(step, true);
    }

    public void stepExecuted(IExecutionEngine<?> engine, Step<?> step) {
        this.manageStep(step, false);
    }

    private void manageStep(final Step<?> step, final boolean add) {
        if (step != null) {
            Runnable _function = new Runnable(){

                @Override
                public void run() {
                    AbstractTraceAddon.this.traceConstructor.addState(AbstractTraceAddon.this.listenerAddon.getChanges((Object)AbstractTraceAddon.this));
                    if (add) {
                        AbstractTraceAddon.this.traceConstructor.addStep(step);
                    } else {
                        AbstractTraceAddon.this.traceConstructor.endStep(step);
                    }
                    AbstractTraceAddon.this.traceNotifier.notifyListener((ITraceListener)AbstractTraceAddon.this.traceExtractor);
                    AbstractTraceAddon.this.traceNotifier.notifyListener((ITraceListener)AbstractTraceAddon.this.traceExplorer);
                    AbstractTraceAddon.this.traceNotifier.notifyListeners();
                    AbstractTraceAddon.this.traceExplorer.updateCallStack(step);
                }
            };
            this.modifyTrace(_function);
        }
    }

    public void engineAboutToStart(IExecutionEngine<?> engine) {
        if (this._executionContext == null) {
            BatchModelChangeListener _batchModelChangeListener;
            this._executionContext = engine.getExecutionContext();
            Resource modelResource = this._executionContext.getResourceModel();
            ResourceSetImpl rs = new ResourceSetImpl();
            TransactionalEditingDomain ed = TransactionUtil.getEditingDomain((ResourceSet)rs);
            this.needTransaction = ed != null;
            String _string = this._executionContext.getWorkspace().getExecutionPath().toString();
            String _plus = String.valueOf(_string) + "/execution.trace";
            URI traceModelURI = URI.createPlatformResourceURI((String)_plus, (boolean)false);
            Resource traceResource = rs.createResource(traceModelURI);
            Set _relatedResources = EMFResource.getRelatedResources((Resource)engine.getExecutionContext().getResourceModel());
            this.listenerAddon = _batchModelChangeListener = new BatchModelChangeListener(_relatedResources);
            this.listenerAddon.registerObserver((Object)this);
            final LaunchConfiguration launchConfiguration = engine.extractLaunchConfiguration();
            HashBiMap exeToTraced = HashBiMap.create();
            this.traceConstructor = this.constructTraceConstructor(modelResource, traceResource, (Map<EObject, TracedObject<?>>)exeToTraced);
            Runnable _function = new Runnable(){

                @Override
                public void run() {
                    AbstractTraceAddon.this.traceConstructor.initTrace(launchConfiguration);
                }
            };
            this.modifyTrace(_function);
            EObject root = (EObject)IterableExtensions.head((Iterable)traceResource.getContents());
            if (root instanceof Trace) {
                BatchModelChangeListener _batchModelChangeListener_1;
                GenericTraceExtractor _genericTraceExtractor;
                GenericTraceExplorer _genericTraceExplorer;
                this.trace = (Trace)root;
                IStateManager<State<?, ?>> stateManager = this.constructStateManager(modelResource, (Map<TracedObject<?>, EObject>)exeToTraced.inverse());
                this.traceExplorer = _genericTraceExplorer = new GenericTraceExplorer(this.trace, stateManager);
                this.traceExtractor = _genericTraceExtractor = new GenericTraceExtractor(this.trace);
                Set _relatedResources_1 = EMFResource.getRelatedResources((Resource)traceResource);
                this.traceListener = _batchModelChangeListener_1 = new BatchModelChangeListener(_relatedResources_1);
                GenericTraceNotifier _genericTraceNotifier = new GenericTraceNotifier(this.traceListener);
                this.traceNotifier = _genericTraceNotifier;
                this.traceNotifier.addListener(this.traceExtractor);
                this.traceNotifier.addListener(this.traceExplorer);
            }
        }
    }

    private void modifyTrace(final Runnable r, String message) {
        try {
            if (this.needTransaction) {
                boolean _not;
                TransactionalEditingDomain ed = TransactionUtil.getEditingDomain((Resource)this._executionContext.getResourceModel());
                final HashSet catchedException = new HashSet();
                RecordingCommand command = new RecordingCommand(ed, message){

                    protected void doExecute() {
                        try {
                            r.run();
                        }
                        catch (Throwable _t) {
                            if (_t instanceof Throwable) {
                                Throwable t = _t;
                                catchedException.add(t);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                };
                CommandExecution.execute((TransactionalEditingDomain)ed, (RecordingCommand)command);
                boolean _isEmpty = catchedException.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    throw (Throwable)IterableExtensions.head(catchedException);
                }
            } else {
                r.run();
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void modifyTrace(Runnable r) {
        this.modifyTrace(r, "");
    }

    public List<String> validate(List<IEngineAddon> otherAddons) {
        ArrayList<String> errors = new ArrayList<String>();
        boolean found = false;
        String addonName = "";
        for (IEngineAddon iEngineAddon : otherAddons) {
            if (!(iEngineAddon instanceof AbstractTraceAddon) || iEngineAddon == this) continue;
            found = true;
            addonName = EngineAddonSpecificationExtensionPoint.getName((IEngineAddon)iEngineAddon);
        }
        if (found) {
            String thisName = EngineAddonSpecificationExtensionPoint.getName((IEngineAddon)this);
            errors.add(String.valueOf(thisName) + " can't run with " + addonName);
        }
        return errors;
    }

    public Trace<?, ?, ?> getTrace() {
        return this.trace;
    }
}

