/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.moccml.mapping.feedback.feedback;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ComparisonOperator implements Enumerator
{
    EQUALS(0, "equals", "="),
    INF(1, "inf", "<"),
    SUP(2, "sup", ">"),
    DIFFERENT(3, "different", "<>"),
    INF_EQUALS(4, "infEquals", "<="),
    SUP_EQUALS(5, "supEquals", ">=");

    public static final int EQUALS_VALUE = 0;
    public static final int INF_VALUE = 1;
    public static final int SUP_VALUE = 2;
    public static final int DIFFERENT_VALUE = 3;
    public static final int INF_EQUALS_VALUE = 4;
    public static final int SUP_EQUALS_VALUE = 5;
    private static final ComparisonOperator[] VALUES_ARRAY;
    public static final List<ComparisonOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ComparisonOperator[]{EQUALS, INF, SUP, DIFFERENT, INF_EQUALS, SUP_EQUALS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ComparisonOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComparisonOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComparisonOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComparisonOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComparisonOperator get(int value) {
        switch (value) {
            case 0: {
                return EQUALS;
            }
            case 1: {
                return INF;
            }
            case 2: {
                return SUP;
            }
            case 3: {
                return DIFFERENT;
            }
            case 4: {
                return INF_EQUALS;
            }
            case 5: {
                return SUP_EQUALS;
            }
        }
        return null;
    }

    private ComparisonOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

