/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.engine.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.gemoc.executionframework.engine.core.IEngineRegistrationListener;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;

public class GemocRunningEnginesRegistry {
    protected HashMap<String, IExecutionEngine<?>> runningEngines = new HashMap();
    private List<IEngineRegistrationListener> _engineRegistrationListeners = new ArrayList<IEngineRegistrationListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String registerEngine(String baseName, IExecutionEngine<?> engine) {
        int uniqueInstance = 0;
        String engineName = String.valueOf(Thread.currentThread().getName()) + " (" + uniqueInstance + ")";
        HashMap<String, IExecutionEngine<?>> hashMap = this.runningEngines;
        synchronized (hashMap) {
            while (this.runningEngines.containsKey(engineName)) {
                engineName = String.valueOf(Thread.currentThread().getName()) + " (" + ++uniqueInstance + ")";
            }
            this.runningEngines.put(engineName, engine);
        }
        this.notifyEngineRegistered(engine);
        return engineName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEngine(String engineName) {
        HashMap<String, IExecutionEngine<?>> hashMap = this.runningEngines;
        synchronized (hashMap) {
            IExecutionEngine<?> engine = this.runningEngines.get(engineName);
            if (engine != null) {
                this.runningEngines.remove(engineName);
                this.notifyEngineUnregistered(engine);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, IExecutionEngine<?>> getRunningEngines() {
        HashMap<String, IExecutionEngine<?>> hashMap = this.runningEngines;
        synchronized (hashMap) {
            return new HashMap(this.runningEngines);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEngineRegistered(IExecutionEngine<?> engine) {
        List<IEngineRegistrationListener> list = this._engineRegistrationListeners;
        synchronized (list) {
            for (IEngineRegistrationListener l : this._engineRegistrationListeners) {
                l.engineRegistered(engine);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEngineUnregistered(IExecutionEngine<?> engine) {
        List<IEngineRegistrationListener> list = this._engineRegistrationListeners;
        synchronized (list) {
            for (IEngineRegistrationListener l : this._engineRegistrationListeners) {
                l.engineUnregistered(engine);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEngineRegistrationListener(IEngineRegistrationListener listener) {
        List<IEngineRegistrationListener> list = this._engineRegistrationListeners;
        synchronized (list) {
            this._engineRegistrationListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEngineRegistrationListener(IEngineRegistrationListener listener) {
        List<IEngineRegistrationListener> list = this._engineRegistrationListeners;
        synchronized (list) {
            this._engineRegistrationListeners.remove(listener);
        }
    }
}

