/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.step;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gemoc.commons.eclipse.ui.TreeViewerHelper;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.Activator;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.SharedIcons;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.deciders.actions.PauseResumeEngineDeciderAction;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.deciders.actions.SwitchDeciderAction;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.step.LogicalStepsViewContentProvider;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentExecutionContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentExecutionEngine;
import org.eclipse.gemoc.executionframework.engine.core.GemocRunningEnginesRegistry;
import org.eclipse.gemoc.executionframework.ui.IMSEPresenter;
import org.eclipse.gemoc.executionframework.ui.utils.ViewUtils;
import org.eclipse.gemoc.executionframework.ui.views.engine.EngineSelectionDependentViewPart;
import org.eclipse.gemoc.executionframework.ui.views.engine.actions.StopEngineAction;
import org.eclipse.gemoc.trace.commons.model.helper.StepHelper;
import org.eclipse.gemoc.trace.commons.model.trace.MSE;
import org.eclipse.gemoc.trace.commons.model.trace.MSEOccurrence;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.xdsmlframework.api.core.EngineStatus;
import org.eclipse.gemoc.xdsmlframework.api.core.ExecutionMode;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;

public class LogicalStepsView
extends EngineSelectionDependentViewPart
implements IMSEPresenter {
    public static final String ID = "org.eclipse.gemoc.executionframework.engine.io.views.steps.LogicalStepsView";
    private Color _representedEventColor;
    private TreeViewer _viewer;
    private ColumnLabelProvider _column1LabelProvider;
    private ColumnLabelProvider _column2LabelProvider;
    private List<URI> _eventsToPresent = new ArrayList<URI>();
    private LogicalStepsViewContentProvider _contentProvider;
    private MenuManager _menuManager;
    private IConcurrentExecutionEngine _currentEngine;
    private Step<?> _lastSelectedLogicalStep;

    public void createPartControl(Composite parent) {
        this._representedEventColor = new Color((Device)parent.getDisplay(), 255, 235, 174);
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createTreeViewer(parent);
        this.createMenuManager();
        this.buildActionToolbar();
        org.eclipse.gemoc.executionframework.ui.Activator.getDefault().getEventPresenters().add(this);
    }

    public void refresh() {
        this.runInDisplayThread(() -> {
            this._viewer.refresh();
            TreeViewerHelper.resizeColumns((TreeViewer)this._viewer);
            this._viewer.expandAll();
        });
    }

    private void createTreeViewer(Composite parent) {
        this._viewer = new TreeViewer(parent, 65540);
        this._viewer.setUseHashlookup(true);
        this._contentProvider = new LogicalStepsViewContentProvider();
        this._viewer.setContentProvider((IContentProvider)this._contentProvider);
        Font mono = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
        this._viewer.getTree().setFont(mono);
        this.createColumns();
        GridData grid = new GridData(4, 4, true, true);
        this._viewer.getControl().setLayoutData((Object)grid);
        this._viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        Tree tree = (Tree)this._viewer.getControl();
        tree.setHeaderVisible(true);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TreeViewerHelper.resizeColumns((TreeViewer)LogicalStepsView.this._viewer);
                    }
                });
            }
        };
        tree.addListener(17, listener);
    }

    private void createColumns() {
        TreeColumn column1 = new TreeColumn(this._viewer.getTree(), 16384);
        column1.setText("Logical Steps/MSEs");
        TreeViewerColumn viewerColumn1 = new TreeViewerColumn(this._viewer, column1);
        this._column1LabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Step) {
                    Step ls = (Step)element;
                    return StepHelper.getStepName((Step)ls);
                }
                if (element instanceof MSEOccurrence) {
                    MSEOccurrence event = (MSEOccurrence)element;
                    if (event.getMse() != null) {
                        return event.getMse().getName();
                    }
                    return "No EOperation";
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof Step) {
                    Step ls = (Step)element;
                    if (LogicalStepsView.this._currentEngine != null && ls == LogicalStepsView.this._currentEngine.getSelectedLogicalStep()) {
                        return SharedIcons.getSharedImage(SharedIcons.LOGICALSTEP_RUNNING_ICON);
                    }
                    return SharedIcons.getSharedImage(SharedIcons.LOGICALSTEP_ICON);
                }
                if (element instanceof MSEOccurrence) {
                    return SharedIcons.getSharedImage(SharedIcons.VISIBLE_EVENT_ICON);
                }
                return null;
            }

            public Color getBackground(Object element) {
                MSE mse;
                Color res = element instanceof MSEOccurrence ? ((mse = ((MSEOccurrence)element).getMse()) != null && LogicalStepsView.this._eventsToPresent.contains(EcoreUtil.getURI((EObject)mse)) ? LogicalStepsView.this._representedEventColor : super.getBackground(element)) : super.getBackground(element);
                return res;
            }
        };
        viewerColumn1.setLabelProvider((CellLabelProvider)this._column1LabelProvider);
        TreeColumn column2 = new TreeColumn(this._viewer.getTree(), 16384);
        column2.setText("DSA");
        TreeViewerColumn viewerColumn2 = new TreeViewerColumn(this._viewer, column2);
        this._column2LabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MSEOccurrence) {
                    MSE mse = ((MSEOccurrence)element).getMse();
                    if (mse != null) {
                        return "   " + ViewUtils.eventToString((MSE)mse);
                    }
                    return "    (no MSE)";
                }
                return "";
            }

            public Color getBackground(Object element) {
                MSE mse;
                Color res = element instanceof MSEOccurrence ? ((mse = ((MSEOccurrence)element).getMse()) != null && LogicalStepsView.this._eventsToPresent.contains(EcoreUtil.getURI((EObject)mse)) ? LogicalStepsView.this._representedEventColor : super.getBackground(element)) : super.getBackground(element);
                return res;
            }
        };
        viewerColumn2.setLabelProvider((CellLabelProvider)this._column2LabelProvider);
    }

    private void createMenuManager() {
        MenuManager menuManager;
        this._menuManager = menuManager = new MenuManager();
        this._menuManager.setRemoveAllWhenShown(true);
        this._menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                LogicalStepsView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = this._menuManager.createContextMenu(this._viewer.getControl());
        this._viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(this._menuManager, (ISelectionProvider)this._viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this._viewer);
    }

    private void fillContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    private void buildActionToolbar() {
        this.addActionToToolbar((Action)new PauseResumeEngineDeciderAction());
        this.addActionToToolbar((Action)new StopEngineAction());
        this.addSeparatorToToolbar();
        this.addActionToToolbar((Action)new SwitchDeciderAction());
    }

    private void addSeparatorToToolbar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IContributionItem)new Separator());
    }

    private void addActionToToolbar(Action action) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)action);
    }

    public void setFocus() {
        this._viewer.getControl().setFocus();
    }

    public void engineSelectionChanged(IExecutionEngine<?> engine) {
        if (engine != null && engine instanceof IConcurrentExecutionEngine && engine.getExecutionContext().getExecutionMode().equals((Object)ExecutionMode.Animation)) {
            this._currentEngine = (IConcurrentExecutionEngine)engine;
            this._viewer.setInput((Object)this._currentEngine);
            if (this._currentEngine != null && !this._currentEngine.getRunningStatus().equals((Object)EngineStatus.RunStatus.Stopped)) {
                TreeViewerHelper.resizeColumns((TreeViewer)this._viewer);
                this._viewer.expandAll();
            } else {
                this._viewer.setInput(null);
            }
            GemocRunningEnginesRegistry registry = org.eclipse.gemoc.executionframework.engine.Activator.getDefault().gemocRunningEngineRegistry;
            for (Map.Entry e : registry.getRunningEngines().entrySet()) {
                if (e.getValue() != engine) continue;
                this.setTitleToolTip((String)e.getKey());
                break;
            }
        }
    }

    public void dispose() {
        org.eclipse.gemoc.executionframework.ui.Activator.getDefault().getEventPresenters().remove((Object)this);
        super.dispose();
        this._column1LabelProvider.dispose();
        this._column2LabelProvider.dispose();
        this._menuManager.dispose();
        this._contentProvider.dispose();
        this._representedEventColor.dispose();
        this._eventsToPresent.clear();
    }

    private void runInDisplayThread(Runnable r) {
        try {
            Display.getDefault().syncExec(r);
        }
        catch (Exception e) {
            Activator.error(e.getMessage(), e);
        }
    }

    public Step<?> getSelectedLogicalStep() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                TreeSelection selection = (TreeSelection)LogicalStepsView.this._viewer.getSelection();
                if (selection.getPaths().length > 0) {
                    TreePath path = selection.getPaths()[0];
                    LogicalStepsView.this._lastSelectedLogicalStep = null;
                    if (path.getLastSegment() instanceof Step) {
                        LogicalStepsView.this._lastSelectedLogicalStep = (Step)path.getLastSegment();
                    } else if (path.getLastSegment() instanceof MSEOccurrence) {
                        LogicalStepsView.this._lastSelectedLogicalStep = (Step)path.getFirstSegment();
                    }
                }
            }
        };
        this.runInDisplayThread(r);
        return this._lastSelectedLogicalStep;
    }

    public void addMenuListener(IMenuListener2 menuListener) {
        this._menuManager.addMenuListener((IMenuListener)menuListener);
    }

    public void addDoubleClickListener(IDoubleClickListener doubleClickListener) {
        this._viewer.addDoubleClickListener(doubleClickListener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this._viewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this._viewer.removeSelectionChangedListener(listener);
    }

    public void removeMenuListener(IMenuListener2 menuListener) {
        this._menuManager.removeMenuListener((IMenuListener)menuListener);
    }

    public void removeDoubleClickListener(IDoubleClickListener doubleClickListener) {
        this._viewer.removeDoubleClickListener(doubleClickListener);
    }

    public TreeViewer getTreeViewer() {
        return this._viewer;
    }

    public void present(List<URI> events) {
        this._eventsToPresent = events;
        if (this._currentEngine != null) {
            ResourceSet rs = ((IConcurrentExecutionContext)this._currentEngine.getExecutionContext()).getResourceModel().getResourceSet();
            for (URI uri : this._eventsToPresent) {
                EObject event = rs.getEObject(uri, false);
                if (event == null) continue;
                this._viewer.refresh((Object)event);
            }
        }
    }
}

