/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.ale.interpreted.engine.ui.launcher;

import java.util.Arrays;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.ale.interpreted.engine.AleEngine;
import org.eclipse.gemoc.ale.interpreted.engine.debug.AleDynamicAccessor;
import org.eclipse.gemoc.ale.interpreted.engine.sirius.ALEInterpreterProvider;
import org.eclipse.gemoc.ale.interpreted.engine.ui.Activator;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.api.MessagingSystem;
import org.eclipse.gemoc.commons.eclipse.ui.ViewHelper;
import org.eclipse.gemoc.dsl.debug.ide.IDSLDebugger;
import org.eclipse.gemoc.dsl.debug.ide.event.DSLDebugEventDispatcher;
import org.eclipse.gemoc.dsl.debug.ide.event.IDSLDebugEventProcessor;
import org.eclipse.gemoc.execution.sequential.javaengine.K3RunConfiguration;
import org.eclipse.gemoc.execution.sequential.javaengine.SequentialModelExecutionContext;
import org.eclipse.gemoc.executionframework.debugger.GenericSequentialModelDebugger;
import org.eclipse.gemoc.executionframework.debugger.IDynamicPartAccessor;
import org.eclipse.gemoc.executionframework.debugger.OmniscientGenericSequentialModelDebugger;
import org.eclipse.gemoc.executionframework.engine.commons.DefaultExecutionPlatform;
import org.eclipse.gemoc.executionframework.engine.commons.EngineContextException;
import org.eclipse.gemoc.executionframework.engine.ui.launcher.AbstractSequentialGemocLauncher;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.gemoc.traceaddon.GenericTraceEngineAddon;
import org.eclipse.gemoc.xdsmlframework.api.core.ExecutionMode;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionContext;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.core.IRunConfiguration;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;
import org.eclipse.sirius.common.tools.api.interpreter.CompoundInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterProvider;

public class Launcher
extends AbstractSequentialGemocLauncher<SequentialModelExecutionContext<K3RunConfiguration>, K3RunConfiguration> {
    public static final String TYPE_ID = "org.eclipse.gemoc.ale.interpreted.engine.ui.launcher";

    protected AleEngine createExecutionEngine(K3RunConfiguration runConfiguration, ExecutionMode executionMode) throws CoreException, EngineContextException {
        AleEngine engine = new AleEngine();
        Set<IInterpreterProvider> aleProviders = CompoundInterpreter.INSTANCE.getProviders().stream().filter(p -> p instanceof ALEInterpreterProvider).collect(Collectors.toSet());
        aleProviders.forEach(p -> CompoundInterpreter.INSTANCE.removeInterpreter(p));
        ALEInterpreterProvider provider = new ALEInterpreterProvider(engine);
        CompoundInterpreter.INSTANCE.registerProvider((IInterpreterProvider)provider);
        SequentialModelExecutionContext executioncontext = new SequentialModelExecutionContext((IRunConfiguration)runConfiguration, executionMode);
        executioncontext.initializeResourceModel();
        engine.initialize((IExecutionContext)executioncontext);
        return engine;
    }

    protected void prepareViews() {
        ViewHelper.retrieveView((String)"org.eclipse.gemoc.executionframework.ui.views.engine.EnginesStatusView");
    }

    protected K3RunConfiguration parseLaunchConfiguration(ILaunchConfiguration configuration) throws CoreException {
        return new K3RunConfiguration(configuration);
    }

    protected MessagingSystem getMessagingSystem() {
        return Activator.getDefault().getMessaggingSystem();
    }

    protected void error(String message, Exception e) {
        Activator.error(message, e);
    }

    protected void setDefaultsLaunchConfiguration(ILaunchConfigurationWorkingCopy configuration) {
    }

    protected String getLaunchConfigurationTypeID() {
        return TYPE_ID;
    }

    protected IDSLDebugger getDebugger(ILaunchConfiguration configuration, DSLDebugEventDispatcher dispatcher, EObject firstInstruction, IProgressMonitor monitor) {
        AleEngine engine = (AleEngine)this.getExecutionEngine();
        Set traceAddons = engine.getAddonsTypedBy(GenericTraceEngineAddon.class);
        for (GenericTraceEngineAddon addon : traceAddons) {
            addon.setDynamicPartAccessor((IDynamicPartAccessor)new AleDynamicAccessor(engine.getInterpreter(), engine.getModelUnits()));
        }
        Object debugger = traceAddons.isEmpty() ? new GenericSequentialModelDebugger((IDSLDebugEventProcessor)dispatcher, (IExecutionEngine)engine) : new OmniscientGenericSequentialModelDebugger((IDSLDebugEventProcessor)dispatcher, (IExecutionEngine)engine);
        debugger.setMutableFieldExtractors(Arrays.asList(new AleDynamicAccessor(engine.getInterpreter(), engine.getModelUnits())));
        try {
            if (configuration.getAttribute("GEMOC_LAUNCH_BREAK_START", false)) {
                debugger.addPredicateBreak(new BiPredicate<IExecutionEngine<?>, Step<?>>(){

                    @Override
                    public boolean test(IExecutionEngine<?> t, Step<?> u) {
                        return true;
                    }
                });
            }
        }
        catch (CoreException e) {
            Activator.error(e.getMessage(), e);
        }
        ((DefaultExecutionPlatform)((SequentialModelExecutionContext)engine.getExecutionContext()).getExecutionPlatform()).addEngineAddon((IEngineAddon)debugger);
        return debugger;
    }

    protected String getDebugJobName(ILaunchConfiguration configuration, EObject firstInstruction) {
        return "Gemoc debug job";
    }

    protected String getPluginID() {
        return "org.eclipse.gemoc.ale.interpreted.engine.ui";
    }

    public String getModelIdentifier() {
        return "org.eclipse.gemoc.execution.sequential.javaengine.ui.debugModel";
    }
}

