/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.stategraph.logic.alg;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gemoc.addon.stategraph.logic.DirectedGraph;

public class JohnsonSimpleCycles<T> {
    private DirectedGraph<T> graph = null;
    private List<T> vertice = null;
    private List<List<T>> cycles = null;
    private Object[] iToV = null;
    private Map<T, Integer> vToI = null;
    private Set<T> blocked = null;
    private Map<T, Set<T>> bSets = null;
    private ArrayDeque<T> stack = null;
    private List<Set<T>> SCCs = null;
    private int index = 0;
    private Map<T, Integer> vIndex = null;
    private Map<T, Integer> vLowlink = null;
    private ArrayDeque<T> path = null;
    private Set<T> pathSet = null;

    public JohnsonSimpleCycles() {
    }

    public JohnsonSimpleCycles(DirectedGraph<T> graph) {
        this.graph = graph;
        this.vertice = graph.getVertice();
    }

    public void setGraph(DirectedGraph<T> graph) {
        this.graph = graph;
        this.vertice = graph.getVertice();
    }

    public List<List<T>> findSimpleCycles() {
        this.initState();
        int startIndex = 0;
        int size = this.vertice.size();
        while (startIndex < size) {
            Object[] minSCCGResult = this.findMinSCSG(startIndex);
            if (minSCCGResult[0] == null) break;
            startIndex = (Integer)minSCCGResult[1];
            DirectedGraph scg = (DirectedGraph)minSCCGResult[0];
            T startV = this.toV(startIndex);
            for (DirectedGraph.Edge<T> e : scg.getOutgoingEdges(startV)) {
                T v = e.getTarget();
                this.blocked.remove(v);
                this.getBSet(v).clear();
            }
            this.findCyclesInSCG(startIndex, startIndex, scg);
            ++startIndex;
        }
        List<List<T>> result = this.cycles;
        this.clearState();
        return result;
    }

    private Object[] findMinSCSG(int startIndex) {
        this.initMinSCGState();
        Object[] result = new Object[2];
        List<Set<T>> SCCs = this.findSCCS(startIndex);
        int minIndexFound = Integer.MAX_VALUE;
        Set<T> minSCC = null;
        for (Set<T> scc : SCCs) {
            for (T v : scc) {
                int t = this.toI(v);
                if (t >= minIndexFound) continue;
                minIndexFound = t;
                minSCC = scc;
            }
        }
        if (minSCC == null) {
            return result;
        }
        DirectedGraph resultGraph = new DirectedGraph();
        for (Object v : minSCC) {
            resultGraph.addVertex(v);
        }
        for (Object v : minSCC) {
            for (Object w : minSCC) {
                if (!this.graph.containsEdge(v, w)) continue;
                resultGraph.addEdge(v, w);
            }
        }
        result[0] = resultGraph;
        result[1] = minIndexFound;
        this.clearMinSCCState();
        return result;
    }

    private List<Set<T>> findSCCS(int startIndex) {
        for (T v : this.vertice) {
            int vI = this.toI(v);
            if (vI < startIndex || this.vIndex.containsKey(v)) continue;
            this.getSCCs(startIndex, vI);
        }
        List<Set<T>> result = this.SCCs;
        this.SCCs = null;
        return result;
    }

    private void getSCCs(int startIndex, int vertexIndex) {
        T vertex = this.toV(vertexIndex);
        this.vIndex.put(vertex, this.index);
        this.vLowlink.put(vertex, this.index);
        ++this.index;
        this.path.push(vertex);
        this.pathSet.add(vertex);
        List<DirectedGraph.Edge<T>> edges = this.graph.getOutgoingEdges(vertex);
        for (DirectedGraph.Edge<T> e : edges) {
            T successor = e.getTarget();
            int successorIndex = this.toI(successor);
            if (successorIndex < startIndex) continue;
            if (!this.vIndex.containsKey(successor)) {
                this.getSCCs(startIndex, successorIndex);
                this.vLowlink.put(vertex, Math.min(this.vLowlink.get(vertex), this.vLowlink.get(successor)));
                continue;
            }
            if (!this.pathSet.contains(successor)) continue;
            this.vLowlink.put(vertex, Math.min(this.vLowlink.get(vertex), this.vIndex.get(successor)));
        }
        if (this.vLowlink.get(vertex).equals(this.vIndex.get(vertex))) {
            T temp;
            HashSet<T> result = new HashSet<T>();
            do {
                temp = this.path.pop();
                this.pathSet.remove(temp);
                result.add(temp);
            } while (!vertex.equals(temp));
            if (result.size() == 1) {
                Object v = result.iterator().next();
                if (this.graph.containsEdge(vertex, v)) {
                    this.SCCs.add(result);
                }
            } else {
                this.SCCs.add(result);
            }
        }
    }

    private boolean findCyclesInSCG(int startIndex, int vertexIndex, DirectedGraph<T> scg) {
        boolean foundCycle = false;
        T vertex = this.toV(vertexIndex);
        this.stack.push(vertex);
        this.blocked.add(vertex);
        for (DirectedGraph.Edge<T> e : scg.getOutgoingEdges(vertex)) {
            T successor = e.getTarget();
            int successorIndex = this.toI(successor);
            if (successorIndex == startIndex) {
                ArrayList<T> cycle = new ArrayList<T>();
                cycle.addAll(this.stack);
                this.cycles.add(cycle);
                foundCycle = true;
                continue;
            }
            if (this.blocked.contains(successor)) continue;
            boolean gotCycle = this.findCyclesInSCG(startIndex, successorIndex, scg);
            boolean bl = foundCycle = foundCycle || gotCycle;
        }
        if (foundCycle) {
            this.unblock(vertex);
        } else {
            for (DirectedGraph.Edge<T> ew : scg.getOutgoingEdges(vertex)) {
                T w = ew.getTarget();
                Set<T> bSet = this.getBSet(w);
                bSet.add(vertex);
            }
        }
        this.stack.pop();
        return foundCycle;
    }

    private void unblock(T vertex) {
        this.blocked.remove(vertex);
        Set<T> bSet = this.getBSet(vertex);
        while (bSet.size() > 0) {
            T w = bSet.iterator().next();
            bSet.remove(w);
            if (!this.blocked.contains(w)) continue;
            this.unblock(w);
        }
    }

    private void initState() {
        this.cycles = new LinkedList<List<T>>();
        this.iToV = this.vertice.toArray();
        this.vToI = new HashMap<T, Integer>();
        this.blocked = new HashSet<T>();
        this.bSets = new HashMap<T, Set<T>>();
        this.stack = new ArrayDeque();
        int i = 0;
        while (i < this.iToV.length) {
            this.vToI.put(this.iToV[i], i);
            ++i;
        }
    }

    private void clearState() {
        this.cycles = null;
        this.iToV = null;
        this.vToI = null;
        this.blocked = null;
        this.bSets = null;
        this.stack = null;
    }

    private void initMinSCGState() {
        this.index = 0;
        this.SCCs = new ArrayList<Set<T>>();
        this.vIndex = new HashMap<T, Integer>();
        this.vLowlink = new HashMap<T, Integer>();
        this.path = new ArrayDeque();
        this.pathSet = new HashSet<T>();
    }

    private void clearMinSCCState() {
        this.index = 0;
        this.SCCs = null;
        this.vIndex = null;
        this.vLowlink = null;
        this.path = null;
        this.pathSet = null;
    }

    private Integer toI(T vertex) {
        return this.vToI.get(vertex);
    }

    private T toV(Integer i) {
        return (T)this.iToV[i];
    }

    private Set<T> getBSet(T v) {
        Set<T> result = this.bSets.get(v);
        if (result == null) {
            result = new HashSet<T>();
            this.bSets.put(v, result);
        }
        return result;
    }
}

