/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.widgets.settings;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.eef.runtime.ui.widgets.settings.EEFFilter;
import org.eclipse.emf.eef.runtime.ui.widgets.settings.EEFInitializer;
import org.eclipse.emf.eef.runtime.ui.widgets.settings.NavigationStep;

public class NavigationStepBuilder {
    private EReference reference;
    private int index;
    private EClassifier discriminator;
    private EEFInitializer init;
    private List<EEFFilter> filters = new ArrayList<EEFFilter>();

    private NavigationStepBuilder() {
    }

    public static NavigationStepBuilder create(EReference reference) {
        NavigationStepBuilder navigationStepBuilder = new NavigationStepBuilder();
        navigationStepBuilder.reference = reference;
        return navigationStepBuilder;
    }

    public NavigationStepBuilder index(int index) {
        this.index = index;
        return this;
    }

    public NavigationStepBuilder discriminator(EClassifier discriminator) {
        this.discriminator = discriminator;
        return this;
    }

    public NavigationStepBuilder init(EEFInitializer init) {
        this.init = init;
        return this;
    }

    public NavigationStepBuilder filter(EEFFilter filter) {
        this.filters.add(filter);
        return this;
    }

    public NavigationStep build() {
        NavigationStepImpl build = new NavigationStepImpl();
        build.reference = this.reference;
        build.index = this.index;
        build.discriminator = this.discriminator;
        build.init = this.init;
        build.filters = this.filters;
        return build;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NavigationStepImpl
    implements NavigationStep {
        private EReference reference;
        private int index = -1;
        private EClassifier discriminator;
        private EEFInitializer init;
        private List<EEFFilter> filters;

        private NavigationStepImpl() {
        }

        @Override
        public EReference getReference() {
            return this.reference;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public EClassifier getDiscriminator() {
            return this.discriminator;
        }

        @Override
        public EEFInitializer getInit() {
            return this.init;
        }

        @Override
        public List<EEFFilter> getFilters() {
            return this.filters;
        }
    }
}

