/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecoretools.ale.ALEInterpreter;
import org.eclipse.emf.ecoretools.ale.Unit;
import org.eclipse.emf.ecoretools.ale.core.parser.Dsl;
import org.eclipse.emf.ecoretools.ale.core.parser.DslBuilder;
import org.eclipse.emf.ecoretools.ale.core.validation.ALEValidator;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.validation.AbstractAleValidator;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class AleValidator
extends AbstractAleValidator {
    public static String ALE_MARKER = "org.eclipse.emf.ecoretools.ale.xtext.AleMarker";

    @Check
    public void checkIsValid(Unit root) {
        try {
            Resource _eResource = root.eResource();
            IFile aleFile = WorkspaceSynchronizer.getFile((Resource)_eResource);
            this.cleanUpMarkers(aleFile);
            IPath _fullPath = aleFile.getFullPath();
            IPath _removeFileExtension = _fullPath.removeFileExtension();
            IPath dslPath = _removeFileExtension.addFileExtension("dsl");
            IWorkspace _workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot ws = _workspace.getRoot();
            IFile dslFile = ws.getFile(dslPath);
            InputStream _contents = dslFile.getContents();
            Dsl dsl = new Dsl(_contents);
            AleValidator.resolveUris(dsl);
            ALEInterpreter interpreter = new ALEInterpreter();
            HashSet _newHashSet = Sets.newHashSet();
            IProject _project = dslFile.getProject();
            String _name = _project.getName();
            HashSet _newHashSet_1 = Sets.newHashSet((Object[])new String[]{_name});
            interpreter.initScope((Set)_newHashSet, (Set)_newHashSet_1);
            IQueryEnvironment _queryEnvironment = interpreter.getQueryEnvironment();
            DslBuilder _dslBuilder = new DslBuilder(_queryEnvironment);
            List parsedSemantics = _dslBuilder.parse(dsl);
            Functions.Function1 _function = it -> (ModelUnit)it.getRoot();
            List _map = ListExtensions.map((List)parsedSemantics, (Functions.Function1)_function);
            Iterable _filterNull = IterableExtensions.filterNull((Iterable)_map);
            Functions.Function1 _function_1 = it -> it.getServices();
            Iterable _map_1 = IterableExtensions.map((Iterable)_filterNull, (Functions.Function1)_function_1);
            Iterable _flatten = Iterables.concat((Iterable)_map_1);
            List services = IterableExtensions.toList((Iterable)_flatten);
            interpreter.registerServices(services);
            IQueryEnvironment _queryEnvironment_1 = interpreter.getQueryEnvironment();
            ALEValidator validator = new ALEValidator(_queryEnvironment_1);
            validator.validate(parsedSemantics);
            List msgs = validator.getMessages();
            Consumer<IValidationMessage> _function_2 = msg -> {
                try {
                    IMarker marker = aleFile.createMarker(ALE_MARKER);
                    String _message = msg.getMessage();
                    marker.setAttribute("message", (Object)_message);
                    marker.setAttribute("severity", 2);
                    int _startPosition = msg.getStartPosition();
                    marker.setAttribute("charStart", _startPosition);
                    int _endPosition = msg.getEndPosition();
                    marker.setAttribute("charEnd", _endPosition);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            msgs.forEach(_function_2);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void resolveUris(Dsl dsl) {
        ArrayList newSemantics = new ArrayList();
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        List _allSemantics = dsl.getAllSemantics();
        Consumer<String> _function = elem -> {
            URI uri = URI.createURI((String)elem);
            if (!Objects.equal((Object)ws, null) && uri.isPlatform()) {
                IWorkspaceRoot _root = ws.getRoot();
                String _platformString = uri.toPlatformString(true);
                IResource file = _root.findMember(_platformString);
                java.net.URI _locationURI = file.getLocationURI();
                String path = _locationURI.getRawPath();
                newSemantics.add(path);
            } else {
                newSemantics.add(elem);
            }
        };
        _allSemantics.forEach(_function);
        List _allSemantics_1 = dsl.getAllSemantics();
        _allSemantics_1.clear();
        List _allSemantics_2 = dsl.getAllSemantics();
        _allSemantics_2.addAll(newSemantics);
    }

    private void cleanUpMarkers(IFile file) {
        try {
            file.deleteMarkers(ALE_MARKER, true, 0);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

