/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.text.MessageFormat;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.PackInvalidException;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.BeforeDfsPackIndexLoadedEvent;
import org.eclipse.jgit.internal.storage.dfs.BlockBasedFile;
import org.eclipse.jgit.internal.storage.dfs.DeltaBaseCache;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectRepresentation;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectToPack;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.dfs.DfsText;
import org.eclipse.jgit.internal.storage.dfs.LargePackedWholeObject;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.internal.storage.pack.BinaryDelta;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.LongList;

public final class DfsPackFile
extends BlockBasedFile {
    private final Object initLock = new Object();
    private volatile DfsBlockCache.Ref<PackIndex> index;
    private volatile DfsBlockCache.Ref<PackReverseIndex> reverseIndex;
    private volatile DfsBlockCache.Ref<PackBitmapIndex> bitmapIndex;
    private volatile LongList corruptObjects;

    DfsPackFile(DfsBlockCache cache, DfsPackDescription desc) {
        super(cache, desc, PackExt.PACK);
        long sz;
        int bs = desc.getBlockSize(PackExt.PACK);
        if (bs > 0) {
            this.setBlockSize(bs);
        }
        this.length = (sz = desc.getFileSize(PackExt.PACK)) > 0L ? sz : -1L;
    }

    public DfsPackDescription getPackDescription() {
        return this.desc;
    }

    public boolean isIndexLoaded() {
        DfsBlockCache.Ref<PackIndex> idxref = this.index;
        return idxref != null && idxref.has();
    }

    void setPackIndex(PackIndex idx) {
        long objCnt = idx.getObjectCount();
        int recSize = 28;
        long sz = objCnt * (long)recSize;
        this.index = this.cache.putRef(this.desc.getStreamKey(PackExt.INDEX), sz, idx);
    }

    public PackIndex getPackIndex(DfsReader ctx) throws IOException {
        return this.idx(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackIndex idx(DfsReader ctx) throws IOException {
        PackIndex idx;
        DfsBlockCache.Ref<PackIndex> idxref = this.index;
        if (idxref != null && (idx = idxref.get()) != null) {
            return idx;
        }
        if (this.invalid) {
            throw new PackInvalidException(this.getFileName());
        }
        Repository.getGlobalListenerList().dispatch(new BeforeDfsPackIndexLoadedEvent(this));
        Object object = this.initLock;
        synchronized (object) {
            PackIndex idx2;
            PackIndex idx3;
            idxref = this.index;
            if (idxref != null && (idx3 = idxref.get()) != null) {
                return idx3;
            }
            DfsStreamKey idxKey = this.desc.getStreamKey(PackExt.INDEX);
            idxref = this.cache.getRef(idxKey);
            if (idxref != null && (idx2 = idxref.get()) != null) {
                this.index = idxref;
                return idx2;
            }
            try {
                ++ctx.stats.readIdx;
                long start = System.nanoTime();
                ReadableChannel rc = ctx.db.openFile(this.desc, PackExt.INDEX);
                try {
                    InputStream in = Channels.newInputStream(rc);
                    int wantSize = 8192;
                    int bs = rc.blockSize();
                    if (0 < bs && bs < wantSize) {
                        bs = wantSize / bs * bs;
                    } else if (bs <= 0) {
                        bs = wantSize;
                    }
                    idx2 = PackIndex.read(new BufferedInputStream(in, bs));
                    ctx.stats.readIdxBytes += rc.position();
                }
                finally {
                    rc.close();
                    ctx.stats.readIdxMicros += DfsPackFile.elapsedMicros(start);
                }
            }
            catch (EOFException e) {
                this.invalid = true;
                throw new IOException(MessageFormat.format(DfsText.get().shortReadOfIndex, this.desc.getFileName(PackExt.INDEX)), e);
            }
            catch (IOException e) {
                this.invalid = true;
                throw new IOException(MessageFormat.format(DfsText.get().cannotReadIndex, this.desc.getFileName(PackExt.INDEX)), e);
            }
            this.setPackIndex(idx2);
            return idx2;
        }
    }

    final boolean isGarbage() {
        return this.desc.getPackSource() == DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackBitmapIndex getBitmapIndex(DfsReader ctx) throws IOException {
        PackBitmapIndex idx;
        if (this.invalid || this.isGarbage() || !this.desc.hasFileExt(PackExt.BITMAP_INDEX)) {
            return null;
        }
        DfsBlockCache.Ref<PackBitmapIndex> idxref = this.bitmapIndex;
        if (idxref != null && (idx = idxref.get()) != null) {
            return idx;
        }
        Object object = this.initLock;
        synchronized (object) {
            long size;
            PackBitmapIndex idx2;
            PackBitmapIndex idx3;
            PackBitmapIndex idx4;
            idxref = this.bitmapIndex;
            if (idxref != null && (idx4 = idxref.get()) != null) {
                return idx4;
            }
            DfsStreamKey bitmapKey = this.desc.getStreamKey(PackExt.BITMAP_INDEX);
            idxref = this.cache.getRef(bitmapKey);
            if (idxref != null && (idx3 = idxref.get()) != null) {
                this.bitmapIndex = idxref;
                return idx3;
            }
            try {
                ++ctx.stats.readBitmap;
                long start = System.nanoTime();
                ReadableChannel rc = ctx.db.openFile(this.desc, PackExt.BITMAP_INDEX);
                try {
                    InputStream in = Channels.newInputStream(rc);
                    int wantSize = 8192;
                    int bs = rc.blockSize();
                    if (0 < bs && bs < wantSize) {
                        bs = wantSize / bs * bs;
                    } else if (bs <= 0) {
                        bs = wantSize;
                    }
                    in = new BufferedInputStream(in, bs);
                    idx2 = PackBitmapIndex.read(in, this.idx(ctx), this.getReverseIdx(ctx));
                }
                finally {
                    size = rc.position();
                    rc.close();
                    ctx.stats.readIdxBytes += size;
                    ctx.stats.readIdxMicros += DfsPackFile.elapsedMicros(start);
                }
            }
            catch (EOFException e) {
                throw new IOException(MessageFormat.format(DfsText.get().shortReadOfIndex, this.desc.getFileName(PackExt.BITMAP_INDEX)), e);
            }
            catch (IOException e) {
                throw new IOException(MessageFormat.format(DfsText.get().cannotReadIndex, this.desc.getFileName(PackExt.BITMAP_INDEX)), e);
            }
            this.bitmapIndex = this.cache.putRef(bitmapKey, size, idx2);
            return idx2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackReverseIndex getReverseIdx(DfsReader ctx) throws IOException {
        PackReverseIndex revidx;
        DfsBlockCache.Ref<PackReverseIndex> revref = this.reverseIndex;
        if (revref != null && (revidx = revref.get()) != null) {
            return revidx;
        }
        Object object = this.initLock;
        synchronized (object) {
            Object idx;
            PackReverseIndex revidx2;
            revref = this.reverseIndex;
            if (revref != null && (revidx2 = revref.get()) != null) {
                return revidx2;
            }
            DfsStreamKey.ForReverseIndex revKey = new DfsStreamKey.ForReverseIndex(this.desc.getStreamKey(PackExt.INDEX));
            revref = this.cache.getRef(revKey);
            if (revref != null && (idx = revref.get()) != null) {
                this.reverseIndex = revref;
                return idx;
            }
            idx = this.idx(ctx);
            PackReverseIndex revidx3 = new PackReverseIndex((PackIndex)idx);
            long cnt = ((PackIndex)idx).getObjectCount();
            this.reverseIndex = this.cache.putRef(revKey, cnt * 8L, revidx3);
            return revidx3;
        }
    }

    public boolean hasObject(DfsReader ctx, AnyObjectId id) throws IOException {
        long offset = this.idx(ctx).findOffset(id);
        return 0L < offset && !this.isCorrupt(offset);
    }

    ObjectLoader get(DfsReader ctx, AnyObjectId id) throws IOException {
        long offset = this.idx(ctx).findOffset(id);
        return 0L < offset && !this.isCorrupt(offset) ? this.load(ctx, offset) : null;
    }

    long findOffset(DfsReader ctx, AnyObjectId id) throws IOException {
        return this.idx(ctx).findOffset(id);
    }

    void resolve(DfsReader ctx, Set<ObjectId> matches, AbbreviatedObjectId id, int matchLimit) throws IOException {
        this.idx(ctx).resolve(matches, id, matchLimit);
    }

    long getObjectCount(DfsReader ctx) throws IOException {
        return this.idx(ctx).getObjectCount();
    }

    private byte[] decompress(long position, int sz, DfsReader ctx) throws IOException, DataFormatException {
        byte[] dstbuf;
        try {
            dstbuf = new byte[sz];
        }
        catch (OutOfMemoryError noMemory) {
            return null;
        }
        if (ctx.inflate(this, position, dstbuf, false) != sz) {
            throw new EOFException(MessageFormat.format(JGitText.get().shortCompressedStreamAt, position));
        }
        return dstbuf;
    }

    void copyPackAsIs(PackOutputStream out, DfsReader ctx) throws IOException {
        if (this.length == -1L) {
            ctx.pin(this, 0L);
            ctx.unpin();
        }
        if (this.cache.shouldCopyThroughCache(this.length)) {
            this.copyPackThroughCache(out, ctx);
        } else {
            this.copyPackBypassCache(out, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPackThroughCache(PackOutputStream out, DfsReader ctx) throws IOException {
        try (Channel rc = null;){
            int n;
            long position = 12L;
            for (long remaining = this.length - 32L; 0L < remaining; remaining -= (long)n) {
                DfsBlock b;
                if (rc != null) {
                    b = this.cache.getOrLoad(this, position, ctx, (ReadableChannel)rc);
                } else {
                    b = (DfsBlock)this.cache.get(this.key, this.alignToBlock(position));
                    if (b == null) {
                        rc = ctx.db.openFile(this.desc, PackExt.PACK);
                        int sz = ctx.getOptions().getStreamPackBufferSize();
                        if (sz > 0) {
                            rc.setReadAheadBytes(sz);
                        }
                        b = this.cache.getOrLoad(this, position, ctx, (ReadableChannel)rc);
                    }
                }
                int ptr = (int)(position - b.start);
                n = (int)Math.min((long)(b.size() - ptr), remaining);
                b.write(out, position, n);
                position += (long)n;
            }
        }
    }

    private long copyPackBypassCache(PackOutputStream out, DfsReader ctx) throws IOException {
        try (ReadableChannel rc = ctx.db.openFile(this.desc, PackExt.PACK);){
            ByteBuffer buf = this.newCopyBuffer(out, rc);
            if (ctx.getOptions().getStreamPackBufferSize() > 0) {
                rc.setReadAheadBytes(ctx.getOptions().getStreamPackBufferSize());
            }
            long position = 12L;
            long remaining = this.length - 32L;
            boolean packHeadSkipped = false;
            while (0L < remaining) {
                DfsBlock b = (DfsBlock)this.cache.get(this.key, this.alignToBlock(position));
                if (b != null) {
                    int ptr = (int)(position - b.start);
                    int n = (int)Math.min((long)(b.size() - ptr), remaining);
                    b.write(out, position, n);
                    remaining -= (long)n;
                    rc.position(position += (long)n);
                    packHeadSkipped = true;
                    continue;
                }
                buf.position(0);
                int n = DfsPackFile.read(rc, buf);
                if (n <= 0) {
                    throw this.packfileIsTruncated();
                }
                if ((long)n > remaining) {
                    n = (int)remaining;
                }
                if (!packHeadSkipped) {
                    out.write(buf.array(), 12, n - 12);
                    packHeadSkipped = true;
                } else {
                    out.write(buf.array(), 0, n);
                }
                position += (long)n;
                remaining -= (long)n;
            }
            long l = position;
            return l;
        }
    }

    private ByteBuffer newCopyBuffer(PackOutputStream out, ReadableChannel rc) {
        byte[] copyBuf;
        int bs = this.blockSize(rc);
        if (bs > (copyBuf = out.getCopyBuffer()).length) {
            copyBuf = new byte[bs];
        }
        return ByteBuffer.wrap(copyBuf, 0, bs);
    }

    void copyAsIs(PackOutputStream out, DfsObjectToPack src, boolean validate, DfsReader ctx) throws IOException, StoredObjectRepresentationNotAvailableException {
        long cnt;
        long pos;
        long expectedCRC;
        DfsBlock quickCopy;
        CRC32 crc1 = validate ? new CRC32() : null;
        CRC32 crc2 = validate ? new CRC32() : null;
        byte[] buf = out.getCopyBuffer();
        try {
            this.readFully(src.offset, buf, 0, 20, ctx);
        }
        catch (IOException ioError) {
            StoredObjectRepresentationNotAvailableException gone = new StoredObjectRepresentationNotAvailableException(src);
            gone.initCause(ioError);
            throw gone;
        }
        int c = buf[0] & 0xFF;
        int typeCode = c >> 4 & 7;
        long inflatedLength = c & 0xF;
        int shift = 4;
        int headerCnt = 1;
        while ((c & 0x80) != 0) {
            c = buf[headerCnt++] & 0xFF;
            inflatedLength += (long)(c & 0x7F) << shift;
            shift += 7;
        }
        if (typeCode == 6) {
            while (((c = buf[headerCnt++] & 0xFF) & 0x80) != 0) {
            }
            if (validate) {
                assert (crc1 != null && crc2 != null);
                crc1.update(buf, 0, headerCnt);
                crc2.update(buf, 0, headerCnt);
            }
        } else if (typeCode == 7) {
            if (validate) {
                assert (crc1 != null && crc2 != null);
                crc1.update(buf, 0, headerCnt);
                crc2.update(buf, 0, headerCnt);
            }
            this.readFully(src.offset + (long)headerCnt, buf, 0, 20, ctx);
            if (validate) {
                assert (crc1 != null && crc2 != null);
                crc1.update(buf, 0, 20);
                crc2.update(buf, 0, 20);
            }
            headerCnt += 20;
        } else if (validate) {
            assert (crc1 != null && crc2 != null);
            crc1.update(buf, 0, headerCnt);
            crc2.update(buf, 0, headerCnt);
        }
        long dataOffset = src.offset + (long)headerCnt;
        long dataLength = src.length;
        try {
            quickCopy = ctx.quickCopy(this, dataOffset, dataLength);
            if (validate && this.idx(ctx).hasCRC32Support()) {
                assert (crc1 != null);
                expectedCRC = this.idx(ctx).findCRC32(src);
                if (quickCopy != null) {
                    quickCopy.crc32(crc1, dataOffset, (int)dataLength);
                } else {
                    int n;
                    pos = dataOffset;
                    for (cnt = dataLength; cnt > 0L; cnt -= (long)n) {
                        n = (int)Math.min(cnt, (long)buf.length);
                        this.readFully(pos, buf, 0, n, ctx);
                        crc1.update(buf, 0, n);
                        pos += (long)n;
                    }
                }
                if (crc1.getValue() != expectedCRC) {
                    this.setCorrupt(src.offset);
                    throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, src.offset, this.getFileName()));
                }
            } else if (validate) {
                assert (crc1 != null);
                Inflater inf = ctx.inflater();
                byte[] tmp = new byte[1024];
                if (quickCopy != null) {
                    quickCopy.check(inf, tmp, dataOffset, (int)dataLength);
                } else {
                    int n;
                    long pos2 = dataOffset;
                    for (long cnt2 = dataLength; cnt2 > 0L; cnt2 -= (long)n) {
                        n = (int)Math.min(cnt2, (long)buf.length);
                        this.readFully(pos2, buf, 0, n, ctx);
                        crc1.update(buf, 0, n);
                        inf.setInput(buf, 0, n);
                        while (inf.inflate(tmp, 0, tmp.length) > 0) {
                        }
                        pos2 += (long)n;
                    }
                }
                if (!inf.finished() || inf.getBytesRead() != dataLength) {
                    this.setCorrupt(src.offset);
                    throw new EOFException(MessageFormat.format(JGitText.get().shortCompressedStreamAt, src.offset));
                }
                expectedCRC = crc1.getValue();
            } else {
                expectedCRC = -1L;
            }
        }
        catch (DataFormatException dataFormat) {
            this.setCorrupt(src.offset);
            CorruptObjectException corruptObject = new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, src.offset, this.getFileName()));
            corruptObject.initCause(dataFormat);
            StoredObjectRepresentationNotAvailableException gone = new StoredObjectRepresentationNotAvailableException(src);
            gone.initCause(corruptObject);
            throw gone;
        }
        catch (IOException ioError) {
            StoredObjectRepresentationNotAvailableException gone = new StoredObjectRepresentationNotAvailableException(src);
            gone.initCause(ioError);
            throw gone;
        }
        if (quickCopy != null) {
            out.writeHeader(src, inflatedLength);
            quickCopy.write(out, dataOffset, (int)dataLength);
        } else if (dataLength <= (long)buf.length) {
            if (!validate) {
                int n;
                pos = dataOffset;
                for (cnt = dataLength; cnt > 0L; cnt -= (long)n) {
                    n = (int)Math.min(cnt, (long)buf.length);
                    this.readFully(pos, buf, 0, n, ctx);
                    pos += (long)n;
                }
            }
            out.writeHeader(src, inflatedLength);
            out.write(buf, 0, (int)dataLength);
        } else {
            int n;
            out.writeHeader(src, inflatedLength);
            pos = dataOffset;
            for (cnt = dataLength; cnt > 0L; cnt -= (long)n) {
                n = (int)Math.min(cnt, (long)buf.length);
                this.readFully(pos, buf, 0, n, ctx);
                if (validate) {
                    assert (crc2 != null);
                    crc2.update(buf, 0, n);
                }
                out.write(buf, 0, n);
                pos += (long)n;
            }
            if (validate) {
                assert (crc2 != null);
                if (crc2.getValue() != expectedCRC) {
                    throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, src.offset, this.getFileName()));
                }
            }
        }
    }

    private IOException packfileIsTruncated() {
        this.invalid = true;
        return new IOException(MessageFormat.format(JGitText.get().packfileIsTruncated, this.getFileName()));
    }

    private void readFully(long position, byte[] dstbuf, int dstoff, int cnt, DfsReader ctx) throws IOException {
        if (ctx.copy(this, position, dstbuf, dstoff, cnt) != cnt) {
            throw new EOFException();
        }
    }

    ObjectLoader load(DfsReader ctx, long pos) throws IOException {
        try {
            byte[] ib = ctx.tempId;
            Delta delta = null;
            byte[] data = null;
            int type = -1;
            boolean cached = false;
            block9: while (true) {
                this.readFully(pos, ib, 0, 20, ctx);
                int c = ib[0] & 0xFF;
                int typeCode = c >> 4 & 7;
                long sz = c & 0xF;
                int shift = 4;
                int p = 1;
                while ((c & 0x80) != 0) {
                    c = ib[p++] & 0xFF;
                    sz += (long)(c & 0x7F) << shift;
                    shift += 7;
                }
                switch (typeCode) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        if (delta != null) {
                            data = this.decompress(pos + (long)p, (int)sz, ctx);
                            type = typeCode;
                            break block9;
                        }
                        if (sz < (long)ctx.getStreamFileThreshold() && (data = this.decompress(pos + (long)p, (int)sz, ctx)) != null) {
                            return new ObjectLoader.SmallObject(typeCode, data);
                        }
                        return new LargePackedWholeObject(typeCode, sz, pos, p, this, ctx.db);
                    }
                    case 6: {
                        c = ib[p++] & 0xFF;
                        long base = c & 0x7F;
                        while ((c & 0x80) != 0) {
                            ++base;
                            c = ib[p++] & 0xFF;
                            base <<= 7;
                            base += (long)(c & 0x7F);
                        }
                        base = pos - base;
                        delta = new Delta(delta, pos, (int)sz, p, base);
                        if (sz != (long)delta.deltaSize) break block9;
                        DeltaBaseCache.Entry e = ctx.getDeltaBaseCache().get(this.key, base);
                        if (e != null) {
                            type = e.type;
                            data = e.data;
                            cached = true;
                            break block9;
                        }
                        pos = base;
                        continue block9;
                    }
                    case 7: {
                        this.readFully(pos + (long)p, ib, 0, 20, ctx);
                        long base = this.findDeltaBase(ctx, ObjectId.fromRaw(ib));
                        delta = new Delta(delta, pos, (int)sz, p + 20, base);
                        if (sz != (long)delta.deltaSize) break block9;
                        DeltaBaseCache.Entry e = ctx.getDeltaBaseCache().get(this.key, base);
                        if (e != null) {
                            type = e.type;
                            data = e.data;
                            cached = true;
                            break block9;
                        }
                        pos = base;
                        continue block9;
                    }
                    default: {
                        throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, typeCode));
                    }
                }
                break;
            }
            if (data == null) {
                throw new LargeObjectException();
            }
            assert (delta != null);
            do {
                byte[] result;
                if (cached) {
                    cached = false;
                } else if (delta.next == null) {
                    ctx.getDeltaBaseCache().put(this.key, delta.basePos, type, data);
                }
                pos = delta.deltaPos;
                byte[] cmds = this.decompress(pos + (long)delta.hdrLen, delta.deltaSize, ctx);
                if (cmds == null) {
                    data = null;
                    throw new LargeObjectException();
                }
                long sz = BinaryDelta.getResultSize(cmds);
                if (Integer.MAX_VALUE <= sz) {
                    throw new LargeObjectException.ExceedsByteArrayLimit();
                }
                try {
                    result = new byte[(int)sz];
                }
                catch (OutOfMemoryError tooBig) {
                    data = null;
                    cmds = null;
                    throw new LargeObjectException.OutOfMemory(tooBig);
                }
                BinaryDelta.apply(data, cmds, result);
                data = result;
            } while ((delta = delta.next) != null);
            return new ObjectLoader.SmallObject(type, data);
        }
        catch (DataFormatException dfe) {
            CorruptObjectException coe = new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, pos, this.getFileName()));
            coe.initCause(dfe);
            throw coe;
        }
    }

    private long findDeltaBase(DfsReader ctx, ObjectId baseId) throws IOException, MissingObjectException {
        long ofs = this.idx(ctx).findOffset(baseId);
        if (ofs < 0L) {
            throw new MissingObjectException(baseId, JGitText.get().missingDeltaBase);
        }
        return ofs;
    }

    byte[] getDeltaHeader(DfsReader wc, long pos) throws IOException, DataFormatException {
        byte[] hdr = new byte[32];
        wc.inflate(this, pos, hdr, true);
        return hdr;
    }

    int getObjectType(DfsReader ctx, long pos) throws IOException {
        int type;
        byte[] ib = ctx.tempId;
        block5: while (true) {
            this.readFully(pos, ib, 0, 20, ctx);
            int c = ib[0] & 0xFF;
            type = c >> 4 & 7;
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return type;
                }
                case 6: {
                    int p = 1;
                    while ((c & 0x80) != 0) {
                        c = ib[p++] & 0xFF;
                    }
                    c = ib[p++] & 0xFF;
                    long ofs = c & 0x7F;
                    while ((c & 0x80) != 0) {
                        ++ofs;
                        c = ib[p++] & 0xFF;
                        ofs <<= 7;
                        ofs += (long)(c & 0x7F);
                    }
                    pos -= ofs;
                    continue block5;
                }
                case 7: {
                    int p = 1;
                    while ((c & 0x80) != 0) {
                        c = ib[p++] & 0xFF;
                    }
                    this.readFully(pos + (long)p, ib, 0, 20, ctx);
                    pos = this.findDeltaBase(ctx, ObjectId.fromRaw(ib));
                    continue block5;
                }
            }
            break;
        }
        throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, type));
    }

    long getObjectSize(DfsReader ctx, AnyObjectId id) throws IOException {
        long offset = this.idx(ctx).findOffset(id);
        return 0L < offset ? this.getObjectSize(ctx, offset) : -1L;
    }

    long getObjectSize(DfsReader ctx, long pos) throws IOException {
        long deltaAt;
        byte[] ib = ctx.tempId;
        this.readFully(pos, ib, 0, 20, ctx);
        int c = ib[0] & 0xFF;
        int type = c >> 4 & 7;
        long sz = c & 0xF;
        int shift = 4;
        int p = 1;
        while ((c & 0x80) != 0) {
            c = ib[p++] & 0xFF;
            sz += (long)(c & 0x7F) << shift;
            shift += 7;
        }
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return sz;
            }
            case 6: {
                c = ib[p++] & 0xFF;
                while ((c & 0x80) != 0) {
                    c = ib[p++] & 0xFF;
                }
                deltaAt = pos + (long)p;
                break;
            }
            case 7: {
                deltaAt = pos + (long)p + 20L;
                break;
            }
            default: {
                throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, type));
            }
        }
        try {
            return BinaryDelta.getResultSize(this.getDeltaHeader(ctx, deltaAt));
        }
        catch (DataFormatException dfe) {
            CorruptObjectException coe = new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, pos, this.getFileName()));
            coe.initCause(dfe);
            throw coe;
        }
    }

    void representation(DfsObjectRepresentation r, long pos, DfsReader ctx, PackReverseIndex rev) throws IOException {
        r.offset = pos;
        byte[] ib = ctx.tempId;
        this.readFully(pos, ib, 0, 20, ctx);
        int c = ib[0] & 0xFF;
        int p = 1;
        int typeCode = c >> 4 & 7;
        while ((c & 0x80) != 0) {
            c = ib[p++] & 0xFF;
        }
        long len = rev.findNextOffset(pos, this.length - 20L) - pos;
        switch (typeCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                r.format = 1;
                r.baseId = null;
                r.length = len - (long)p;
                return;
            }
            case 6: {
                c = ib[p++] & 0xFF;
                long ofs = c & 0x7F;
                while ((c & 0x80) != 0) {
                    ++ofs;
                    c = ib[p++] & 0xFF;
                    ofs <<= 7;
                    ofs += (long)(c & 0x7F);
                }
                r.format = 0;
                r.baseId = rev.findObject(pos - ofs);
                r.length = len - (long)p;
                return;
            }
            case 7: {
                this.readFully(pos + (long)p, ib, 0, 20, ctx);
                r.format = 0;
                r.baseId = ObjectId.fromRaw(ib);
                r.length = len - (long)p - 20L;
                return;
            }
        }
        throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, typeCode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCorrupt(long offset) {
        LongList list = this.corruptObjects;
        if (list == null) {
            return false;
        }
        LongList longList = list;
        synchronized (longList) {
            return list.contains(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCorrupt(long offset) {
        Object object;
        LongList list = this.corruptObjects;
        if (list == null) {
            object = this.initLock;
            synchronized (object) {
                list = this.corruptObjects;
                if (list == null) {
                    this.corruptObjects = list = new LongList();
                }
            }
        }
        object = list;
        synchronized (object) {
            list.add(offset);
        }
    }

    private static class Delta {
        final Delta next;
        final long deltaPos;
        final int deltaSize;
        final int hdrLen;
        final long basePos;

        Delta(Delta next, long ofs, int sz, int hdrLen, long baseOffset) {
            this.next = next;
            this.deltaPos = ofs;
            this.deltaSize = sz;
            this.hdrLen = hdrLen;
            this.basePos = baseOffset;
        }
    }
}

