/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.timeline.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gemoc.timeline.view.ITimelineListener;
import org.eclipse.gemoc.timeline.view.ITimelineProvider;

public abstract class AbstractTimelineProvider
implements ITimelineProvider {
    private List<ITimelineListener> listeners = new ArrayList<ITimelineListener>();

    public void notifyStartChanged(int branch, int start) {
        for (ITimelineListener listener : this.getListeners()) {
            listener.startChanged(branch, start);
        }
    }

    public void notifyEndChanged(int branch, int end) {
        for (ITimelineListener listener : this.getListeners()) {
            listener.endChanged(branch, end);
        }
    }

    public void notifyTextAtChanged(int branch, String text) {
        for (ITimelineListener listener : this.getListeners()) {
            listener.textAtChanged(branch, text);
        }
    }

    public void notifyNumberOfPossibleStepsAtChanged(int branch, int index, int numberOfPossibleStep) {
        for (ITimelineListener listener : this.getListeners()) {
            listener.numberOfPossibleStepsAtChanged(branch, index, numberOfPossibleStep);
        }
    }

    public void notifyTextAtChanged(int branch, int index, String text) {
        for (ITimelineListener listener : this.getListeners()) {
            listener.textAtChanged(branch, index, text);
        }
    }

    public void notifyAtChanged(int branch, int index, int possibleStep, Object object) {
        for (ITimelineListener listener : this.getListeners()) {
            listener.atChanged(branch, index, possibleStep, object);
        }
    }

    public void notifyIsSelectedChanged(int branch, int index, int possibleStep, boolean selected) {
        for (ITimelineListener listener : this.getListeners()) {
            listener.isSelectedChanged(branch, index, possibleStep, selected);
        }
    }

    public void notifyTextAtChanged(int branch, int index, int possibleStep, String text) {
        for (ITimelineListener listener : this.getListeners()) {
            listener.textAtChanged(branch, index, possibleStep, text);
        }
    }

    public void notifyFollowingsChanged(int branch, int index, int possibleStep, int[][] followings) {
        for (ITimelineListener listener : this.getListeners()) {
            listener.followingsChanged(branch, index, possibleStep, followings);
        }
    }

    public void notifyPrecedingsChanged(int branch, int index, int possibleStep, int[][] precedings) {
        for (ITimelineListener listener : this.getListeners()) {
            listener.precedingsChanged(branch, index, possibleStep, precedings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ITimelineListener> getListeners() {
        ArrayList<ITimelineListener> l;
        List<ITimelineListener> list = this.listeners;
        synchronized (list) {
            l = new ArrayList<ITimelineListener>(this.listeners);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTimelineListener(ITimelineListener listener) {
        List<ITimelineListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTimelineListener(ITimelineListener listener) {
        List<ITimelineListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }
}

