/**
 * Copyright (c) 2016 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.executionframework.engine.core;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.gemoc.executionframework.engine.core.AbstractSequentialExecutionEngine;

@SuppressWarnings("all")
public abstract class AbstractCommandBasedSequentialExecutionEngine extends AbstractSequentialExecutionEngine {
  /**
   * Must be called in a callback from the executed code from the operational
   * semantics.
   * 
   * @param caller
   * @param operationName
   * @param operation
   */
  protected void executeOperation(final Object caller, final String className, final String operationName, final Runnable operation) {
    final RecordingCommand rc = new RecordingCommand(this.editingDomain) {
      @Override
      public void doExecute() {
        operation.run();
      }
    };
    try {
      this.beforeExecutionStep(caller, className, operationName, rc);
      rc.execute();
      this.afterExecutionStep();
    } finally {
      rc.dispose();
    }
  }
}
