/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.core.resources;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class FileFinderVisitor
implements IResourceVisitor {
    private ArrayList<String> _searchedFileExtensions = new ArrayList();
    protected List<IFile> _files = new ArrayList<IFile>();

    public FileFinderVisitor(List<String> searchedFileExtensions) {
        this._searchedFileExtensions.addAll(searchedFileExtensions);
    }

    public FileFinderVisitor(String searchedFileExtension) {
        this._searchedFileExtensions.add(searchedFileExtension);
    }

    public IFile getFile() {
        if (this._files.isEmpty()) {
            return null;
        }
        return this._files.get(0);
    }

    public List<IFile> getFiles() {
        return this._files;
    }

    public boolean visit(IResource resource) throws CoreException {
        boolean mustVisitChild = true;
        if (resource instanceof IFile) {
            String resourceExtension = resource.getFileExtension();
            if (resourceExtension == null) {
                resourceExtension = "";
            }
            if (this._searchedFileExtensions.contains(resourceExtension)) {
                this._files.add((IFile)resource);
            }
            mustVisitChild = false;
        }
        return mustVisitChild;
    }
}

