/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util.labelspacing;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.adapters.GraphAdapters;
import org.eclipse.elk.core.util.labelspacing.LabelGroup;
import org.eclipse.elk.core.util.labelspacing.LabelLocation;
import org.eclipse.elk.core.util.nodespacing.Rectangle;
import org.eclipse.elk.core.util.nodespacing.Spacing;

public final class LabelSpaceCalculation {
    private LabelSpaceCalculation() {
    }

    public static Spacing.Insets calculateRequiredNodeLabelSpace(GraphAdapters.NodeAdapter<?> node, double labelSpacing) {
        Spacing.Insets nodeLabelInsets = node.getProperty(CoreOptions.NODE_LABELS_INSETS);
        return LabelSpaceCalculation.calculateRequiredNodeLabelSpace(node, labelSpacing, nodeLabelInsets, new HashMap<LabelLocation, LabelGroup>(), new Spacing.Insets(node.getInsets()));
    }

    public static Spacing.Insets calculateRequiredNodeLabelSpace(GraphAdapters.NodeAdapter<?> node, double labelSpacing, Spacing.Insets nodeLabelInsets, Map<LabelLocation, LabelGroup> labelGroupsBoundingBoxes, Spacing.Insets insets) {
        if (!node.getLabels().iterator().hasNext()) {
            return insets;
        }
        LabelLocation nodeLabelPlacement = LabelLocation.fromNodeLabelPlacement(node.getProperty(CoreOptions.NODE_LABELS_PLACEMENT));
        for (GraphAdapters.LabelAdapter<?> labelAdapter : node.getLabels()) {
            LabelLocation labelPlacement = LabelLocation.fromNodeLabelPlacement(labelAdapter.getProperty(CoreOptions.NODE_LABELS_PLACEMENT));
            if (labelPlacement == LabelLocation.UNDEFINED) {
                labelPlacement = nodeLabelPlacement;
            }
            labelAdapter.setVolatileId(labelPlacement.ordinal());
            Rectangle boundingBox = LabelSpaceCalculation.retrieveLabelGroupsBoundingBox(labelGroupsBoundingBoxes, labelPlacement);
            boundingBox.width = Math.max(boundingBox.width, labelAdapter.getSize().x);
            boundingBox.height += labelAdapter.getSize().y + labelSpacing;
        }
        for (Map.Entry entry : labelGroupsBoundingBoxes.entrySet()) {
            Rectangle boundingBox = (Rectangle)entry.getValue();
            boundingBox.height -= labelSpacing;
            switch ((LabelLocation)((Object)entry.getKey())) {
                case IN_T_L: 
                case IN_T_C: 
                case IN_T_R: {
                    insets.top = Math.max(insets.top, boundingBox.height + labelSpacing + nodeLabelInsets.top);
                    break;
                }
                case IN_C_L: {
                    insets.left = Math.max(insets.left, boundingBox.width + labelSpacing + nodeLabelInsets.left);
                    break;
                }
                case IN_C_R: {
                    insets.right = Math.max(insets.right, boundingBox.width + labelSpacing + nodeLabelInsets.right);
                    break;
                }
                case IN_B_L: 
                case IN_B_C: 
                case IN_B_R: {
                    insets.bottom = Math.max(insets.bottom, boundingBox.height + labelSpacing + nodeLabelInsets.bottom);
                }
            }
        }
        insets.top = Math.max(insets.top, nodeLabelInsets.top);
        insets.left = Math.max(insets.left, nodeLabelInsets.left);
        insets.right = Math.max(insets.right, nodeLabelInsets.right);
        insets.bottom = Math.max(insets.bottom, nodeLabelInsets.bottom);
        return insets;
    }

    private static Rectangle retrieveLabelGroupsBoundingBox(Map<LabelLocation, LabelGroup> labelGroupsBoundingBoxes, LabelLocation location) {
        if (!labelGroupsBoundingBoxes.containsKey((Object)location)) {
            LabelGroup boundingBox = new LabelGroup();
            labelGroupsBoundingBoxes.put(location, boundingBox);
            return boundingBox;
        }
        return labelGroupsBoundingBoxes.get((Object)location);
    }
}

