/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.comments;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.elk.core.comments.IAttachmentTargetProvider;
import org.eclipse.elk.core.klayoutdata.KLayoutData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.graph.KGraphElement;
import org.eclipse.elk.graph.KNode;

public class SiblingAttachmentTargetProvider
implements IAttachmentTargetProvider {
    private boolean includeComments = false;

    public SiblingAttachmentTargetProvider includeComments() {
        this.includeComments = true;
        return this;
    }

    @Override
    public List<KGraphElement> provideAttachmentTargetsFor(KNode comment) {
        if (comment.getParent() == null) {
            return Collections.emptyList();
        }
        return comment.getParent().getChildren().stream().filter(sibling -> sibling != comment).filter(sibling -> this.includeComments || !this.isCommentNode((KGraphElement)sibling)).collect(Collectors.toList());
    }

    private boolean isCommentNode(KGraphElement graphElement) {
        KLayoutData layoutData = (KLayoutData)graphElement.getData(KLayoutData.class);
        return graphElement instanceof KNode && (Boolean)layoutData.getProperty(CoreOptions.COMMENT_BOX) != false;
    }
}

