/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order.counting;

import java.util.Iterator;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.p3order.counting.AbstractCrossingsCounter;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;

public class BarthJuengerMutzelCrossingsCounter
extends AbstractCrossingsCounter {
    private final int[] portPos;

    public BarthJuengerMutzelCrossingsCounter(int[] inLayerEdgeCount, boolean[] hasNorthSouthPorts, int[] portPos) {
        super(inLayerEdgeCount, hasNorthSouthPorts);
        this.portPos = portPos;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int countCrossings(LNode[] leftLayer, LNode[] rightLayer) {
        int nodeEdges;
        int targetCount = 0;
        int edgeCount = 0;
        Layer leftLayerRef = leftLayer[0].getLayer();
        Layer rightLayerRef = rightLayer[0].getLayer();
        LNode[] lNodeArray = rightLayer;
        int n = rightLayer.length;
        int n2 = 0;
        while (n2 < n) {
            LNode node = lNodeArray[n2];
            assert (node.getLayer() == rightLayerRef);
            if (((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                int northInputPorts = 0;
                block1: for (LPort port : node.getPorts()) {
                    if (port.getSide() != PortSide.NORTH) break;
                    for (LEdge lEdge : port.getIncomingEdges()) {
                        if (lEdge.getSource().getNode().getLayer() != leftLayerRef) continue;
                        ++northInputPorts;
                        continue block1;
                    }
                }
                int otherInputPorts = 0;
                Iterator<LPort> portIter = node.getPorts().listIterator(node.getPorts().size());
                while (portIter.hasPrevious()) {
                    LPort lPort = (LPort)((Object)portIter.previous());
                    int portEdges = 0;
                    for (LEdge edge : lPort.getIncomingEdges()) {
                        if (edge.getSource().getNode().getLayer() != leftLayerRef) continue;
                        ++portEdges;
                    }
                    if (portEdges <= 0) continue;
                    if (lPort.getSide() == PortSide.NORTH) {
                        this.portPos[lPort.id] = targetCount++;
                    } else {
                        this.portPos[lPort.id] = targetCount + northInputPorts + otherInputPorts;
                        ++otherInputPorts;
                    }
                    edgeCount += portEdges;
                }
                targetCount += otherInputPorts;
            } else {
                nodeEdges = 0;
                for (LPort port : node.getPorts()) {
                    for (LEdge lEdge : port.getIncomingEdges()) {
                        if (lEdge.getSource().getNode().getLayer() != leftLayerRef) continue;
                        ++nodeEdges;
                    }
                    this.portPos[port.id] = targetCount;
                }
                if (nodeEdges > 0) {
                    ++targetCount;
                    edgeCount += nodeEdges;
                }
            }
            ++n2;
        }
        int[] southSequence = new int[edgeCount];
        int i = 0;
        LNode[] port = leftLayer;
        nodeEdges = leftLayer.length;
        int n3 = 0;
        while (n3 < nodeEdges) {
            LPort target;
            LNode node = port[n3];
            assert (node.getLayer() == leftLayerRef);
            if (((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                for (LPort port2 : node.getPorts()) {
                    int start = i;
                    for (LEdge edge : port2.getOutgoingEdges()) {
                        target = edge.getTarget();
                        if (target.getNode().getLayer() != rightLayerRef) continue;
                        assert (i < edgeCount);
                        BarthJuengerMutzelCrossingsCounter.insert(southSequence, start, i++, this.portPos[target.id]);
                    }
                }
            } else {
                int start = i;
                for (LPort lPort : node.getPorts()) {
                    for (LEdge edge : lPort.getOutgoingEdges()) {
                        target = edge.getTarget();
                        if (target.getNode().getLayer() != rightLayerRef) continue;
                        assert (i < edgeCount);
                        BarthJuengerMutzelCrossingsCounter.insert(southSequence, start, i++, this.portPos[target.id]);
                    }
                }
            }
            ++n3;
        }
        int firstIndex = 1;
        while (firstIndex < targetCount) {
            firstIndex *= 2;
        }
        int treeSize = 2 * firstIndex - 1;
        --firstIndex;
        int[] tree = new int[treeSize];
        int crossCount = 0;
        int k = 0;
        while (k < edgeCount) {
            void var14_33;
            int n4;
            int n5 = n4 = southSequence[k] + firstIndex;
            tree[n5] = tree[n5] + 1;
            while (var14_33 > 0) {
                if (var14_33 % 2 > 0) {
                    crossCount += tree[var14_33 + true];
                }
                void v1 = var14_33 = (var14_33 - true) / 2;
                tree[v1] = tree[v1] + 1;
            }
            ++k;
        }
        return crossCount;
    }

    private static void insert(int[] array, int start, int end, int n) {
        int insx = BarthJuengerMutzelCrossingsCounter.binarySearch(array, start, end, n);
        if (insx < 0) {
            insx = -insx - 1;
        }
        int j = end - 1;
        while (j >= insx) {
            array[j + 1] = array[j];
            --j;
        }
        array[insx] = n;
    }

    private static int binarySearch(int[] a, int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

