/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered;

import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.elk.alg.layered.DebugUtil;
import org.eclipse.elk.alg.layered.GraphConfigurator;
import org.eclipse.elk.alg.layered.ILayoutProcessor;
import org.eclipse.elk.alg.layered.components.ComponentsProcessor;
import org.eclipse.elk.alg.layered.compound.CompoundGraphPostprocessor;
import org.eclipse.elk.alg.layered.compound.CompoundGraphPreprocessor;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LInsets;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.properties.ContentAlignment;
import org.eclipse.elk.alg.layered.properties.GraphProperties;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.BasicProgressMonitor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class KlayLayered {
    private GraphConfigurator graphConfigurator = new GraphConfigurator();
    private ComponentsProcessor componentsProcessor = new ComponentsProcessor();
    private CompoundGraphPreprocessor compoundGraphPreprocessor = new CompoundGraphPreprocessor();
    private CompoundGraphPostprocessor compoundGraphPostprocessor = new CompoundGraphPostprocessor();

    public void doLayout(LGraph lgraph, IElkProgressMonitor monitor) {
        IElkProgressMonitor theMonitor = monitor;
        if (theMonitor == null) {
            theMonitor = new BasicProgressMonitor(0);
        }
        theMonitor.begin("Layered layout", 1.0f);
        this.graphConfigurator.prepareGraphForLayout(lgraph);
        List<LGraph> components = this.componentsProcessor.split(lgraph);
        if (components.size() == 1) {
            this.layout(components.get(0), theMonitor);
        } else {
            float compWork = 1.0f / (float)components.size();
            for (LGraph comp : components) {
                if (monitor.isCanceled()) {
                    return;
                }
                this.layout(comp, theMonitor.subTask(compWork));
            }
        }
        this.componentsProcessor.combine(components, lgraph);
        this.resizeGraph(lgraph);
        theMonitor.done();
    }

    public void doCompoundLayout(LGraph lgraph, IElkProgressMonitor monitor) {
        IElkProgressMonitor theMonitor = monitor;
        if (theMonitor == null) {
            theMonitor = new BasicProgressMonitor(0);
        }
        theMonitor.begin("Layered layout", 3.0f);
        this.compoundGraphPreprocessor.process(lgraph, theMonitor.subTask(1.0f));
        this.recursiveLayout(lgraph, theMonitor.subTask(1.0f));
        this.compoundGraphPostprocessor.process(lgraph, theMonitor.subTask(1.0f));
        theMonitor.done();
    }

    private void recursiveLayout(LGraph lgraph, IElkProgressMonitor monitor) {
        monitor.begin("Recursive layout", 2.0f);
        if (!lgraph.getLayerlessNodes().isEmpty()) {
            float workPerSubgraph = 1.0f / (float)lgraph.getLayerlessNodes().size();
            for (LNode node : lgraph.getLayerlessNodes()) {
                LGraph nestedGraph = (LGraph)node.getProperty(InternalProperties.NESTED_LGRAPH);
                if (nestedGraph == null) continue;
                this.recursiveLayout(nestedGraph, monitor.subTask(workPerSubgraph));
                this.graphLayoutToNode(node, nestedGraph);
            }
            this.graphConfigurator.prepareGraphForLayout(lgraph);
            this.layout(lgraph, monitor);
        }
        this.resizeGraph(lgraph);
        monitor.done();
    }

    public TestExecutionState prepareLayoutTest(LGraph lgraph) {
        TestExecutionState state = new TestExecutionState();
        this.graphConfigurator.prepareGraphForLayout(lgraph);
        if (this.componentsProcessor == null) {
            this.componentsProcessor = new ComponentsProcessor();
        }
        state.graphs = this.componentsProcessor.split(lgraph);
        return state;
    }

    public boolean isLayoutTestFinished(TestExecutionState state) {
        LGraph graph = (LGraph)state.graphs.get(0);
        List algorithm = (List)graph.getProperty(InternalProperties.PROCESSORS);
        return algorithm != null && state.step >= algorithm.size();
    }

    public void runLayoutTestUntil(Class<? extends ILayoutProcessor> phase, boolean inclusive, TestExecutionState state) {
        List algorithm = (List)((LGraph)state.graphs.get(0)).getProperty(InternalProperties.PROCESSORS);
        boolean phaseExists = false;
        ListIterator algorithmIterator = algorithm.listIterator(state.step);
        int phaseIndex = state.step;
        while (algorithmIterator.hasNext() && !phaseExists) {
            if (((ILayoutProcessor)algorithmIterator.next()).getClass().equals(phase)) {
                phaseExists = true;
                if (!inclusive) continue;
                ++phaseIndex;
                continue;
            }
            ++phaseIndex;
        }
        if (!phaseExists) {
            System.err.println("Given processor " + phase + " not part of the remaining algorithm.");
        }
        algorithmIterator = algorithm.listIterator(state.step);
        while (state.step < phaseIndex) {
            this.layoutTest(state.graphs, (ILayoutProcessor)algorithmIterator.next());
            TestExecutionState testExecutionState = state;
            testExecutionState.step = testExecutionState.step + 1;
        }
    }

    public void runLayoutTestUntil(Class<? extends ILayoutProcessor> phase, TestExecutionState state) {
        this.runLayoutTestUntil(phase, true, state);
    }

    public void runLayoutTestStep(TestExecutionState state) {
        if (this.isLayoutTestFinished(state)) {
            throw new IllegalStateException("Current layout test run has finished.");
        }
        List algorithm = (List)((LGraph)state.graphs.get(0)).getProperty(InternalProperties.PROCESSORS);
        this.layoutTest(state.graphs, (ILayoutProcessor)algorithm.get(state.step));
        TestExecutionState testExecutionState = state;
        testExecutionState.step = testExecutionState.step + 1;
    }

    public List<ILayoutProcessor> getLayoutTestConfiguration(TestExecutionState state) {
        return (List)((LGraph)state.graphs.get(0)).getProperty(InternalProperties.PROCESSORS);
    }

    private void layout(LGraph lgraph, IElkProgressMonitor monitor) {
        boolean monitorStarted = monitor.isRunning();
        if (!monitorStarted) {
            monitor.begin("Component Layout", 1.0f);
        }
        List algorithm = (List)lgraph.getProperty(InternalProperties.PROCESSORS);
        float monitorProgress = 1.0f / (float)algorithm.size();
        if (((Boolean)lgraph.getProperty(LayeredOptions.DEBUG_MODE)).booleanValue()) {
            System.out.println("KLay Layered uses the following " + algorithm.size() + " modules:");
            int i = 0;
            for (ILayoutProcessor processor : algorithm) {
                System.out.println("   Slot " + String.format("%1$02d", i++) + ": " + processor.getClass().getName());
            }
            int slotIndex = 0;
            for (ILayoutProcessor processor : algorithm) {
                if (monitor.isCanceled()) {
                    return;
                }
                DebugUtil.writeDebugGraph(lgraph, slotIndex++, processor.getClass().getSimpleName());
                processor.process(lgraph, monitor.subTask(monitorProgress));
            }
            DebugUtil.writeDebugGraph(lgraph, slotIndex, "finished");
        } else {
            for (ILayoutProcessor processor : algorithm) {
                if (monitor.isCanceled()) {
                    return;
                }
                processor.process(lgraph, monitor.subTask(monitorProgress));
            }
        }
        for (Layer layer : lgraph) {
            lgraph.getLayerlessNodes().addAll(layer.getNodes());
            layer.getNodes().clear();
        }
        for (LNode node : lgraph.getLayerlessNodes()) {
            node.setLayer(null);
        }
        lgraph.getLayers().clear();
        if (!monitorStarted) {
            monitor.done();
        }
    }

    private void layoutTest(List<LGraph> lgraphs, ILayoutProcessor processor) {
        for (LGraph graph : lgraphs) {
            processor.process(graph, (IElkProgressMonitor)new BasicProgressMonitor());
        }
    }

    private void resizeGraph(LGraph lgraph) {
        Set sizeConstraint = (Set)lgraph.getProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS);
        Set sizeOptions = (Set)lgraph.getProperty(LayeredOptions.NODE_SIZE_OPTIONS);
        float borderSpacing = ((Float)lgraph.getProperty(LayeredOptions.SPACING_BORDER)).floatValue();
        lgraph.getOffset().x += (double)borderSpacing;
        lgraph.getOffset().y += (double)borderSpacing;
        lgraph.getSize().x += (double)(2.0f * borderSpacing);
        lgraph.getSize().y += (double)(2.0f * borderSpacing);
        lgraph.setProperty(LayeredOptions.SPACING_BORDER, Float.valueOf(0.0f));
        KVector calculatedSize = lgraph.getActualSize();
        KVector adjustedSize = new KVector(calculatedSize);
        if (sizeConstraint.contains(SizeConstraint.MINIMUM_SIZE)) {
            float minHeight;
            float minWidth;
            KVector minSize = (KVector)lgraph.getProperty(LayeredOptions.NODE_SIZE_MINIMUM);
            if (minSize == null) {
                minWidth = ((Float)lgraph.getProperty(LayeredOptions.NODE_SIZE_MIN_WIDTH)).floatValue();
                minHeight = ((Float)lgraph.getProperty(LayeredOptions.NODE_SIZE_MIN_HEIGHT)).floatValue();
            } else {
                minWidth = (float)minSize.x;
                minHeight = (float)minSize.y;
            }
            if (sizeOptions.contains(SizeOptions.DEFAULT_MINIMUM_SIZE)) {
                if (minWidth <= 0.0f) {
                    minWidth = 20.0f;
                }
                if (minHeight <= 0.0f) {
                    minHeight = 20.0f;
                }
            }
            adjustedSize.x = Math.max(calculatedSize.x, (double)minWidth);
            adjustedSize.y = Math.max(calculatedSize.y, (double)minHeight);
        }
        this.resizeGraphNoReallyIMeanIt(lgraph, calculatedSize, adjustedSize);
    }

    private void resizeGraphNoReallyIMeanIt(LGraph lgraph, KVector oldSize, KVector newSize) {
        Set contentAlignment = (Set)lgraph.getProperty(LayeredOptions.CONTENT_ALIGNMENT);
        if (newSize.x > oldSize.x) {
            if (contentAlignment.contains((Object)ContentAlignment.H_CENTER)) {
                lgraph.getOffset().x += (newSize.x - oldSize.x) / 2.0;
            } else if (contentAlignment.contains((Object)ContentAlignment.H_RIGHT)) {
                lgraph.getOffset().x += newSize.x - oldSize.x;
            }
        }
        if (newSize.y > oldSize.y) {
            if (contentAlignment.contains((Object)ContentAlignment.V_CENTER)) {
                lgraph.getOffset().y += (newSize.y - oldSize.y) / 2.0;
            } else if (contentAlignment.contains((Object)ContentAlignment.V_BOTTOM)) {
                lgraph.getOffset().y += newSize.y - oldSize.y;
            }
        }
        if (((Set)lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS) && (newSize.x > oldSize.x || newSize.y > oldSize.y)) {
            for (LNode node : lgraph.getLayerlessNodes()) {
                if (node.getType() != LNode.NodeType.EXTERNAL_PORT) continue;
                PortSide extPortSide = (PortSide)node.getProperty(InternalProperties.EXT_PORT_SIDE);
                if (extPortSide == PortSide.EAST) {
                    node.getPosition().x += newSize.x - oldSize.x;
                    continue;
                }
                if (extPortSide != PortSide.SOUTH) continue;
                node.getPosition().y += newSize.y - oldSize.y;
            }
        }
        LInsets insets = lgraph.getInsets();
        lgraph.getSize().x = newSize.x - insets.left - insets.right;
        lgraph.getSize().y = newSize.y - insets.top - insets.bottom;
    }

    private void graphLayoutToNode(LNode node, LGraph lgraph) {
        for (LNode childNode : lgraph.getLayerlessNodes()) {
            Object origin = childNode.getProperty(InternalProperties.ORIGIN);
            if (!(origin instanceof LPort)) continue;
            LPort port = (LPort)((Object)origin);
            KVector portPosition = LGraphUtil.getExternalPortPosition(lgraph, childNode, port.getSize().x, port.getSize().y);
            port.getPosition().x = portPosition.x;
            port.getPosition().y = portPosition.y;
            port.setSide((PortSide)childNode.getProperty(InternalProperties.EXT_PORT_SIDE));
        }
        KVector actualGraphSize = lgraph.getActualSize();
        if (((Set)lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            node.setProperty(LayeredOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
            ((Set)node.getGraph().getProperty(InternalProperties.GRAPH_PROPERTIES)).add(GraphProperties.NON_FREE_PORTS);
            LGraphUtil.resizeNode(node, actualGraphSize, false, true);
        } else {
            LGraphUtil.resizeNode(node, actualGraphSize, true, true);
        }
    }

    public static class TestExecutionState {
        private List<LGraph> graphs;
        private int step;

        public List<LGraph> getGraphs() {
            return this.graphs;
        }

        public int getStep() {
            return this.step;
        }
    }
}

