/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.xref.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.contribution.xref.core.XReferenceProviderDefinition;
import org.eclipse.contribution.xref.core.XReferenceProviderManager;
import org.eclipse.contribution.xref.internal.ui.inplace.XReferenceInplaceDialog;
import org.eclipse.contribution.xref.internal.ui.text.XRefMessages;
import org.eclipse.contribution.xref.ui.filters.CustomFilterDialog;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;

public class XReferenceCustomFilterActionInplace
extends Action {
    private List providerDefns;
    private List populatingList;
    private List checkedList;
    private List defaultCheckedList;
    private String dialogTitle;
    private String dialogMessage;
    private Shell parentShell;

    public XReferenceCustomFilterActionInplace(Shell shell) {
        this.setText(XRefMessages.OpenCustomFiltersDialogAction_text);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_FILTER);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_FILTER);
        this.populatingList = new ArrayList();
        this.checkedList = new ArrayList();
        this.defaultCheckedList = new ArrayList();
        this.parentShell = shell;
        this.providerDefns = XReferenceProviderManager.getManager().getRegisteredProviders();
        Iterator iter = this.providerDefns.iterator();
        while (iter.hasNext()) {
            List providerDefault;
            List providerCheckedInplace;
            XReferenceProviderDefinition provider = (XReferenceProviderDefinition)iter.next();
            List providerFilters = provider.getAllFilters();
            if (providerFilters != null) {
                Iterator iterator = providerFilters.iterator();
                while (iterator.hasNext()) {
                    String filter = (String)iterator.next();
                    if (this.populatingList.contains(filter)) continue;
                    this.populatingList.add(filter);
                }
            }
            if ((providerCheckedInplace = provider.getCheckedInplaceFilters()) != null) {
                Iterator iterator = providerCheckedInplace.iterator();
                while (iterator.hasNext()) {
                    String filter = (String)iterator.next();
                    this.checkedList.add(filter);
                }
            }
            if ((providerDefault = provider.getDefaultFilters()) != null) {
                Iterator iterator = providerDefault.iterator();
                while (iterator.hasNext()) {
                    String filter = (String)iterator.next();
                    this.defaultCheckedList.add(filter);
                }
            }
            this.dialogTitle = XRefMessages.CustomFilterDialog_title;
            this.dialogMessage = XRefMessages.CustomFilterDialog_message;
        }
    }

    public void run() {
        this.checkedList = CustomFilterDialog.showDialog(this.parentShell, this.populatingList, this.checkedList, this.defaultCheckedList, this.dialogTitle, this.dialogMessage);
        Iterator iter = this.providerDefns.iterator();
        while (iter.hasNext()) {
            XReferenceProviderDefinition provider = (XReferenceProviderDefinition)iter.next();
            provider.setCheckedInplaceFilters(this.checkedList);
        }
        XReferenceProviderManager.getManager().setIsInplace(true);
        XReferenceInplaceDialog.getInplaceDialog().refresh();
    }

    public List getProviderDefns() {
        return this.providerDefns;
    }

    public List getPopulatingList() {
        return this.populatingList;
    }
}

