/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.ui.structure.DiagramAccess;
import org.eclipse.etrice.ui.structure.support.DiagramUtil;
import org.eclipse.etrice.ui.structure.support.Pos;
import org.eclipse.etrice.ui.structure.support.PosAndSize;
import org.eclipse.etrice.ui.structure.support.SupportUtil;
import org.eclipse.etrice.ui.structure.support.provider.IPositionProvider;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ILinkService;

public class SuperDiagramPositionProvider
implements IPositionProvider {
    private PosAndSize posInvSuper;
    private HashMap<String, ElementPosition> obj2pos;
    private HashMap<String, Pos> obj2text;
    private HashMap<String, ArrayList<Pos>> obj2bendpoints;
    private Parent parent;

    private SuperDiagramPositionProvider() {
    }

    public SuperDiagramPositionProvider(StructureClass sc) {
        ActorClass base;
        this.obj2pos = new HashMap();
        this.obj2text = new HashMap();
        this.obj2bendpoints = new HashMap();
        this.parent = new Parent();
        this.parent.key = this.getKey((EObject)sc);
        if (sc instanceof ActorClass && (base = ((ActorClass)sc).getActorBase()) != null) {
            this.mapPositions(base);
        }
    }

    @Override
    public SuperDiagramPositionProvider setNewParent(EObject parent, PosAndSize invisibleRect, PosAndSize innerRect) {
        SuperDiagramPositionProvider pp = new SuperDiagramPositionProvider();
        pp.obj2pos = this.obj2pos;
        pp.obj2text = this.obj2text;
        pp.obj2bendpoints = this.obj2bendpoints;
        pp.posInvSuper = this.posInvSuper;
        Parent newParent = new Parent();
        newParent.key = this.getKey(parent);
        newParent.posInv = invisibleRect;
        pp.parent = newParent;
        return pp;
    }

    @Override
    public boolean contains(EObject obj) {
        String key = this.getKey(obj);
        return this.obj2pos.containsKey(key) || this.obj2text.containsKey(key) || this.obj2bendpoints.containsKey(key);
    }

    @Override
    public PosAndSize getDiagramPosition() {
        return this.posInvSuper;
    }

    @Override
    public PosAndSize getPosition(EObject bo) {
        ElementPosition elem = this.obj2pos.get(this.getKey(bo));
        if (elem == null) {
            return null;
        }
        int x = elem.pos.getX();
        int y = elem.pos.getY();
        int w = elem.pos.getW();
        int h = elem.pos.getH();
        switch (elem.border) {
            case BOTTOM: {
                if (this.parent.posInv.getH() <= this.posInvSuper.getH()) break;
                y = elem.pos.getY() + (this.parent.posInv.getH() - this.posInvSuper.getH());
                break;
            }
            case RIGHT: {
                if (this.parent.posInv.getW() <= this.posInvSuper.getW()) break;
                x = elem.pos.getX() + (this.parent.posInv.getW() - this.posInvSuper.getW());
                break;
            }
        }
        return new PosAndSize(x, y, w, h);
    }

    @Override
    public Pos getConnectionText(EObject obj) {
        Pos p = this.obj2text.get(this.getKey(obj));
        int offsetX = this.parent.posInv.getX() - this.posInvSuper.getX();
        int offsetY = this.parent.posInv.getY() - this.posInvSuper.getY();
        return new Pos(p.getX() + offsetX, p.getY() + offsetY);
    }

    @Override
    public List<Pos> getConnectionBendpoints(EObject obj) {
        ArrayList<Pos> list = this.obj2bendpoints.get(this.getKey(obj));
        int offsetX = this.parent.posInv.getX() - this.posInvSuper.getX();
        int offsetY = this.parent.posInv.getY() - this.posInvSuper.getY();
        return list == null || list.isEmpty() ? Collections.emptyList() : new ArrayList<Pos>(list).stream().map(p -> new Pos(p.getX() + offsetX, p.getY() + offsetY)).collect(Collectors.toList());
    }

    private void mapPositions(ActorClass ac) {
        EObject obj;
        Diagram diagram = new DiagramAccess().getDiagram((EObject)ac);
        if (diagram == null) {
            return;
        }
        ContainerShape acShape = DiagramUtil.findScShape(diagram);
        if (acShape == null) {
            return;
        }
        ILinkService linkService = Graphiti.getLinkService();
        EObject sc = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)acShape);
        if (!sc.eResource().getURI().equals(ac.eResource().getURI())) {
            return;
        }
        this.parent.posInv = this.posInvSuper = DiagramUtil.getPosAndSize(acShape.getGraphicsAlgorithm());
        for (Shape shape : acShape.getChildren()) {
            obj = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)shape);
            if (!(obj instanceof ActorContainerRef) && !(obj instanceof InterfaceItem)) continue;
            PosAndSize objInv = DiagramUtil.getPosAndSize(shape.getGraphicsAlgorithm());
            DiagramUtil.Border border = DiagramUtil.Border.NONE;
            if (obj instanceof ActorContainerRef) {
                for (Shape child : ((ContainerShape)shape).getChildren()) {
                    EObject childBo = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)child);
                    if (!(childBo instanceof InterfaceItem)) continue;
                    PosAndSize ifInv = DiagramUtil.getPosAndSize(child.getGraphicsAlgorithm());
                    this.obj2pos.put(this.getKey(obj) + this.getKey(childBo), new ElementPosition(ifInv, DiagramUtil.Border.NONE));
                }
            } else if (obj instanceof InterfaceItem && obj instanceof Port) {
                Port p = (Port)obj;
                if (!SupportUtil.getInstance().getRoomHelpers().isInternal(p)) {
                    border = DiagramUtil.getNearestBorder(objInv, this.posInvSuper);
                }
            }
            this.obj2pos.put(this.getKey(obj), new ElementPosition(objInv, border));
        }
        for (Connection conn : diagram.getConnections()) {
            ConnectionDecorator cd;
            obj = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)conn);
            if (!(obj instanceof Binding) && !(obj instanceof LayerConnection)) continue;
            if (conn.getConnectionDecorators().size() > 1 && (cd = (ConnectionDecorator)conn.getConnectionDecorators().get(1)).getGraphicsAlgorithm() instanceof Text) {
                GraphicsAlgorithm ga = cd.getGraphicsAlgorithm();
                Pos pos = new Pos(ga.getX(), ga.getY());
                this.obj2text.put(this.getKey(obj), pos);
            }
            if (!(conn instanceof FreeFormConnection)) continue;
            ArrayList<Pos> points = new ArrayList<Pos>();
            for (Point bp : ((FreeFormConnection)conn).getBendpoints()) {
                Pos pos = new Pos(bp.getX(), bp.getY());
                points.add(pos);
            }
            if (points.isEmpty()) continue;
            this.obj2bendpoints.put(this.getKey(obj), points);
        }
    }

    private String getKey(EObject bo) {
        if (bo instanceof StructureClass) {
            return "";
        }
        return this.parent.key + DiagramUtil.getResourcePath(bo);
    }

    private class ElementPosition {
        final PosAndSize pos;
        final DiagramUtil.Border border;

        ElementPosition(PosAndSize pos, DiagramUtil.Border border) {
            this.pos = pos;
            this.border = border;
        }
    }

    private class Parent {
        String key;
        PosAndSize posInv;

        private Parent() {
        }
    }
}

