/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ide;

import com.google.inject.Inject;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.ide.server.symbol.DocumentSymbolMapper;
import org.eclipse.xtext.ide.server.symbol.DocumentSymbolService;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.xbase.lib.Procedures;

public class PatchedDocumentSymbolService
extends DocumentSymbolService {
    @Inject
    private DocumentSymbolMapper.DocumentSymbolNameProvider nameProvider;
    @Inject
    private DocumentSymbolMapper.DocumentSymbolKindProvider kindProvider;
    @Inject
    private WorkspaceSymbolContainerNameProvider containerNameProvider;

    protected void createSymbol(IEObjectDescription description, IReferenceFinder.IResourceAccess resourceAccess, Procedures.Procedure1<? super WorkspaceSymbol> acceptor) {
        String name = this.nameProvider.getName(description);
        if (name == null) {
            return;
        }
        SymbolKind kind = this.kindProvider.getSymbolKind(description);
        if (kind == null) {
            return;
        }
        String containerName = this.containerNameProvider.getContainerName(description);
        this.getSymbolLocation(description, resourceAccess, location -> {
            WorkspaceSymbol symbol = new WorkspaceSymbol(name, kind, Either.forLeft((Object)location), containerName);
            acceptor.apply((Object)symbol);
        });
    }

    public static class WorkspaceSymbolContainerNameProvider {
        public String getContainerName(IEObjectDescription description) {
            QualifiedName qualifiedName = description.getQualifiedName();
            if (qualifiedName == null || qualifiedName.isEmpty()) {
                return null;
            }
            return qualifiedName.skipLast(1).toString();
        }
    }
}

