/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class DataClassGen {
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;
    @Inject
    @Extension
    private CExtensions _cExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        Functions.Function1 function1 = it -> {
            boolean bl = this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
            return !bl;
        };
        Consumer<DataClass> consumer = dc -> {
            String path = this._roomExtensions.getPath((RoomClass)dc);
            String file = this._cExtensions.getCHeaderFileName((RoomClass)dc);
            this.fileIO.generateFile("generating DataClass header", path + file, this.generateHeaderFile(root, (DataClass)dc));
            file = this._cExtensions.getCUtilsFileName((RoomClass)dc);
            this.fileIO.generateFile("generating ProtocolClass utils", path + file, this.generateUtilsFile(root, (DataClass)dc));
            file = this._cExtensions.getCSourceFileName((RoomClass)dc);
            this.fileIO.generateFile("generating DataClass source", path + file, this.generateSourceFile(root, (DataClass)dc));
        };
        IterableExtensions.filter((Iterable)root.getDataClasses(), (Functions.Function1)function1).forEach(consumer);
    }

    public CharSequence generateHeaderFile(Root root, DataClass dc) {
        CharSequence charSequence;
        String string;
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/**");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* @author generated by eTrice");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* Header File of DataClass ");
        String string2 = dc.getName();
        stringConcatenation.append(string2, " ");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append(" ");
        stringConcatenation.append("* ");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*/");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        CharSequence charSequence2 = this._cExtensions.generateIncludeGuardBegin((RoomClass)dc);
        stringConcatenation.append((Object)charSequence2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"etDatatypes.h\"");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("/* include all referenced room classes */");
        stringConcatenation.newLine();
        Object object = root.getReferencedDataClasses((RoomClass)dc);
        Object object2 = root.getReferencedEnumClasses((RoomClass)dc);
        Object object3 = it -> this._cExtensions.getIncludePath((RoomClass)it);
        Object object4 = IterableExtensions.sort((Iterable)IterableExtensions.map((Iterable)Iterables.concat((Iterable)object, (Iterable)object2), (Functions.Function1)object3));
        Object object5 = object4.iterator();
        while (object5.hasNext()) {
            String path = (String)object5.next();
            stringConcatenation.append("#include ");
            stringConcatenation.append(path);
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.newLine();
        object = this._procedureHelpers.userCode(dc, 1);
        stringConcatenation.append(object);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t\t");
        stringConcatenation.newLine();
        stringConcatenation.append("typedef struct {");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        object2 = this._procedureHelpers.attributes(this._roomHelpers.getAllAttributes(dc));
        stringConcatenation.append(object2, "\t");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("} ");
        object3 = dc.getName();
        stringConcatenation.append((String)object3);
        stringConcatenation.append(";");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        object4 = this._roomHelpers.getAllAttributes(dc);
        object5 = object4.iterator();
        while (object5.hasNext()) {
            boolean bl;
            Attribute a = (Attribute)object5.next();
            string = a.getDefaultValueLiteral();
            boolean bl2 = bl = string != null;
            if (!bl) continue;
            charSequence = dc.getName();
            String string3 = charSequence + " ";
            String string4 = a.getName();
            String string5 = string3 + string4;
            String string6 = string5 + ": Attribute initialization not supported in C";
            this.logger.logInfo(string6);
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        object4 = this._procedureHelpers.operationsDeclaration(this._roomHelpers.getLatestOperations(dc), dc.getName());
        stringConcatenation.append(object4);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("/* deep copy */");
        stringConcatenation.newLine();
        stringConcatenation.append("void ");
        String string7 = dc.getName();
        stringConcatenation.append(string7);
        stringConcatenation.append("_deepCopy(");
        object5 = dc.getName();
        stringConcatenation.append((String)object5);
        stringConcatenation.append("* source, ");
        string = dc.getName();
        stringConcatenation.append(string);
        stringConcatenation.append("* target);");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        CharSequence charSequence3 = this._procedureHelpers.userCode(dc, 2);
        stringConcatenation.append((Object)charSequence3);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        charSequence = this._cExtensions.generateIncludeGuardEnd((RoomClass)dc);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    private CharSequence generateUtilsFile(Root root, DataClass dc) {
        StringConcatenation stringConcatenation = null;
        EObject eObject = dc.eContainer();
        String string = ((RoomModel)eObject).getName().replaceAll("\\.", "_");
        String string2 = string + "_";
        String string3 = dc.getName();
        String string4 = string2 + string3;
        String filename = string4 + "_Utils";
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Utils File of DataClass ");
        String string5 = dc.getName();
        stringConcatenation2.append(string5, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* ");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        CharSequence charSequence = this._cExtensions.generateIncludeGuardBegin(filename);
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include ");
        String string6 = this._cExtensions.getIncludePath((RoomClass)dc);
        stringConcatenation2.append(string6);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* access macros for operations and attributes");
        stringConcatenation2.newLine();
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* operations */");
        stringConcatenation2.newLine();
        Object object = this._roomHelpers.getAllOperations(dc);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            StandardOperation op = (StandardOperation)iterator.next();
            String params = this.operationParams((Operation)op);
            stringConcatenation2.newLineIfNotEmpty();
            String args = this.operationArgs((Operation)op);
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("#define ");
            String string7 = op.getName();
            stringConcatenation2.append(string7);
            stringConcatenation2.append("(");
            stringConcatenation2.append(params);
            stringConcatenation2.append(") ");
            String string8 = dc.getName();
            stringConcatenation2.append(string8);
            stringConcatenation2.append("_");
            String string9 = op.getName();
            stringConcatenation2.append(string9);
            stringConcatenation2.append("(self");
            boolean bl2 = op.getArguments().isEmpty();
            boolean bl3 = bl = !bl2;
            if (bl) {
                stringConcatenation2.append(", ");
                stringConcatenation2.append(args);
            }
            stringConcatenation2.append(")");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* attributes */");
        stringConcatenation2.newLine();
        object = this._roomHelpers.getAllAttributes(dc);
        iterator = object.iterator();
        while (iterator.hasNext()) {
            Attribute a = (Attribute)iterator.next();
            stringConcatenation2.append("#define ");
            String string10 = a.getName();
            stringConcatenation2.append(string10);
            stringConcatenation2.append(" (self->");
            String string11 = a.getName();
            stringConcatenation2.append(string11);
            stringConcatenation2.append(")");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        object = this._cExtensions.generateIncludeGuardEnd(filename);
        stringConcatenation2.append(object);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private String operationParams(Operation op) {
        Functions.Function1 function1 = it -> {
            String string = null;
            boolean bl = false;
            boolean bl2 = it.isVarargs();
            if (bl2) {
                bl = true;
                string = "...";
            }
            if (!bl) {
                string = it.getName();
            }
            return string;
        };
        return IterableExtensions.join((Iterable)ListExtensions.map((List)op.getArguments(), (Functions.Function1)function1), (CharSequence)", ");
    }

    private String operationArgs(Operation op) {
        Functions.Function1 function1 = it -> {
            String string = null;
            boolean bl = false;
            boolean bl2 = it.isVarargs();
            if (bl2) {
                bl = true;
                string = "__VA_ARGS__";
            }
            if (!bl) {
                string = it.getName();
            }
            return string;
        };
        return IterableExtensions.join((Iterable)ListExtensions.map((List)op.getArguments(), (Functions.Function1)function1), (CharSequence)", ");
    }

    public CharSequence generateSourceFile(Root root, DataClass dc) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/**");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* @author generated by eTrice");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* Source File of DataClass ");
        String string = dc.getName();
        stringConcatenation.append(string, " ");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append(" ");
        stringConcatenation.append("* ");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*/");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("#include <string.h>");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"");
        String string2 = this._cExtensions.getCHeaderFileName((RoomClass)dc);
        stringConcatenation.append(string2);
        stringConcatenation.append("\"");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("#include \"");
        String string3 = this._cExtensions.getCUtilsFileName((RoomClass)dc);
        stringConcatenation.append(string3);
        stringConcatenation.append("\"");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        CharSequence charSequence = this._procedureHelpers.userCode(dc, 3);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        CharSequence charSequence2 = this._procedureHelpers.operationsImplementation(this._roomHelpers.getLatestOperations(dc), dc.getName());
        stringConcatenation.append((Object)charSequence2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("void ");
        String string4 = dc.getName();
        stringConcatenation.append(string4);
        stringConcatenation.append("_deepCopy(");
        String string5 = dc.getName();
        stringConcatenation.append(string5);
        stringConcatenation.append("* source, ");
        String string6 = dc.getName();
        stringConcatenation.append(string6);
        stringConcatenation.append("* target) {");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        stringConcatenation.append("memcpy(target, source, sizeof(");
        String string7 = dc.getName();
        stringConcatenation.append(string7, "\t");
        stringConcatenation.append("));");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        return stringConcatenation;
    }
}

