/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.statements.seq.assignment;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.chi.codegen.CodeGeneratorContext;
import org.eclipse.escet.chi.codegen.expressions.ExpressionBase;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.statements.seq.assignment.AssignmentFunctions;
import org.eclipse.escet.chi.codegen.statements.seq.assignment.AssignmentNode;
import org.eclipse.escet.chi.codegen.statements.seq.assignment.ChainedAsgNode;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.chi.codegen.types.TypeIDCreation;
import org.eclipse.escet.chi.metamodel.chi.DictType;
import org.eclipse.escet.chi.metamodel.chi.Expression;
import org.eclipse.escet.chi.metamodel.chi.VariableDeclaration;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public class DictionaryProjection
extends ChainedAsgNode {
    public final DictType type;
    public final Expression keyExpr;
    private String keyName = null;
    private boolean initDone = false;

    public DictionaryProjection(DictType type, Expression keyExpr, AssignmentNode child) {
        super(child);
        this.type = type;
        this.keyExpr = keyExpr;
    }

    @Override
    public boolean performsFullAssignment() {
        return false;
    }

    @Override
    public void saveUsedValues(boolean oneAssignment, Set<VariableDeclaration> assigneds, CodeGeneratorContext ctxt, JavaFile currentClass, List<String> lines) {
        Assert.check((!this.initDone ? 1 : 0) != 0);
        this.initDone = true;
        Set useds = Sets.set();
        AssignmentFunctions.expressionCollectVariables(this.keyExpr, useds);
        if (!Sets.isEmptyIntersection((Set)useds, assigneds)) {
            this.keyName = ctxt.makeUniqueName("key");
            ExpressionBase exprCode = ExpressionBase.convertExpression(this.keyExpr, ctxt, currentClass);
            exprCode.setCurrentPositionStatement(lines);
            lines.addAll(exprCode.getCode());
            TypeID keyTid = TypeIDCreation.createTypeID(this.type.getKeyType(), ctxt);
            lines.add(Strings.fmt((String)"%s %s = %s;", (Object[])new Object[]{keyTid.getJavaType(), this.keyName, exprCode.getValue()}));
        }
        this.child.saveUsedValues(oneAssignment, assigneds, ctxt, currentClass, lines);
    }

    @Override
    public void assignValue(String lhsVar, List<Integer> rhsIndices, CodeGeneratorContext ctxt, JavaFile currentClass, List<String> lines) {
        String keyValue = this.keyName;
        if (keyValue == null) {
            ExpressionBase exprCode = ExpressionBase.convertExpression(this.keyExpr, ctxt, currentClass);
            exprCode.setCurrentPositionStatement(lines);
            lines.addAll(exprCode.getCode());
            keyValue = exprCode.getValue();
        }
        TypeID elmTid = TypeIDCreation.createTypeID(this.type.getValueType(), ctxt);
        String tmpName = ctxt.makeUniqueName("tmp");
        if (this.child.performsFullAssignment()) {
            lines.add(Strings.fmt((String)"%s %s;", (Object[])new Object[]{elmTid.getJavaType(), tmpName}));
        } else {
            lines.add(Strings.fmt((String)"%s %s = %s.get(%s);", (Object[])new Object[]{elmTid.getJavaType(), tmpName, lhsVar, keyValue}));
            TypeID keyTid = TypeIDCreation.createTypeID(this.type.getKeyType(), ctxt);
            String excClass = "ChiSimulatorException";
            String doesNotExist = "does not exist in the dictionary";
            if (keyTid.isPrintable()) {
                String keyText = keyTid.getToString(keyValue, currentClass);
                lines.add(Strings.fmt((String)"if (%s == null) {", (Object[])new Object[]{tmpName}));
                lines.add(Strings.fmt((String)"    throw new %s(\"Key \\\"\" + %s + \"\\\" %s.\");", (Object[])new Object[]{"ChiSimulatorException", keyText, "does not exist in the dictionary"}));
                lines.add("}");
            } else {
                lines.add(Strings.fmt((String)"if (%s == null) throw new %s(\"Key %s.\");", (Object[])new Object[]{tmpName, "ChiSimulatorException", "does not exist in the dictionary"}));
            }
            currentClass.addImport("org.eclipse.escet.chi.runtime.ChiSimulatorException", false);
        }
        this.child.assignValue(tmpName, rhsIndices, ctxt, currentClass, lines);
        lines.add(Strings.fmt((String)"%s = %s.modify(%s, %s);", (Object[])new Object[]{lhsVar, lhsVar, keyValue, tmpName}));
    }
}

