/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.javascript.typeinfos;

import java.util.List;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.javascript.JavaScriptDataValue;
import org.eclipse.escet.cif.codegen.typeinfos.StringTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfoHelper;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.FormatDecoder;
import org.eclipse.escet.common.java.FormatDescription;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class JavaScriptStringTypeInfo
extends StringTypeInfo {
    public JavaScriptStringTypeInfo(CifType cifType) {
        super(cifType);
    }

    @Override
    public String getTargetType() {
        return "var";
    }

    @Override
    public void generateCode(CodeContext ctxt) {
    }

    @Override
    public void storeValue(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s = %s;", new Object[]{dest.getData(), sourceValue.getData()});
    }

    @Override
    public void declareInit(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("var %s = %s;", new Object[]{dest.getData(), sourceValue.getData()});
    }

    @Override
    public ExprCode convertLiteral(String value, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        result.setDestination(dest);
        result.setDataValue(new JavaScriptDataValue(value));
        return result;
    }

    @Override
    public String getBinaryExpressionTemplate(BinaryOperator binOp, CodeContext ctxt) {
        if (binOp.equals((Object)BinaryOperator.EQUAL)) {
            return Strings.fmt((String)"%sUtils.equalObjs(${left-value}, ${right-value})", (Object[])new Object[]{ctxt.getPrefix()});
        }
        if (binOp.equals((Object)BinaryOperator.UNEQUAL)) {
            return Strings.fmt((String)"!%sUtils.equalObjs(${left-value}, ${right-value})", (Object[])new Object[]{ctxt.getPrefix()});
        }
        throw new RuntimeException("Unexpected binary operator: " + Strings.str((Object)binOp));
    }

    @Override
    public ExprCode convertConcatenation(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertBinaryExpressionPattern(expr, Strings.fmt((String)"%sUtils.addString(${left-value}, ${right-value})", (Object[])new Object[]{ctxt.getPrefix()}), dest, ctxt);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof StringTypeInfo;
    }

    @Override
    public int hashCode() {
        return JavaScriptStringTypeInfo.class.hashCode();
    }

    @Override
    public ExprCode convertSizeStdLib(Expression expr, Destination dest, CodeContext ctxt) {
        return TypeInfoHelper.convertFunctionCallPattern(Strings.fmt((String)"%sUtils.sizeString(${args})", (Object[])new Object[]{ctxt.getPrefix()}), Lists.list((Object)expr), dest, ctxt);
    }

    @Override
    public ExprCode getProjectedValue(ExprCode childCode, ExprCode indexCode, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        result.add(childCode);
        result.add(indexCode);
        String resultText = Strings.fmt((String)"%sUtils.projectString(%s, %s)", (Object[])new Object[]{ctxt.getPrefix(), childCode.getData(), indexCode.getData()});
        result.setDestination(dest);
        result.setDataValue(new JavaScriptDataValue(resultText));
        return result;
    }

    @Override
    public ExprCode convertFormatFunction(String pattern, List<Expression> args, List<CifType> argTypes, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        result.setDestination(dest);
        FormatDecoder decoder = new FormatDecoder();
        List parts = decoder.decode(pattern);
        StringBuilder patternCode = new StringBuilder();
        List argCodes = Lists.listc((int)parts.size());
        int implicitIndex = 0;
        for (FormatDescription part : parts) {
            if (part.conversion == FormatDescription.Conversion.LITERAL) {
                if (part.text.equals("%")) {
                    patternCode.append("%%");
                    continue;
                }
                patternCode.append(part.text);
                continue;
            }
            int idx = !part.index.isEmpty() ? part.getExplicitIndex() - 1 : implicitIndex++;
            ExprCode argCode = ctxt.exprToTarget(args.get(idx), null);
            result.add(argCode);
            String argText = argCode.getData();
            switch (part.conversion) {
                case BOOLEAN: 
                case INTEGER: 
                case REAL: {
                    patternCode.append(part.toString(false));
                    argCodes.add(argText);
                    break;
                }
                case STRING: {
                    patternCode.append(part.toString(false));
                    CifType nt = argTypes.get(idx);
                    if (!(nt instanceof StringType)) {
                        argText = Strings.fmt((String)"%sUtils.valueToStr(%s)", (Object[])new Object[]{ctxt.getPrefix(), argText});
                    }
                    argCodes.add(argText);
                    break;
                }
                default: {
                    String msg = "Unexpected: " + String.valueOf(part.conversion);
                    throw new RuntimeException(msg);
                }
            }
        }
        StringBuilder rslt = new StringBuilder();
        rslt.append(Strings.fmt((String)"%sUtils.fmt(", (Object[])new Object[]{ctxt.getPrefix()}));
        rslt.append(Strings.stringToJava((String)patternCode.toString()));
        if (!argCodes.isEmpty()) {
            rslt.append(", ");
        }
        rslt.append(String.join((CharSequence)", ", argCodes));
        rslt.append(")");
        result.setDataValue(new JavaScriptDataValue(rslt.toString()));
        return result;
    }
}

