/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.c89;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.CodeGen;
import org.eclipse.escet.cif.codegen.CurlyBraceIfElseGenerator;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.ExprCodeGen;
import org.eclipse.escet.cif.codegen.IfElseGenerator;
import org.eclipse.escet.cif.codegen.TypeCodeGen;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.c89.C89DataValue;
import org.eclipse.escet.cif.codegen.c89.C89ExprCodeGen;
import org.eclipse.escet.cif.codegen.c89.C89FunctionCodeGen;
import org.eclipse.escet.cif.codegen.c89.C89TypeCodeGen;
import org.eclipse.escet.cif.codegen.c89.typeinfos.C89TypeInfoHelper;
import org.eclipse.escet.cif.codegen.options.TargetLanguage;
import org.eclipse.escet.cif.codegen.typeinfos.ArrayTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.RangeCheckErrorLevelText;
import org.eclipse.escet.cif.codegen.typeinfos.TupleTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.codegen.updates.VariableWrapper;
import org.eclipse.escet.cif.codegen.updates.tree.LhsListProjection;
import org.eclipse.escet.cif.codegen.updates.tree.LhsProjection;
import org.eclipse.escet.cif.codegen.updates.tree.LhsTupleProjection;
import org.eclipse.escet.cif.codegen.updates.tree.SingleVariableAssignment;
import org.eclipse.escet.cif.common.CifDocAnnotationUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.print.Print;
import org.eclipse.escet.cif.metamodel.cif.print.PrintFor;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.GridBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class C89CodeGen
extends CodeGen {
    private static final int INDENT = 4;
    public static final String[] RESERVED_C89_WORDS = new String[]{"auto", "break", "case", "char", "const", "continue", "default", "do", "double", "else", "enum", "extern", "float", "for", "goto", "if", "int", "long", "register", "return", "short", "signed", "sizeof", "static", "struct", "switch", "typedef", "union", "unsigned", "void", "volatile", "while"};
    public static final String INITIAL_EVENT_NAME = "EVT_INITIAL_";
    public static final String DELAY_EVENT_NAME = "EVT_DELAY_";
    public static final String ENUM_NAMES_LIST = "enum_names";

    public C89CodeGen() {
        super(TargetLanguage.C89, 4);
    }

    @Override
    protected ExprCodeGen getExpressionCodeGenerator() {
        return new C89ExprCodeGen();
    }

    @Override
    protected TypeCodeGen getTypeCodeGenerator() {
        return new C89TypeCodeGen();
    }

    @Override
    protected void init() {
        super.init();
        this.replacements.put("generated-types", "");
        this.replacements.put("algvar-declarations", "");
        this.replacements.put("algvar-functions", "");
        this.replacements.put("constant-declarations", "");
        this.replacements.put("constant-definitions", "");
        this.replacements.put("constant-initialization", "");
        this.replacements.put("contvars-update", "");
        this.replacements.put("derivative-declarations", "");
        this.replacements.put("derivative-functions", "");
        this.replacements.put("enum-names-list", "");
        this.replacements.put("edge-calls-code-uncontrollables", "");
        this.replacements.put("edge-calls-code-controllables", "");
        this.replacements.put("edge-methods-code", "");
        this.replacements.put("event-declarations", "");
        this.replacements.put("event-name-list", "");
        this.replacements.put("functions-code", "");
        this.replacements.put("functions-declarations", "");
        this.replacements.put("generated-types", "");
        this.replacements.put("initial-print-calls", "");
        this.replacements.put("initialize-statevars", "");
        this.replacements.put("inputvar-declarations", "");
        this.replacements.put("inputvar-definitions", "");
        this.replacements.put("inputvar-function-call", "");
        this.replacements.put("inputvar-function-declaration", "");
        this.replacements.put("input-vars-test-inputvalues", "");
        this.replacements.put("print-function", "");
        this.replacements.put("statevar-declarations", "");
        this.replacements.put("statevar-definitions", "");
        this.replacements.put("time-pre-print-call", "");
        this.replacements.put("time-post-print-call", "");
        this.replacements.put("type-support-code", "");
        String prefix = (String)this.replacements.get("prefix");
        this.replacements.put("PREFIX", Strings.makeUppercase((String)prefix));
    }

    @Override
    protected Set<String> getReservedTargetNames() {
        Set reserved = Sets.setc((int)RESERVED_C89_WORDS.length);
        int i = 0;
        while (i < RESERVED_C89_WORDS.length) {
            reserved.add(RESERVED_C89_WORDS[i]);
            ++i;
        }
        return reserved;
    }

    @Override
    public void performSingleAssign(CodeBox code, SingleVariableAssignment asgn, Expression value, CodeContext readCtxt, CodeContext writeCtxt) {
        Assert.check((asgn.rhsProjections == null ? 1 : 0) != 0);
        Assert.check((asgn.lhsProjections == null ? 1 : 0) != 0);
        Assert.check((!asgn.needsRangeBoundCheck() ? 1 : 0) != 0);
        VariableInformation varInfo = writeCtxt.getWriteVarInfo(asgn.variable);
        ExprCode assignment = readCtxt.exprToTarget(value, writeCtxt.makeDestination(varInfo));
        code.add((Box)assignment.getCode());
        Assert.check((!assignment.hasDataValue() ? 1 : 0) != 0);
    }

    @Override
    public void performAssign(CodeBox code, SingleVariableAssignment asgn, String rhsText, CodeContext readCtxt, CodeContext writeCtxt) {
        ArrayTypeInfo arrayTi;
        LhsTupleProjection tupleLhs;
        TupleTypeInfo tupleTi;
        LhsProjection lhsProj;
        VariableInformation fullVarInfo = writeCtxt.getWriteVarInfo(asgn.variable);
        C89DataValue rhsValue = C89DataValue.makeValue(rhsText);
        if (asgn.lhsProjections == null) {
            CifType assignedType = asgn.getAssignedType();
            TypeInfo rangeCheckInfo = readCtxt.typeToTarget(assignedType);
            MemoryCodeBox rangeCode = this.makeCodeBox();
            rangeCheckInfo.checkRange(assignedType, asgn.valueType, rhsValue, asgn.variableType, fullVarInfo.name, Lists.list(), 0, (CodeBox)rangeCode, readCtxt);
            this.insertRangecheckCode(code, (CodeBox)rangeCode);
            fullVarInfo.typeInfo.storeValue(code, rhsValue, writeCtxt.makeDestination(fullVarInfo));
            return;
        }
        String[] indexTexts = new String[asgn.lhsProjections.length];
        List rangeErrorTexts = Lists.list();
        int i = 0;
        while (i < asgn.lhsProjections.length) {
            LhsProjection lhsProj2 = asgn.lhsProjections[i];
            if (lhsProj2 instanceof LhsTupleProjection) {
                LhsTupleProjection tupleProj = (LhsTupleProjection)lhsProj2;
                indexTexts[i] = Integer.toString(tupleProj.fieldNumber);
                rangeErrorTexts.add(new RangeCheckErrorLevelText(false, tupleProj.getSelectedFieldName()));
            } else {
                LhsListProjection listProj = (LhsListProjection)lhsProj2;
                VariableInformation indexVarInfo = writeCtxt.makeTempVariable((CifType)CifConstructors.newIntType(), "index");
                indexTexts[i] = indexVarInfo.targetRef;
                rangeErrorTexts.add(new RangeCheckErrorLevelText(true, indexVarInfo.targetRef));
                ExprCode indexCode = readCtxt.exprToTarget(listProj.index, null);
                indexVarInfo.typeInfo.declareInit(code, indexCode.getRawDataValue(), writeCtxt.makeDestination(indexVarInfo));
            }
            ++i;
        }
        CifType assignedType = asgn.getAssignedType();
        TypeInfo rangeCheckInfo = readCtxt.typeToTarget(assignedType);
        MemoryCodeBox rangeCode = this.makeCodeBox();
        rangeCheckInfo.checkRange(assignedType, asgn.valueType, rhsValue, asgn.variableType, fullVarInfo.name, rangeErrorTexts, 0, (CodeBox)rangeCode, readCtxt);
        this.insertRangecheckCode(code, (CodeBox)rangeCode);
        int last = asgn.lhsProjections.length - 1;
        VariableInformation[] partVariables = new VariableInformation[last];
        int i2 = 0;
        while (i2 < last) {
            ExprCode projectRhs;
            lhsProj = asgn.lhsProjections[i2];
            CifType elementType = lhsProj.getPartType();
            partVariables[i2] = readCtxt.makeTempVariable(elementType, "part");
            VariableInformation containerInfo = i2 == 0 ? readCtxt.getReadVarInfo(new VariableWrapper(asgn.variable, false)) : partVariables[i2 - 1];
            ExprCode containerValue = new ExprCode();
            containerValue.setDataValue(C89DataValue.makeValue(containerInfo.targetRef));
            if (containerInfo.typeInfo instanceof TupleTypeInfo) {
                tupleTi = (TupleTypeInfo)containerInfo.typeInfo;
                tupleLhs = (LhsTupleProjection)lhsProj;
                projectRhs = tupleTi.getProjectedValue(containerValue, tupleLhs.fieldNumber, null, readCtxt);
            } else {
                Assert.check((boolean)(containerInfo.typeInfo instanceof ArrayTypeInfo));
                arrayTi = (ArrayTypeInfo)containerInfo.typeInfo;
                ExprCode indexVar = new ExprCode();
                indexVar.setDataValue(C89DataValue.makeComputed(indexTexts[i2]));
                projectRhs = arrayTi.getProjectedValue(containerValue, indexVar, null, readCtxt);
            }
            code.add((Box)projectRhs.getCode());
            partVariables[i2].typeInfo.declareInit(code, projectRhs.getRawDataValue(), readCtxt.makeDestination(partVariables[i2]));
            ++i2;
        }
        i2 = last;
        while (i2 >= 0) {
            MemoryCodeBox modify;
            lhsProj = asgn.lhsProjections[i2];
            VariableInformation containerInfo = i2 == 0 ? writeCtxt.getReadVarInfo(new VariableWrapper(asgn.variable, false)) : partVariables[i2 - 1];
            ExprCode containerCode = new ExprCode();
            containerCode.setDataValue(C89DataValue.makeValue(containerInfo.targetRef));
            ExprCode partCode = new ExprCode();
            if (i2 == last) {
                partCode.setDataValue(rhsValue);
            } else {
                partCode.setDataValue(C89DataValue.makeValue(partVariables[i2].targetRef));
            }
            if (containerInfo.typeInfo instanceof TupleTypeInfo) {
                tupleTi = (TupleTypeInfo)containerInfo.typeInfo;
                tupleLhs = (LhsTupleProjection)lhsProj;
                modify = readCtxt.makeCodeBox();
                modify.add((Box)tupleTi.modifyContainer(containerInfo, partCode, tupleLhs.fieldNumber, readCtxt));
            } else {
                Assert.check((boolean)(containerInfo.typeInfo instanceof ArrayTypeInfo));
                arrayTi = (ArrayTypeInfo)containerInfo.typeInfo;
                ExprCode indexCode = new ExprCode();
                indexCode.setDataValue(C89DataValue.makeComputed(indexTexts[i2]));
                modify = arrayTi.modifyContainer(containerInfo, partCode, indexCode, readCtxt);
            }
            code.add((Box)modify);
            --i2;
        }
    }

    void insertRangecheckCode(CodeBox surrounding, CodeBox rangeCode) {
        if (rangeCode.isEmpty()) {
            return;
        }
        surrounding.add("#if CHECK_RANGES");
        surrounding.add((Box)rangeCode);
        surrounding.add("#endif");
    }

    @Override
    public Destination makeDestination(VariableInformation varInfo) {
        return new Destination(null, varInfo.typeInfo, C89DataValue.makeValue(varInfo.targetRef));
    }

    @Override
    public DataValue makeDataValue(String value) {
        return C89DataValue.makeValue(value);
    }

    @Override
    protected void addConstants(CodeContext ctxt) {
        MemoryCodeBox defCode = this.makeCodeBox();
        MemoryCodeBox declCode = this.makeCodeBox();
        MemoryCodeBox initCode = this.makeCodeBox(1);
        for (Constant constant : this.constants) {
            VariableWrapper varWrap = new VariableWrapper((Declaration)constant, false);
            VariableInformation constInfo = ctxt.getReadVarInfo(varWrap);
            String typeName = constInfo.typeInfo.getTargetType();
            String varName = constInfo.targetRef;
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)constant);
            defCode.add();
            declCode.add();
            if (docs.isEmpty()) {
                defCode.add("/** Constant \"%s\". */", new Object[]{constInfo.name});
                declCode.add("/** Constant \"%s\". */", new Object[]{constInfo.name});
            } else {
                String line;
                int n;
                int n2;
                String[] stringArray;
                defCode.add("/**");
                defCode.add(" * Constant \"%s\".", new Object[]{constInfo.name});
                for (String doc : docs) {
                    defCode.add(" *");
                    stringArray = doc.split("\\r?\\n");
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        line = stringArray[n];
                        defCode.add(" * %s", new Object[]{line});
                        ++n;
                    }
                }
                defCode.add(" */");
                declCode.add("/**");
                declCode.add(" * Constant \"%s\".", new Object[]{constInfo.name});
                for (String doc : docs) {
                    declCode.add(" *");
                    stringArray = doc.split("\\r?\\n");
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        line = stringArray[n];
                        declCode.add(" * %s", new Object[]{line});
                        ++n;
                    }
                }
                declCode.add(" */");
            }
            defCode.add("%s %s;", new Object[]{typeName, varName});
            declCode.add("extern %s %s;", new Object[]{typeName, varName});
            ExprCode constantCode = ctxt.exprToTarget(constant.getValue(), ctxt.makeDestination((Declaration)constant));
            initCode.add((Box)constantCode.getCode());
        }
        this.replacements.put("constant-definitions", defCode.toString());
        this.replacements.put("constant-declarations", declCode.toString());
        this.replacements.put("constant-initialization", initCode.toString());
    }

    @Override
    protected void addEvents(CodeContext ctxt) {
        String prefix = (String)this.replacements.get("prefix");
        MemoryCodeBox evtDeclsCode = this.makeCodeBox();
        evtDeclsCode.add("enum %sEventEnum_ {", new Object[]{prefix});
        evtDeclsCode.indent();
        evtDeclsCode.add("/** Initial step. */");
        evtDeclsCode.add("EVT_INITIAL_,");
        evtDeclsCode.add();
        evtDeclsCode.add("/** Delay step. */");
        evtDeclsCode.add("EVT_DELAY_,");
        int i = 0;
        while (i < this.events.size()) {
            Event evt = (Event)this.events.get(i);
            String origName = (String)this.origDeclNames.get(evt);
            Assert.notNull((Object)origName);
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)evt);
            evtDeclsCode.add();
            if (docs.isEmpty()) {
                evtDeclsCode.add(Strings.fmt((String)"/** Event \"%s\". */", (Object[])new Object[]{origName}));
            } else {
                evtDeclsCode.add("/**");
                evtDeclsCode.add(" * Event \"%s\".", new Object[]{origName});
                for (String doc : docs) {
                    evtDeclsCode.add(" *");
                    String[] stringArray = doc.split("\\r?\\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        evtDeclsCode.add(" * %s", new Object[]{line});
                        ++n2;
                    }
                }
                evtDeclsCode.add(" */");
            }
            evtDeclsCode.add(Strings.fmt((String)"%s,", (Object[])new Object[]{this.getTargetRef((PositionObject)evt)}));
            ++i;
        }
        evtDeclsCode.dedent();
        evtDeclsCode.add("};");
        evtDeclsCode.add("typedef enum %sEventEnum_ %s_Event_;", new Object[]{prefix, prefix});
        this.replacements.put("event-declarations", evtDeclsCode.toString());
        MemoryCodeBox evtNamesCode = this.makeCodeBox(1);
        GridBox evtNames = new GridBox(2 + this.events.size(), 2, 0, 1);
        evtNames.set(0, 0, "\"initial-step\",");
        evtNames.set(0, 1, "/**< Initial step. */");
        evtNames.set(1, 0, "\"delay-step\",");
        evtNames.set(1, 1, "/**< Delay step. */");
        int i2 = 0;
        while (i2 < this.events.size()) {
            Event evt = (Event)this.events.get(i2);
            String origName = (String)this.origDeclNames.get(evt);
            Assert.notNull((Object)origName);
            evtNames.set(2 + i2, 0, Strings.fmt((String)"\"%s\",", (Object[])new Object[]{origName}));
            evtNames.set(2 + i2, 1, Strings.fmt((String)"/**< Event \"%s\". */", (Object[])new Object[]{origName}));
            ++i2;
        }
        evtNamesCode.add((Box)evtNames);
        this.replacements.put("event-name-list", evtNamesCode.toString());
    }

    @Override
    protected void addStateVars(CodeContext ctxt) {
        MemoryCodeBox varDefCode = new MemoryCodeBox();
        MemoryCodeBox varDeclCode = new MemoryCodeBox();
        for (Declaration decl : this.stateVars) {
            String kindText;
            String typeText;
            if (decl instanceof DiscVariable) {
                DiscVariable dv = (DiscVariable)decl;
                typeText = CifTextUtils.typeToStr((CifType)dv.getType());
                kindText = "Discrete";
            } else {
                typeText = "real";
                kindText = "Continuous";
            }
            VariableInformation declVarInfo = ctxt.getWriteVarInfo(decl);
            String declaration = Strings.fmt((String)"%s %s;", (Object[])new Object[]{declVarInfo.typeInfo.getTargetType(), declVarInfo.targetRef});
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)decl);
            boolean[] blArray = new boolean[2];
            blArray[1] = true;
            boolean[] blArray2 = blArray;
            int n = blArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isDecl = blArray2[n2];
                MemoryCodeBox code = isDecl ? varDeclCode : varDefCode;
                Object fullDeclaration = isDecl ? "extern " + declaration : declaration;
                code.add();
                if (docs.isEmpty()) {
                    code.add("/** %s variable \"%s %s\". */", new Object[]{kindText, typeText, declVarInfo.name});
                } else {
                    code.add("/**");
                    code.add(" * %s variable \"%s %s\".", new Object[]{kindText, typeText, declVarInfo.name});
                    for (String doc : docs) {
                        code.add(" *");
                        String[] stringArray = doc.split("\\r?\\n");
                        int n3 = stringArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String line = stringArray[n4];
                            code.add(" * %s", new Object[]{line});
                            ++n4;
                        }
                    }
                    code.add(" */");
                }
                code.add((String)fullDeclaration);
                ++n2;
            }
        }
        this.replacements.put("statevar-definitions", varDefCode.toString());
        this.replacements.put("statevar-declarations", varDeclCode.toString());
        MemoryCodeBox code = this.makeCodeBox(1);
        for (Declaration decl : this.stateVars) {
            Expression rhs;
            VariableInformation declVarInfo = ctxt.getWriteVarInfo(decl);
            if (decl instanceof DiscVariable) {
                DiscVariable dv = (DiscVariable)decl;
                Assert.check((dv.getValue() != null ? 1 : 0) != 0);
                Assert.check((dv.getValue().getValues().size() == 1 ? 1 : 0) != 0);
                rhs = (Expression)dv.getValue().getValues().get(0);
            } else {
                ContVariable cv = (ContVariable)decl;
                rhs = cv.getValue();
            }
            ExprCode initValCode = ctxt.exprToTarget(rhs, this.makeDestination(declVarInfo));
            code.add((Box)initValCode.getCode());
        }
        this.replacements.put("initialize-statevars", code.toString());
    }

    @Override
    protected void addContVars(CodeContext ctxt) {
        MemoryCodeBox derivDeclCode = this.makeCodeBox();
        MemoryCodeBox derivDefCode = this.makeCodeBox();
        boolean first = true;
        for (ContVariable cv : this.contVars) {
            VariableInformation cvVarInfo = ctxt.getWriteVarInfo((Declaration)cv);
            if (!first) {
                derivDefCode.add();
            }
            first = false;
            String header = Strings.fmt((String)"RealType %sderiv(void)", (Object[])new Object[]{cvVarInfo.targetRef});
            derivDeclCode.add("%s;", new Object[]{header});
            derivDefCode.add("/** Derivative of \"%s\". */", new Object[]{cvVarInfo.name});
            derivDefCode.add("%s {", new Object[]{header});
            derivDefCode.indent();
            ExprCode derCode = ctxt.exprToTarget(cv.getDerivative(), null);
            derivDefCode.add((Box)derCode.getCode());
            derivDefCode.add("return %s;", new Object[]{derCode.getData()});
            derivDefCode.dedent();
            derivDefCode.add("}");
        }
        this.replacements.put("derivative-declarations", derivDeclCode.toString());
        this.replacements.put("derivative-functions", derivDefCode.toString());
        if (this.contVars.isEmpty()) {
            this.replacements.put("contvars-update", "");
            return;
        }
        MemoryCodeBox code = this.makeCodeBox(2);
        int i = 0;
        while (i < this.contVars.size()) {
            ContVariable cv = (ContVariable)this.contVars.get(i);
            VariableInformation cvVarInfo = ctxt.getWriteVarInfo((Declaration)cv);
            code.add("RealType deriv%d = %sderiv();", new Object[]{i, cvVarInfo.targetRef});
            ++i;
        }
        code.add();
        i = 0;
        while (i < this.contVars.size()) {
            ContVariable var = (ContVariable)this.contVars.get(i);
            String name = this.getTargetRef((PositionObject)var);
            String origName = (String)this.origDeclNames.get(var);
            Assert.notNull((Object)origName);
            code.add("errno = 0;");
            code.add("%s = UpdateContValue(%s + delta * deriv%d, %s, errno == 0);", new Object[]{name, name, i, Strings.stringToJava((String)origName)});
            ++i;
        }
        this.replacements.put("contvars-update", code.toString());
    }

    @Override
    protected void addAlgVars(CodeContext ctxt) {
        MemoryCodeBox defCode = this.makeCodeBox();
        MemoryCodeBox declCode = this.makeCodeBox();
        boolean first = true;
        for (AlgVariable algVar : this.algVars) {
            VariableInformation algVarInfo = ctxt.getWriteVarInfo((Declaration)algVar);
            if (!first) {
                defCode.add();
            }
            first = false;
            TypeInfo ti = ctxt.typeToTarget(algVar.getType());
            String header = Strings.fmt((String)"%s %s(void)", (Object[])new Object[]{ti.getTargetType(), algVarInfo.targetRef});
            declCode.add("%s;", new Object[]{header});
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)algVar);
            if (docs.isEmpty()) {
                defCode.add("/** Algebraic variable %s = %s. */", new Object[]{algVarInfo.name, CifTextUtils.exprToStr((Expression)algVar.getValue())});
            } else {
                defCode.add("/**");
                defCode.add(" * Algebraic variable %s = %s.", new Object[]{algVarInfo.name, CifTextUtils.exprToStr((Expression)algVar.getValue())});
                for (String doc : docs) {
                    defCode.add(" *");
                    String[] stringArray = doc.split("\\r?\\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        defCode.add(" * %s", new Object[]{line});
                        ++n2;
                    }
                }
                defCode.add(" */");
            }
            defCode.add("%s {", new Object[]{header});
            defCode.indent();
            ExprCode valueCode = ctxt.exprToTarget(algVar.getValue(), null);
            defCode.add((Box)valueCode.getCode());
            defCode.add("return %s;", new Object[]{valueCode.getData()});
            defCode.dedent();
            defCode.add("}");
        }
        if (!this.algVars.isEmpty()) {
            declCode.add();
        }
        this.replacements.put("algvar-declarations", declCode.toString());
        this.replacements.put("algvar-functions", defCode.toString());
    }

    @Override
    protected void addInputVars(CodeContext ctxt) {
        Object fillInputCall;
        String fillInputDeclaration;
        String prefix = (String)this.replacements.get("prefix");
        MemoryCodeBox varDefCode = new MemoryCodeBox();
        MemoryCodeBox varDeclCode = new MemoryCodeBox();
        for (InputVariable var : this.inputVars) {
            String typeText = CifTextUtils.typeToStr((CifType)var.getType());
            VariableInformation declVarInfo = ctxt.getWriteVarInfo((Declaration)var);
            String declaration = Strings.fmt((String)"%s %s;", (Object[])new Object[]{declVarInfo.typeInfo.getTargetType(), declVarInfo.targetRef});
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)var);
            boolean[] blArray = new boolean[2];
            blArray[1] = true;
            boolean[] blArray2 = blArray;
            int n = blArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isDecl = blArray2[n2];
                MemoryCodeBox code = isDecl ? varDeclCode : varDefCode;
                Object fullDeclaration = isDecl ? "extern " + declaration : declaration;
                code.add();
                if (docs.isEmpty()) {
                    code.add("/** Input variable \"%s %s\". */", new Object[]{typeText, declVarInfo.name});
                } else {
                    code.add("/**");
                    code.add(" * Input variable \"%s %s\".", new Object[]{typeText, declVarInfo.name});
                    for (String doc : docs) {
                        code.add(" *");
                        String[] stringArray = doc.split("\\r?\\n");
                        int n3 = stringArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String line = stringArray[n4];
                            code.add(" * %s", new Object[]{line});
                            ++n4;
                        }
                    }
                    code.add(" */");
                }
                code.add((String)fullDeclaration);
                ++n2;
            }
        }
        this.replacements.put("inputvar-definitions", varDefCode.toString());
        this.replacements.put("inputvar-declarations", varDeclCode.toString());
        if (this.inputVars.isEmpty()) {
            fillInputDeclaration = "";
            fillInputCall = "";
        } else {
            fillInputDeclaration = Strings.fmt((String)"extern void %s_AssignInputVariables();", (Object[])new Object[]{prefix});
            fillInputCall = Strings.spaces((int)4) + Strings.fmt((String)"%s_AssignInputVariables();", (Object[])new Object[]{prefix});
        }
        this.replacements.put("inputvar-function-declaration", fillInputDeclaration);
        this.replacements.put("inputvar-function-call", fillInputCall);
        MemoryCodeBox inputTestCode = this.makeCodeBox(1);
        if (!this.inputVars.isEmpty()) {
            boolean first = true;
            List funcs = Lists.list();
            for (InputVariable var : this.inputVars) {
                VariableInformation inputVar = ctxt.getWriteVarInfo((Declaration)var);
                Expression value = CifValueUtils.getDefaultValue((CifType)var.getType(), (List)funcs);
                Destination dest = new Destination(null, inputVar.typeInfo, C89DataValue.makeValue(inputVar.targetRef));
                ExprCode initCode = ctxt.exprToTarget(value, dest);
                if (!first) {
                    inputTestCode.add();
                }
                first = false;
                inputTestCode.add("/* Input variable \"%s\". */", new Object[]{inputVar.name});
                inputTestCode.add((Box)initCode.getCode());
            }
            Assert.check((boolean)funcs.isEmpty());
        }
        this.replacements.put("input-vars-test-inputvalues", inputTestCode.toString());
    }

    @Override
    protected void addFunctions(CodeContext ctxt) {
        MemoryCodeBox declCode = this.makeCodeBox(0);
        MemoryCodeBox defCode = this.makeCodeBox(0);
        boolean first = true;
        for (InternalFunction func : this.functions) {
            if (!first) {
                defCode.add();
            }
            first = false;
            C89FunctionCodeGen funcGen = new C89FunctionCodeGen(false, func);
            funcGen.generate((CodeBox)declCode, (CodeBox)defCode, ctxt);
        }
        this.replacements.put("functions-declarations", declCode.toString());
        this.replacements.put("functions-code", defCode.toString());
    }

    @Override
    protected void addEnum(EnumDecl enumDecl, CodeContext ctxt) {
        EnumType enumType = CifConstructors.newEnumType((EnumDecl)enumDecl, null);
        ctxt.typeToTarget((CifType)enumType);
        MemoryCodeBox enumNames = ctxt.makeCodeBox();
        enumNames.add("const char *%s[] = {", new Object[]{ENUM_NAMES_LIST});
        enumNames.indent();
        EList eLits = enumDecl.getLiterals();
        int i = 0;
        while (i < eLits.size()) {
            if (i > 0) {
                enumNames.add();
            }
            EnumLiteral lit = (EnumLiteral)eLits.get(i);
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)lit);
            String name = lit.getName();
            if (docs.isEmpty()) {
                enumNames.add("/** Literal \"%s\". */", new Object[]{name});
            } else {
                enumNames.add("/**");
                enumNames.add(" * Literal \"%s\".", new Object[]{name});
                for (String doc : docs) {
                    enumNames.add(" *");
                    String[] stringArray = doc.split("\\r?\\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        enumNames.add(" * %s", new Object[]{line});
                        ++n2;
                    }
                }
                enumNames.add(" */");
            }
            enumNames.add("%s,", new Object[]{Strings.stringToJava((String)name)});
            ++i;
        }
        enumNames.dedent();
        enumNames.add("};");
        this.replacements.put("enum-names-list", enumNames.toString());
    }

    @Override
    protected void addPrints(CodeContext ctxt) {
        MemoryCodeBox code = this.makeCodeBox();
        code.add("#if PRINT_OUTPUT");
        String prefix = (String)this.replacements.get("prefix");
        code.add("static void PrintOutput(%s_Event_ event, BoolType pre) {", new Object[]{prefix});
        code.indent();
        VariableInformation txtVarInfo = ctxt.makeTempVariable((CifType)CifConstructors.newStringType(), "text_var");
        List preCodes = Lists.listc((int)this.printDecls.size());
        List postCodes = Lists.listc((int)this.printDecls.size());
        for (Print print : this.printDecls) {
            String targetFile = Strings.stringToJava((String)print.getFile().getPath());
            CodeBox printCode = this.genPrint(print.getWhenPre(), (List<PrintFor>)print.getFors(), print.getTxtPre(), txtVarInfo, targetFile, ctxt);
            if (printCode != null) {
                preCodes.add(printCode);
            }
            if ((printCode = this.genPrint(print.getWhenPost(), (List<PrintFor>)print.getFors(), print.getTxtPost(), txtVarInfo, targetFile, ctxt)) == null) continue;
            postCodes.add(printCode);
        }
        if (!preCodes.isEmpty() || !postCodes.isEmpty()) {
            code.add("%s %s;", new Object[]{txtVarInfo.typeInfo.getTargetType(), txtVarInfo.targetRef});
            code.add();
            if (!preCodes.isEmpty()) {
                code.add("if (pre) {");
                code.indent();
                boolean first = true;
                for (CodeBox box : preCodes) {
                    if (!first) {
                        code.add();
                    }
                    first = false;
                    code.add((Box)box);
                }
                code.dedent();
            }
            if (!postCodes.isEmpty()) {
                code.add(preCodes.isEmpty() ? "if (!pre) {" : "} else {");
                code.indent();
                boolean first = true;
                for (CodeBox box : postCodes) {
                    if (!first) {
                        code.add();
                    }
                    first = false;
                    code.add((Box)box);
                }
                code.dedent();
            }
            code.add("}");
        }
        code.dedent();
        code.add("}");
        code.add("#endif");
        this.replacements.put("print-function", code.toString());
    }

    @Override
    protected void addSvgDecls(CodeContext ctxt, String cifSpecFileDir) {
        Assert.check((boolean)this.svgDecls.isEmpty());
    }

    private String makeForPrintConditions(String eventVar, List<PrintFor> fors) {
        if (fors.isEmpty()) {
            return "TRUE";
        }
        List conds = Lists.listc((int)fors.size());
        for (PrintFor pf : fors) {
            switch (pf.getKind()) {
                case EVENT: {
                    conds.add(Strings.fmt((String)"%s > %s", (Object[])new Object[]{eventVar, DELAY_EVENT_NAME}));
                    break;
                }
                case FINAL: {
                    break;
                }
                case INITIAL: {
                    conds.add(Strings.fmt((String)"%s == %s", (Object[])new Object[]{eventVar, INITIAL_EVENT_NAME}));
                    break;
                }
                case NAME: {
                    Expression eventRef = pf.getEvent();
                    Assert.check((boolean)(eventRef instanceof EventExpression));
                    Event event = ((EventExpression)eventRef).getEvent();
                    conds.add(Strings.fmt((String)"%s == %s", (Object[])new Object[]{eventVar, this.getTargetRef((PositionObject)event)}));
                    break;
                }
                case TIME: {
                    conds.add(Strings.fmt((String)"%s == %s", (Object[])new Object[]{eventVar, DELAY_EVENT_NAME}));
                    break;
                }
                default: {
                    Assert.fail((Object)"Unexpected kind of print event.");
                }
            }
        }
        if (conds.isEmpty()) {
            return null;
        }
        if (conds.size() == 1) {
            return (String)conds.get(0);
        }
        return String.join((CharSequence)" || ", conds);
    }

    private CodeBox genPrint(Expression whenPred, List<PrintFor> fors, Expression txtExpr, VariableInformation txtVarInfo, String targetFile, CodeContext ctxt) {
        if (txtExpr == null) {
            return null;
        }
        String forConds = this.makeForPrintConditions("event", fors);
        if (forConds == null) {
            return null;
        }
        MemoryCodeBox valueCode = ctxt.makeCodeBox();
        CifType valueType = txtExpr.getType();
        if (valueType instanceof StringType) {
            ExprCode strCode = ctxt.exprToTarget(txtExpr, this.makeDestination(txtVarInfo));
            valueCode.add((Box)strCode.getCode());
        } else {
            Object valueText;
            TypeInfo ti = ctxt.typeToTarget(valueType);
            ExprCode strCode = ctxt.exprToTarget(txtExpr, null);
            valueCode.add((Box)strCode.getCode());
            DataValue dataValue = strCode.getRawDataValue();
            if (C89TypeInfoHelper.typeUsesValues(ti)) {
                valueText = dataValue.getData();
            } else if (dataValue.canBeReferenced()) {
                valueText = dataValue.getReference();
            } else {
                VariableInformation tempVar = ctxt.makeTempVariable(ti, "print_temp");
                valueCode.add(Strings.fmt((String)"%s %s = %s;", (Object[])new Object[]{ti.getTargetType(), tempVar.targetRef, dataValue.getData()}));
                valueText = "&" + tempVar.targetRef;
            }
            valueCode.add("%s(%s, %s.data, 0, MAX_STRING_SIZE);", new Object[]{C89TypeInfoHelper.typeGetTypePrintName(ti, true), valueText, txtVarInfo.targetRef});
        }
        MemoryCodeBox result = ctxt.makeCodeBox();
        boolean unconditional = forConds.equals("TRUE");
        if (whenPred != null) {
            ExprCode whenCondCode = ctxt.exprToTarget(whenPred, null);
            result.add((Box)whenCondCode.getCode());
            if (unconditional) {
                forConds = whenCondCode.getData();
                unconditional = false;
            } else {
                forConds = Strings.fmt((String)"(%s) && (%s)", (Object[])new Object[]{forConds, whenCondCode.getData()});
            }
        }
        if (!unconditional) {
            result.add("if (%s) {", new Object[]{forConds});
            result.indent();
        }
        result.add((Box)valueCode);
        String prefix = (String)this.replacements.get("prefix");
        result.add("%s_PrintOutput(%s.data, %s);", new Object[]{prefix, txtVarInfo.targetRef, targetFile});
        if (!unconditional) {
            result.dedent();
            result.add("}");
        }
        return result;
    }

    @Override
    protected void addEdges(CodeContext ctxt, String cifSpecFileDir) {
        Assert.check((boolean)this.svgInEdges.isEmpty());
        Assert.check((boolean)this.environmentEvents.isEmpty());
        MemoryCodeBox codeCallsUncontrollables = this.makeCodeBox(2);
        MemoryCodeBox codeCallsControllables = this.makeCodeBox(2);
        MemoryCodeBox codeMethods = this.makeCodeBox(0);
        int edgeIdx = 0;
        edgeIdx = this.addEdges(this.uncontrollableEdges, edgeIdx, (CodeBox)codeCallsUncontrollables, (CodeBox)codeMethods, ctxt);
        edgeIdx = this.addEdges(this.controllableEdges, edgeIdx, (CodeBox)codeCallsControllables, (CodeBox)codeMethods, ctxt);
        this.replacements.put("edge-calls-code-uncontrollables", codeCallsUncontrollables.toString());
        this.replacements.put("edge-calls-code-controllables", codeCallsControllables.toString());
        this.replacements.put("edge-methods-code", codeMethods.toString());
        MemoryCodeBox code = this.makeCodeBox(1);
        code.add("#if PRINT_OUTPUT");
        code.indent();
        code.add("/* pre-initial and post-initial prints. */");
        code.add("PrintOutput(%s, TRUE);", new Object[]{INITIAL_EVENT_NAME});
        code.add("PrintOutput(%s, FALSE);", new Object[]{INITIAL_EVENT_NAME});
        code.dedent();
        code.add("#endif");
        this.replacements.put("initial-print-calls", code.toString());
        code = this.makeCodeBox(1);
        code.add("#if PRINT_OUTPUT");
        code.indent();
        code.add("/* pre-timestep print. */");
        code.add("PrintOutput(%s, TRUE);", new Object[]{DELAY_EVENT_NAME});
        code.dedent();
        code.add("#endif");
        this.replacements.put("time-pre-print-call", code.toString());
        code = this.makeCodeBox(1);
        code.add("#if PRINT_OUTPUT");
        code.indent();
        code.add("/* post-timestep print. */");
        code.add("PrintOutput(%s, FALSE);", new Object[]{DELAY_EVENT_NAME});
        code.dedent();
        code.add("#endif");
        this.replacements.put("time-post-print-call", code.toString());
    }

    private int addEdges(List<Edge> edges, int edgeIdx, CodeBox codeCalls, CodeBox codeMethods, CodeContext ctxt) {
        String prefix = ctxt.getPrefix();
        int i = 0;
        while (i < edges.size()) {
            Expression guard;
            Edge edge = edges.get(i);
            Assert.check((edge.getEvents().size() == 1 ? 1 : 0) != 0);
            Expression eventRef = ((EdgeEvent)Lists.first((List)edge.getEvents())).getEvent();
            Event event = ((EventExpression)eventRef).getEvent();
            String eventName = (String)this.origDeclNames.get(event);
            Assert.notNull((Object)eventName);
            String eventTargetName = this.getTargetRef((PositionObject)event);
            codeCalls.add("edgeExecuted |= execEdge%d(); /* (Try to) perform edge with index %d and event \"%s\". */", new Object[]{edgeIdx, edgeIdx, eventName});
            List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)event);
            codeMethods.add();
            codeMethods.add("/**");
            codeMethods.add(" * Execute code for edge with index %d and event \"%s\".", new Object[]{edgeIdx, eventName});
            for (String doc : docs) {
                codeMethods.add(" *");
                String[] stringArray = doc.split("\\r?\\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    codeMethods.add(" * %s", new Object[]{line});
                    ++n2;
                }
            }
            codeMethods.add(" *");
            codeMethods.add(" * @return Whether the edge was performed.");
            codeMethods.add(" */");
            codeMethods.add("static BoolType execEdge%d(void) {", new Object[]{edgeIdx});
            codeMethods.indent();
            EList guards = edge.getGuards();
            Assert.check((guards.size() <= 1 ? 1 : 0) != 0);
            Expression expression = guard = guards.isEmpty() ? null : (Expression)Lists.first((List)guards);
            if (guard != null) {
                ExprCode guardCode = ctxt.exprToTarget(guard, null);
                codeMethods.add((Box)guardCode.getCode());
                codeMethods.add("BoolType guard = %s;", new Object[]{guardCode.getData()});
                codeMethods.add("if (!guard) return FALSE;");
                codeMethods.add();
            }
            if (!this.printDecls.isEmpty()) {
                codeMethods.add("#if PRINT_OUTPUT");
                codeMethods.indent();
                codeMethods.add("PrintOutput(%s, TRUE);", new Object[]{eventTargetName});
                codeMethods.dedent();
                codeMethods.add("#endif");
            }
            codeMethods.add("#if EVENT_OUTPUT");
            codeMethods.indent();
            codeMethods.add("%s_InfoEvent(%s, TRUE);", new Object[]{prefix, eventTargetName});
            codeMethods.dedent();
            codeMethods.add("#endif");
            codeMethods.add();
            if (!edge.getUpdates().isEmpty()) {
                this.addUpdates((List<Update>)edge.getUpdates(), codeMethods, ctxt);
                codeMethods.add();
            }
            codeMethods.add("#if EVENT_OUTPUT");
            codeMethods.indent();
            codeMethods.add("%s_InfoEvent(%s, FALSE);", new Object[]{prefix, eventTargetName});
            codeMethods.dedent();
            codeMethods.add("#endif");
            if (!this.printDecls.isEmpty()) {
                codeMethods.add("#if PRINT_OUTPUT");
                codeMethods.indent();
                codeMethods.add("PrintOutput(%s, FALSE);", new Object[]{eventTargetName});
                codeMethods.dedent();
                codeMethods.add("#endif");
            }
            codeMethods.add("return TRUE;");
            codeMethods.dedent();
            codeMethods.add("}");
            ++i;
            ++edgeIdx;
        }
        return edgeIdx;
    }

    @Override
    protected IfElseGenerator getIfElseUpdateGenerator() {
        return new CurlyBraceIfElseGenerator();
    }

    @Override
    protected void addUpdatesBeginScope(CodeBox code) {
        code.add("{");
        code.indent();
    }

    @Override
    protected void addUpdatesEndScope(CodeBox code) {
        code.dedent();
        code.add("}");
    }

    @Override
    protected void addSpec(CodeContext ctxt) {
        List docs = CifDocAnnotationUtils.getDocs((AnnotatedObject)this.spec);
        MemoryCodeBox specCommentsBox = this.makeCodeBox(0);
        for (String doc : docs) {
            specCommentsBox.add(" *");
            String[] stringArray = doc.split("\\r?\\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                specCommentsBox.add(" * %s", new Object[]{line});
                ++n2;
            }
        }
        Object specCommentsCode = specCommentsBox.toString();
        if (!((String)specCommentsCode).isEmpty()) {
            specCommentsCode = (String)specCommentsCode + "\n";
        }
        this.replacements.put("spec-comments", specCommentsCode);
    }

    @Override
    protected Map<String, String> getTemplates() {
        Map templates = Maps.map();
        templates.put("compile.sh", "_compile.sh");
        templates.put("library.h", "_library.h");
        templates.put("library.c", "_library.c");
        templates.put("engine.h", "_engine.h");
        templates.put("engine.c", "_engine.c");
        templates.put("test_code.c", "_test_code.c");
        templates.put("readme.txt", "_readme.txt");
        return templates;
    }
}

