/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data.io;

import org.eclipse.escet.chi.runtime.data.io.ChiFileHandle;
import org.eclipse.escet.common.java.Assert;

public class ChiReadMemoryFile
extends ChiFileHandle {
    private String input;
    private int index;
    private int markedPos;

    public ChiReadMemoryFile(String input) {
        super("_memory_file_", "r");
        this.input = input;
        this.index = 0;
        this.markedPos = 0;
    }

    @Override
    public int read() {
        if (this.index < this.input.length()) {
            char k = this.input.charAt(this.index);
            ++this.index;
            return k;
        }
        return -1;
    }

    @Override
    public void markStream(int count) {
        this.markedPos = this.index;
    }

    @Override
    public void resetStream() {
        this.index = this.markedPos;
    }

    @Override
    public void write(String data) {
        Assert.fail((Object)"No writing allowed.");
    }

    @Override
    public boolean isClosed() {
        return this.index >= this.input.length();
    }

    @Override
    public void close() {
        this.index = this.input.length();
        this.markedPos = this.input.length();
    }
}

