/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.partitions;

import java.util.ArrayDeque;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.eventbased.automata.AutomatonHelper;
import org.eclipse.escet.cif.eventbased.automata.Edge;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.cif.eventbased.partitions.Partition;
import org.eclipse.escet.cif.eventbased.partitions.PartitionLocation;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;

public class PartitionRefinement {
    public Map<Location, PartitionLocation> locationMapping;
    public final Set<Event> observableEvents;
    public final Set<Event> nonObservableEvents;
    public Partition computePartitions = null;

    public PartitionRefinement(Set<Event> observableEvents, Set<Event> nonObservableEvents, Set<Set<Location>> partitions) {
        int size = 0;
        for (Set<Location> sl : partitions) {
            size += sl.size();
        }
        this.locationMapping = Maps.mapc((int)size);
        for (Set<Location> sl : partitions) {
            Partition part = new Partition();
            for (Location loc : sl) {
                PartitionLocation pl = new PartitionLocation(loc);
                pl.partition = part;
                part.addLocation(pl);
                this.locationMapping.put(loc, pl);
            }
            this.addCompute(part);
        }
        this.observableEvents = observableEvents;
        this.nonObservableEvents = nonObservableEvents;
    }

    public void refinePartitions() {
        block0: while (this.computePartitions != null) {
            Partition currentPartition = this.computePartitions;
            this.removeCompute(currentPartition);
            Set<Location> expandedSet = this.f1(currentPartition);
            Set fResult = Sets.set();
            for (Event evt : this.observableEvents) {
                this.f2(expandedSet, evt, fResult);
                currentPartition = this.addSet(fResult, currentPartition);
                if (currentPartition == null) continue block0;
            }
        }
    }

    protected Set<Location> f1(Partition currentPartition) {
        Set expandSet = Sets.set();
        ArrayDeque<Location> notDone = new ArrayDeque<Location>(100);
        PartitionLocation ploc = currentPartition.locations;
        while (ploc != null) {
            expandSet.add(ploc.loc);
            notDone.add(ploc.loc);
            ploc = ploc.nextPLoc;
        }
        return AutomatonHelper.expandStatesBackward(expandSet, notDone, this.nonObservableEvents);
    }

    protected Set<Location> f2(Set<Location> expandedSet, Event visibleEvent, Set<Location> result) {
        result.clear();
        ArrayDeque<Location> notDone = new ArrayDeque<Location>(100);
        for (Location loc : expandedSet) {
            for (Edge e : loc.getIncoming(visibleEvent)) {
                if (!result.add(e.srcLoc)) continue;
                notDone.add(e.srcLoc);
            }
        }
        if (result.isEmpty()) {
            return result;
        }
        return AutomatonHelper.expandStatesBackward(result, notDone, this.nonObservableEvents);
    }

    public void addCompute(Partition part) {
        Assert.check((!part.inComputeList ? 1 : 0) != 0);
        part.inComputeList = true;
        part.prevCompute = null;
        part.nextCompute = this.computePartitions;
        if (this.computePartitions != null) {
            this.computePartitions.prevCompute = part;
        }
        this.computePartitions = part;
    }

    public void removeCompute(Partition part) {
        Assert.check((boolean)part.inComputeList);
        part.inComputeList = false;
        if (part.prevCompute != null) {
            part.prevCompute.nextCompute = part.nextCompute;
        }
        if (part.nextCompute != null) {
            part.nextCompute.prevCompute = part.prevCompute;
        }
        if (this.computePartitions == part) {
            this.computePartitions = part.nextCompute;
        }
    }

    public final Partition moveLocations(Set<Location> locs) {
        Partition affected = null;
        for (Location loc : locs) {
            Partition newPart;
            PartitionLocation ploc = this.locationMapping.get(loc);
            Partition part = ploc.partition;
            part.removeLocation(ploc);
            if (part.newPartition != null) {
                part.newPartition.addLocation(ploc);
                ploc.partition = part.newPartition;
                continue;
            }
            part.newPartition = newPart = new Partition();
            newPart.addLocation(ploc);
            ploc.partition = newPart;
            part.nextAffected = affected;
            affected = part;
        }
        return affected;
    }

    public final Partition mergeLocations(Partition affected, Partition currentPartition) {
        while (affected != null) {
            if (affected.locations == null) {
                if (currentPartition == affected) {
                    currentPartition = affected.newPartition;
                }
                if (affected.inComputeList) {
                    this.removeCompute(affected);
                    this.addCompute(affected.newPartition);
                }
                affected.newPartition = null;
            } else {
                if (currentPartition == affected) {
                    currentPartition = null;
                }
                if (!affected.inComputeList) {
                    this.addCompute(affected);
                }
                this.addCompute(affected.newPartition);
                affected.newPartition = null;
            }
            Partition nextPart = affected.nextAffected;
            affected.nextAffected = null;
            affected = nextPart;
        }
        return currentPartition;
    }

    public final Partition addSet(Set<Location> locs, Partition currentPartition) {
        Partition affected = this.moveLocations(locs);
        currentPartition = this.mergeLocations(affected, currentPartition);
        return currentPartition;
    }

    public static Set<Set<Location>> addSet(Set<Set<Location>> existing, Set<Location> newSet) {
        PartitionRefinement oc = new PartitionRefinement(null, null, existing);
        oc.addSet(newSet, null);
        return oc.getPartitions();
    }

    public Set<Set<Location>> getPartitions() {
        Map partitionMap = Maps.map();
        for (Map.Entry<Location, PartitionLocation> lpe : this.locationMapping.entrySet()) {
            Partition p = lpe.getValue().partition;
            Set locs = (Set)partitionMap.get(p);
            if (locs == null) {
                locs = Sets.set();
                partitionMap.put(p, locs);
            }
            locs.add(lpe.getKey());
        }
        Set partitions = Sets.set();
        for (Set locs : partitionMap.values()) {
            partitions.add(locs);
        }
        return partitions;
    }

    public static Set<Set<Location>> hInfinite(Set<Set<Location>> superLocs) {
        while (true) {
            Set result = Sets.set();
            for (Set<Location> locs1 : superLocs) {
                for (Set locs2 : superLocs) {
                    Set locs3 = Sets.copy(locs1);
                    locs3.removeAll(locs2);
                    if (locs3.isEmpty()) continue;
                    result.add(locs3);
                }
            }
            if (result.equals(superLocs)) {
                return result;
            }
            superLocs = result;
        }
    }

    public static Set<Set<Location>> q(Set<Set<Location>> superLocs) {
        Set result = Sets.set();
        for (Set<Location> locs : superLocs) {
            boolean allowed = true;
            for (Set<Location> locs2 : superLocs) {
                if (!locs.containsAll(locs2) || locs.equals(locs2)) continue;
                allowed = false;
                break;
            }
            if (!allowed) continue;
            result.add(locs);
        }
        return result;
    }
}

