/******************************************************************************
 * Copyright (c) 2024, 2025 Contributors to the Eclipse Foundation
 *
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This program and the accompanying materials are made available under the terms
 * of the MIT License which is available at https://opensource.org/licenses/MIT
 *
 *  SPDX-License-Identifier: MIT
 *****************************************************************************/

/* PLC structured text language for highlight.js 11.9.0. The definition is not complete. */
(() => {
    var e = (() => {
        "use strict";
        return e => {
            return {
                name: "PLC structured text",
                case_insensitive: true,
                keywords: {
                    keyword: [
                        // Keywords.
                        "action", "array", "at",
                        "by",
                        "case", "configuration", "constant",
                        "do",
                        "else", "elsif", "end_action", "end_case", "end_configuration", "end_for", "end_function",
                        "end_function_block", "end_if", "end_program", "end_repeat", "end_resource", "end_retain",
                        "end_step", "end_struct", "end_transition", "end_type", "end_var", "end_while", "exit",
                        "false", "f_edge", "for", "from", "function", "function_block",
                        "if", "initial_step",
                        "of", "on",
                        "program",
                        "read_only", "read_write", "r_edge", "repeat", "resource", "retain", "return",
                        "step", "struct",
                        "task", "then", "to", "transition", "true", "type",
                        "until",
                        "var", "var_access", "var_config", "var_external", "var_global", "var_in_out", "var_input",
                        "var_output", "var_temp",
                        "while", "with",

                        // Types.
                        "bool", "sint", "int", "dint", "lint", "usint", "uint", "ulint", "udint", "real", "lreal",
                        "time", "date", "time_of_day", "tod", "date_and_time", "dt", "string", "byte", "word", "dword",
                        "lword", "wstring",

                        // Generic types.
                        "any", "and_derived", "any_elementary", "any_magnitude", "any_num", "any_real", "any_int",
                        "any_bit", "any_string", "any_date",
                    ],
                    built_in: [
                        // Functions.
                        "abs", "acos", "add", "and", "asin", "atan", "cos", "div", "eq", "exp", "expt", "ge", "gt",
                        "le", "ln", "log", "lt", "max", "min", "mod", "mul", "ne", "not", "or", "sel", "sin", "sqrt",
                        "sub", "tan", "xor",

                        // Function blocks.
                        "rs", "sr", // Set/reset.
                        "ton", "tof", "tp", // Timers.
                        "iec_timer", "timer", // Timers S7.
                        "dummyVar1", "dummyVar2", "dummyVar3", "dummyVar4", "dummyVar5", // Dummy variables S7.
                        "f_trig", "r_trig", // Edge detection.
                        "ctu", "ctu_dint", "ctu_lint", "ctu_udint", "ctu_ulint", // Up counters.
                        "ctd", "ctd_dint", "ctd_lint", "ctd_udint", "ctd_ulint", // Down counters.
                        "ctud", "ctud_dint", "ctud_lint", "ctud_udint", "ctud_ulint", // Up-down counters.

                        // Type conversion functions.
                        "dint_to_int", "dint_to_lreal", "dint_to_real",
                        "int_to_dint", "int_to_lreal", "int_to_real",
                        "lreal_to_dint", "lreal_to_int", "lreal_to_real", "lreal_to_time",
                        "real_to_dint", "real_to_int", "real_to_lreal", "real_to_time",
                        "time_to_lreal", "time_to_real",
                    ]
                },
                contains: [
                    // Numbers.
                    {
                        scope: "number",
                        match: /\b[-+]?[0-9]+([.][0-9]+)?[eE][-+]?[0-9]+\b/,
                    },
                    {
                        scope: "number",
                        match: /\b[-+]?[0-9]+[.][0-9]+\b/,
                    },
                    {
                        scope: "number",
                        match: /\b[-+]?[0-9]+\b/,
                    },

                    // Comments.
                    {
                        scope: "comment",
                        begin: '//',
                        end: '$',
                    },
                    {
                        scope: "comment",
                        begin: '\\(\\*',
                        end: '\\*\\)',
                    },

                    // Strings.
                    {
                        scope: "string",
                        begin: '"',
                        end: '"',
                    }
                ]
            }
        }
    })();
    hljs.registerLanguage("plcst", e)
})();
