/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.common;

import java.util.Objects;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.common.BaseEnhNodeFactoryImpl;
import org.apache.jena.ontapi.common.EnhNodeFilter;
import org.apache.jena.ontapi.common.EnhNodeFinder;
import org.apache.jena.ontapi.common.EnhNodeProducer;
import org.apache.jena.ontapi.common.OntEnhNodeFactories;
import org.apache.jena.util.iterator.ExtendedIterator;

public class CommonEnhNodeFactoryImpl
extends BaseEnhNodeFactoryImpl {
    private final EnhNodeProducer maker;
    private final EnhNodeFinder finder;
    private final EnhNodeFilter filter;

    public CommonEnhNodeFactoryImpl(EnhNodeProducer maker, EnhNodeFinder finder, EnhNodeFilter filter) {
        this.maker = Objects.requireNonNull(maker, "Null maker.");
        this.finder = Objects.requireNonNull(finder, "Null finder.");
        this.filter = Objects.requireNonNull(filter, "Null filter.");
    }

    public EnhNodeProducer getMaker() {
        return this.maker;
    }

    public EnhNodeFinder getFinder() {
        return this.finder;
    }

    public EnhNodeFilter getFilter() {
        return this.filter;
    }

    @Override
    public EnhNode wrap(Node node, EnhGraph eg) {
        if (!this.canWrap(node, eg)) {
            throw new OntJenaException.Conversion(String.format("Can't wrap node to impl %s. Node: %s", this.maker.targetName(), OntEnhNodeFactories.toPrintString(node, eg)));
        }
        return this.createInstance(node, eg);
    }

    @Override
    public boolean canWrap(Node node, EnhGraph eg) {
        return this.filter.test(node, eg);
    }

    @Override
    public EnhNode createInGraph(Node node, EnhGraph eg) {
        if (!this.canCreateInGraph(node, eg)) {
            throw new OntJenaException.Creation(String.format("Can't modify graph for impl %s. Node: %s", this.maker.targetName(), OntEnhNodeFactories.toPrintString(node, eg)));
        }
        this.maker.doInsert(node, eg);
        return this.createInstance(node, eg);
    }

    @Override
    public boolean canCreateInGraph(Node node, EnhGraph eg) {
        return this.maker.canInsert(node, eg);
    }

    @Override
    public ExtendedIterator<EnhNode> iterator(EnhGraph eg) {
        return this.finder.restrict(this.filter).iterator(eg).mapWith(n -> this.maker.newInstance((Node)n, eg));
    }

    @Override
    public EnhNode createInstance(Node node, EnhGraph eg) {
        return this.maker.newInstance(node, eg);
    }
}

