/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem;

import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.TripleStore;
import org.apache.jena.mem.NodeToTriplesMapBase;
import org.apache.jena.mem.ObjectIterator;
import org.apache.jena.mem.StoreTripleIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public abstract class GraphTripleStoreBase
implements TripleStore {
    protected final Graph parent;
    protected NodeToTriplesMapBase subjects;
    protected NodeToTriplesMapBase predicates;
    protected NodeToTriplesMapBase objects;

    protected GraphTripleStoreBase(Graph parent, NodeToTriplesMapBase subjects, NodeToTriplesMapBase predicates, NodeToTriplesMapBase objects) {
        this.parent = parent;
        this.subjects = subjects;
        this.objects = objects;
        this.predicates = predicates;
    }

    @Override
    public void close() {
        this.objects = null;
        this.predicates = null;
        this.subjects = null;
    }

    @Override
    public void add(Triple t) {
        if (this.subjects.add(t)) {
            this.predicates.add(t);
            this.objects.add(t);
        }
    }

    @Override
    public void delete(Triple t) {
        if (this.subjects.remove(t)) {
            this.predicates.remove(t);
            this.objects.remove(t);
        }
    }

    @Override
    public void clear() {
        this.subjects.clear();
        this.predicates.clear();
        this.objects.clear();
    }

    @Override
    public int size() {
        return this.subjects.size();
    }

    @Override
    public boolean isEmpty() {
        return this.subjects.isEmpty();
    }

    @Override
    public ExtendedIterator<Node> listSubjects() {
        return this.expectOnlyNodes(this.subjects.domain());
    }

    @Override
    public ExtendedIterator<Node> listPredicates() {
        return this.expectOnlyNodes(this.predicates.domain());
    }

    private ExtendedIterator<Node> expectOnlyNodes(Iterator<Object> elements) {
        return WrappedIterator.createNoRemove(elements).mapWith(o -> (Node)o);
    }

    @Override
    public ExtendedIterator<Node> listObjects() {
        return new ObjectIterator(this.objects.domain()){

            @Override
            protected Iterator<Triple> iteratorFor(Object y) {
                return GraphTripleStoreBase.this.objects.iteratorForIndexed(y);
            }
        };
    }

    @Override
    public boolean contains(Triple t) {
        return this.subjects.containsBySameValueAs(t);
    }

    @Override
    public boolean containsMatch(Triple t) {
        Node pm = t.getPredicate();
        Node om = t.getObject();
        Node sm = t.getSubject();
        if (sm.isConcrete()) {
            return this.subjects.containsMatch(sm, pm, om);
        }
        if (om.isConcrete()) {
            return this.objects.containsMatch(om, sm, pm);
        }
        if (pm.isConcrete()) {
            return this.predicates.containsMatch(pm, om, sm);
        }
        return !this.isEmpty();
    }

    @Override
    public ExtendedIterator<Triple> find(Triple t) {
        Node pm = t.getPredicate();
        Node om = t.getObject();
        Node sm = t.getSubject();
        if (sm.isConcrete()) {
            return new StoreTripleIterator(this.parent, this.subjects.iterator(sm, pm, om), this.subjects, this.predicates, this.objects);
        }
        if (om.isConcrete()) {
            return new StoreTripleIterator(this.parent, this.objects.iterator(om, sm, pm), this.objects, this.subjects, this.predicates);
        }
        if (pm.isConcrete()) {
            return new StoreTripleIterator(this.parent, this.predicates.iterator(pm, om, sm), this.predicates, this.subjects, this.objects);
        }
        return new StoreTripleIterator(this.parent, this.subjects.iterateAll(), this.subjects, this.predicates, this.objects);
    }

    @Override
    public Stream<Triple> stream(Node sm, Node pm, Node om) {
        if (null == sm) {
            sm = Node.ANY;
        }
        if (null == pm) {
            pm = Node.ANY;
        }
        if (null == om) {
            om = Node.ANY;
        }
        if (sm.isConcrete()) {
            return this.subjects.stream(sm, pm, om);
        }
        if (om.isConcrete()) {
            return this.objects.stream(om, sm, pm);
        }
        if (pm.isConcrete()) {
            return this.predicates.stream(pm, om, sm);
        }
        return this.subjects.streamAll();
    }
}

