/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.requirement.model;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections.collection.CompositeCollection;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.model.AbstractSimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.IGenericSimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.MatlabHandleElement;
import org.eclipse.epsilon.emc.simulink.requirement.model.element.ISimulinkRequirementModelElement;
import org.eclipse.epsilon.emc.simulink.requirement.model.element.SimulinkJustification;
import org.eclipse.epsilon.emc.simulink.requirement.model.element.SimulinkLink;
import org.eclipse.epsilon.emc.simulink.requirement.model.element.SimulinkLinkSet;
import org.eclipse.epsilon.emc.simulink.requirement.model.element.SimulinkReference;
import org.eclipse.epsilon.emc.simulink.requirement.model.element.SimulinkRequirement;
import org.eclipse.epsilon.emc.simulink.requirement.operations.contributors.RequirementModelOperationContributor;
import org.eclipse.epsilon.emc.simulink.requirement.util.collection.SimulinkJustificationCollection;
import org.eclipse.epsilon.emc.simulink.requirement.util.collection.SimulinkLinkCollection;
import org.eclipse.epsilon.emc.simulink.requirement.util.collection.SimulinkLinkSetCollection;
import org.eclipse.epsilon.emc.simulink.requirement.util.collection.SimulinkRequirementCollection;
import org.eclipse.epsilon.emc.simulink.types.HandleObject;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.execute.operations.contributors.IOperationContributorProvider;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IRelativePathResolver;

public class SimulinkRequirementModel
extends AbstractSimulinkModel
implements ISimulinkRequirementModelElement,
IOperationContributorProvider {
    protected MatlabHandleElement reqSetHandle;
    protected RequirementModelOperationContributor reqOperationContributor;

    public static void main(String[] args) throws Exception {
        SimulinkRequirementModel reqModel = new SimulinkRequirementModel();
        reqModel.setReadOnLoad(true);
        reqModel.setStoredOnDisposal(false);
        reqModel.setFile(new File("/Applications/MATLAB_R2018b.app/examples/slrequirements/AutopilotRequirements.slreqx"));
        reqModel.setLibraryPath("/Applications/MATLAB_R2018b.app/bin/maci64/");
        reqModel.setEngineJarPath("/Applications/MATLAB_R2018b.app/extern/engines/java/jar/engine.jar");
        System.out.println("Loading");
        reqModel.load();
        EolModule module = new EolModule();
        module.getContext().getModelRepository().addModel((IModel)reqModel);
        module.parse("'Starting'.println();\nfor (r in Requirement.all){ r.Id.println('req: '); }\n for (j in Justification.all){ j.Id.println('jus: '); }\n for (ref in Reference.all){ ls.Id.println('ref: '); }\n ");
        System.out.println("Executing");
        module.execute();
    }

    public void load(StringProperties properties, IRelativePathResolver resolver) throws EolModelLoadingException {
        super.load(properties, resolver);
        this.load();
    }

    protected void loadModel() throws EolModelLoadingException {
        super.loadModel();
        this.reqOperationContributor = new RequirementModelOperationContributor(this.engine);
        if (!this.file.exists()) {
            try {
                this.reqSetHandle = new MatlabHandleElement((IGenericSimulinkModel)this, this.engine, (HandleObject)this.engine.fevalWithResult("slreq.new", new Object[]{this.file.getAbsolutePath()}));
            }
            catch (MatlabException e) {
                throw new EolModelLoadingException((Exception)((Object)e), (IModel)this);
            }
        }
        try {
            this.reqSetHandle = new MatlabHandleElement((IGenericSimulinkModel)this, this.engine, (HandleObject)this.engine.fevalWithResult("slreq.load", new Object[]{this.file.getAbsolutePath()}));
        }
        catch (MatlabException e) {
            throw new EolModelLoadingException((Exception)((Object)e), (IModel)this);
        }
        if (this.isOpenOnLoad().booleanValue()) {
            try {
                this.engine.feval("slreq.open", new Object[]{this.file.getAbsolutePath()});
            }
            catch (MatlabException e) {
                throw new EolModelLoadingException((Exception)((Object)e), (IModel)this);
            }
        }
    }

    public Object getProperty(String property) throws EolRuntimeException {
        return this.reqSetHandle.getProperty(property);
    }

    public void setProperty(String property, Object value) throws EolRuntimeException {
        this.reqSetHandle.setProperty(property, value);
    }

    public Collection<String> getAllTypeNamesOf() {
        return Arrays.asList(this.getType());
    }

    public boolean deleteElementInModel() throws EolRuntimeException {
        throw new EolRuntimeException("Can't delete RequirementSet model");
    }

    public String getType() {
        return "RequirementSet";
    }

    public MatlabHandleElement getHandle() {
        return this.reqSetHandle;
    }

    public IModel getOwningModel() {
        return this;
    }

    public String getTypeNameOf(Object instance) {
        if (instance instanceof ISimulinkModelElement) {
            return ((ISimulinkRequirementModelElement)instance).getType();
        }
        return null;
    }

    public Object getElementById(String id) {
        throw new IllegalAccessError("Not allowed to get element by id");
    }

    public String getElementId(Object instance) {
        if (instance instanceof ISimulinkRequirementModelElement) {
            try {
                ((ISimulinkRequirementModelElement)instance).getProperty("SID");
            }
            catch (EolRuntimeException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public OperationContributor getOperationContributor() {
        return this.reqOperationContributor;
    }

    public void setElementId(Object instance, String newId) {
        throw new IllegalAccessError("Not allowed to get element by id from here");
    }

    public boolean owns(Object instance) {
        return instance instanceof ISimulinkRequirementModelElement;
    }

    public boolean isInstantiable(String type) {
        return Arrays.asList("Justification", "Requirement", "Link", "Reference").contains(type) || type.startsWith("RQ_") || super.isInstantiable(type);
    }

    public boolean hasType(String type) {
        return Arrays.asList("Justification", "Requirement", "Link", "Reference", "LinkSet", "RequirementSet").contains(type) || type.startsWith("RQ_") || type.startsWith("RF_") || type.startsWith("L_");
    }

    protected void closeMatlabModel() {
        try {
            this.engine.feval(0, "close", new Object[]{this.reqSetHandle.getHandle()});
        }
        catch (Exception exception) {
            System.err.println("Unable to close model");
        }
    }

    public boolean store(String location) {
        try {
            this.engine.feval(0, "save", new Object[]{this.reqSetHandle.getHandle(), location});
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean store() {
        try {
            this.engine.feval(0, "save", new Object[]{this.reqSetHandle.getHandle()});
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected Collection<ISimulinkModelElement> allContentsFromModel() {
        try {
            CompositeCollection compositeCollection = new CompositeCollection();
            compositeCollection.addComposited(Arrays.asList(this));
            compositeCollection.addComposited(this.getAllOfKind("Requirement"));
            compositeCollection.addComposited(this.getAllOfKind("Justification"));
            compositeCollection.addComposited(this.getAllOfKind("Reference"));
            compositeCollection.addComposited(this.getAllOfKind("Link"));
            compositeCollection.addComposited(this.getAllOfKind("LinkSet"));
            return compositeCollection;
        }
        catch (EolModelElementTypeNotFoundException eolModelElementTypeNotFoundException) {
            throw new IllegalStateException("We should know the Entry type");
        }
    }

    protected Collection<ISimulinkModelElement> getAllOfTypeFromModel(String type) throws EolModelElementTypeNotFoundException {
        if (type.startsWith("RQ_")) {
            try {
                Object collection = this.engine.fevalWithResult("find", new Object[]{this.getHandle().getHandle(), "Type", "Requirement", "ReqType", type.substring(3)});
                return new SimulinkRequirementCollection(collection, this);
            }
            catch (MatlabException e) {
                throw new EolModelElementTypeNotFoundException(this.getName(), type, e.getMessage());
            }
        }
        if (type.startsWith("RF_")) {
            try {
                Object collection = this.engine.fevalWithResult("find", new Object[]{this.getHandle().getHandle(), "Type", "Reference", "ReqType", type.substring(3)});
                return new SimulinkRequirementCollection(collection, this);
            }
            catch (MatlabException e) {
                throw new EolModelElementTypeNotFoundException(this.getName(), type, e.getMessage());
            }
        }
        if (type.startsWith("L_")) {
            try {
                Object collection = this.engine.fevalWithResult("slreq.find", new Object[]{"Type", "Link", "LinkType", type.substring(2)});
                return new SimulinkLinkCollection(collection, this);
            }
            catch (MatlabException e) {
                throw new EolModelElementTypeNotFoundException(this.getName(), type, e.getMessage());
            }
        }
        throw new EolModelElementTypeNotFoundException(this.getName(), type);
    }

    protected Collection<ISimulinkModelElement> getAllOfKindFromModel(String kind) throws EolModelElementTypeNotFoundException {
        switch (kind) {
            case "Requirement": {
                try {
                    Object collection = this.engine.fevalWithResult("find", new Object[]{this.getHandle().getHandle(), "Type", "Requirement"});
                    return new SimulinkRequirementCollection(collection, this);
                }
                catch (MatlabException matlabException) {
                    return Collections.emptyList();
                }
            }
            case "Justification": {
                try {
                    Object collection = this.engine.fevalWithResult("find", new Object[]{this.getHandle().getHandle(), "Type", "Justification"});
                    return new SimulinkJustificationCollection(collection, this);
                }
                catch (MatlabException matlabException) {
                    return Collections.emptyList();
                }
            }
            case "Reference": {
                try {
                    Object collection = this.engine.fevalWithResult("find", new Object[]{this.getHandle().getHandle(), "Type", "Reference"});
                    return new SimulinkJustificationCollection(collection, this);
                }
                catch (MatlabException matlabException) {
                    return Collections.emptyList();
                }
            }
            case "Link": {
                try {
                    Object collection = this.engine.fevalWithResult("slreq.find", new Object[]{"Type", "Link"});
                    return new SimulinkLinkCollection(collection, this);
                }
                catch (MatlabException matlabException) {
                    return Collections.emptyList();
                }
            }
            case "LinkSet": {
                try {
                    Object collection = this.engine.fevalWithResult("slreq.find", new Object[]{"Type", "LinkSet"});
                    return new SimulinkLinkSetCollection(collection, this);
                }
                catch (MatlabException matlabException) {
                    return Collections.emptyList();
                }
            }
            case "RequirementSet": {
                return Arrays.asList(this);
            }
        }
        return this.getAllOfTypeFromModel(kind);
    }

    protected ISimulinkModelElement createInstanceInModel(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        switch (type) {
            case "Justification": {
                return new SimulinkJustification(this, this.engine);
            }
            case "Requirement": {
                return new SimulinkRequirement(this, this.engine);
            }
            case "Link": {
                return new SimulinkLink(this, this.engine);
            }
            case "Reference": {
                return new SimulinkReference(this, this.engine);
            }
        }
        if (type.startsWith("RQ_")) {
            return new SimulinkRequirement(this, this.engine, type.substring(3));
        }
        return super.createInstanceInModel(type);
    }

    public Object createInstance(String type, Collection<Object> parameters) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        switch (type) {
            case "Reference": {
                if (parameters.size() != 1) break;
                String artifact = (String)parameters.toArray(new Object[0])[0];
                return new SimulinkReference(this, this.engine, artifact);
            }
            case "LinkSet": {
                if (parameters.size() != 1) break;
                String artifact = (String)parameters.toArray(new Object[0])[0];
                return new SimulinkLinkSet(this, this.engine, artifact);
            }
        }
        return null;
    }

    protected boolean deleteElementInModel(Object instance) throws EolRuntimeException {
        if (instance instanceof ISimulinkRequirementModelElement) {
            return ((ISimulinkRequirementModelElement)instance).deleteElementInModel();
        }
        return false;
    }
}

