/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core.subinterfaces;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.core.AbstractEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.AbstractSubEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.MonitorProvider;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.Messages;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.exceptions.FileTransferException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidInputException;
import org.eclipse.emf.emfstore.internal.server.filetransfer.FileChunk;
import org.eclipse.emf.emfstore.internal.server.filetransfer.FilePartitionerUtil;
import org.eclipse.emf.emfstore.internal.server.filetransfer.FileTransferInformation;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.auth.ESMethod;

public class FileTransferSubInterfaceImpl
extends AbstractSubEmfstoreInterface {
    private static final String FILELOAD = "filetransfer";
    public static final String TEMP_FOLDER = "tmp";
    public static final String ATTACHMENT_FOLDER = "attachment";
    public static final String FILE_NAME_DELIMITER = "_";

    public FileTransferSubInterfaceImpl(AbstractEmfstoreInterface parentInterface) throws FatalESException {
        super(parentInterface);
    }

    @ESMethod(value=ESMethod.MethodId.DOWNLOADFILECHUNK)
    public FileChunk downloadFileChunk(ProjectId projectId, FileTransferInformation fileInformation) throws FileTransferException, InvalidInputException {
        File file;
        this.sanityCheckObjects(projectId, fileInformation);
        this.createDirectories(projectId);
        try {
            file = this.findFile(fileInformation, projectId);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        return FilePartitionerUtil.readChunk(file, fileInformation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ESMethod(value=ESMethod.MethodId.UPLOADFILECHUNK)
    public FileTransferInformation uploadFileChunk(ProjectId projectId, FileChunk fileChunk) throws FileTransferException, InvalidInputException {
        this.sanityCheckObjects(projectId, fileChunk);
        Object object = MonitorProvider.getInstance().getMonitor(FILELOAD);
        synchronized (object) {
            File tmpFile;
            this.createDirectories(projectId);
            FileTransferInformation fileInfo = fileChunk.getFileInformation();
            try {
                tmpFile = fileChunk.getChunkNumber() == 0 ? this.getTempFile(fileInfo, projectId) : this.findFileInTemp(fileInfo, projectId);
            }
            catch (FileNotFoundException e) {
                throw new FileTransferException(Messages.FileTransferSubInterfaceImpl_File_Inaccessible, e);
            }
            FilePartitionerUtil.writeChunk(tmpFile, fileChunk);
            if (fileChunk.isLast()) {
                try {
                    File attachmentFile = this.getCachedFile(fileInfo, projectId);
                    FileUtil.copyFile((File)tmpFile, (File)attachmentFile);
                    tmpFile.delete();
                }
                catch (IOException e) {
                    throw new FileTransferException(Messages.FileTransferSubInterfaceImpl_Move_Failed, e);
                }
            }
            return fileInfo;
        }
    }

    private void createDirectories(ProjectId projectId) {
        File createFolders = new File(this.getProjectAttachmentTempFolder(projectId));
        if (!createFolders.exists()) {
            createFolders.mkdirs();
        }
    }

    private File findFileInTemp(FileTransferInformation fileInfo, ProjectId projectId) throws FileNotFoundException {
        File file = this.getTempFile(fileInfo, projectId);
        if (file.exists()) {
            return file;
        }
        throw new FileNotFoundException(MessageFormat.format(Messages.FileTransferSubInterfaceImpl_Locate_Tmp_Failed, fileInfo.getFileIdentifier()));
    }

    private File findFile(FileTransferInformation fileInfo, ProjectId projectId) throws FileNotFoundException {
        File file = this.getCachedFile(fileInfo, projectId);
        if (file.exists()) {
            return file;
        }
        throw new FileNotFoundException(MessageFormat.format(Messages.FileTransferSubInterfaceImpl_Locate_Cache_Failed, fileInfo.getFileIdentifier()));
    }

    private File getTempFile(FileTransferInformation fileInfo, ProjectId projectId) {
        return new File(String.valueOf(this.getProjectAttachmentTempFolder(projectId)) + File.separator + this.constructFileName(fileInfo));
    }

    private File getCachedFile(FileTransferInformation fileInfo, ProjectId projectId) {
        return new File(String.valueOf(this.getProjectAttachmentFolder(projectId)) + File.separator + this.constructFileName(fileInfo));
    }

    private String constructFileName(FileTransferInformation fileInfo) {
        return fileInfo.getFileIdentifier().getIdentifier();
    }

    private String getProjectAttachmentFolder(ProjectId projectId) {
        return String.valueOf(ServerConfiguration.getServerHome()) + "project-" + projectId.getId() + File.separator + ATTACHMENT_FOLDER;
    }

    private String getProjectAttachmentTempFolder(ProjectId projectId) {
        return String.valueOf(this.getProjectAttachmentFolder(projectId)) + File.separator + TEMP_FOLDER;
    }
}

