/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.filetransfer;

import org.eclipse.emf.emfstore.internal.client.model.filetransfer.FileDownloadStatus;

public class FileTransferStatistics {
    private int fileSize = -1;
    private int transferredBytes;
    private long startTime;
    private long stopTime;
    private final FileDownloadStatus status;

    FileTransferStatistics(FileDownloadStatus status) {
        this.status = status;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public int getTransferredBytes() {
        return this.transferredBytes;
    }

    public float getPercentTransferred() {
        switch (this.status.getStatus()) {
            case NOT_STARTED: {
                return 0.0f;
            }
            case FINISHED: {
                return 1.0f;
            }
        }
        int fileSize = this.getFileSize();
        if (fileSize <= 0) {
            return 0.0f;
        }
        return (float)this.getTransferredBytes() / (float)this.getFileSize();
    }

    public float getAverageThroughput() {
        switch (this.status.getStatus()) {
            case NOT_STARTED: {
                return 0.0f;
            }
        }
        long elapsed = this.getElapsedMilis();
        if (elapsed == 0L) {
            return 0.0f;
        }
        return (float)this.getTransferredBytes() * 1000.0f / (float)elapsed;
    }

    public int getEstimatedRemainingTime() {
        switch (this.status.getStatus()) {
            case NOT_STARTED: 
            case CANCELLED: {
                return -1;
            }
            case FINISHED: {
                return 0;
            }
        }
        int remaining = this.getRemainingBytes();
        float avgThroughput = this.getAverageThroughput();
        if (avgThroughput == 0.0f) {
            return -1;
        }
        return (int)((float)remaining / avgThroughput);
    }

    public int getRemainingBytes() {
        return this.fileSize - this.transferredBytes;
    }

    public int getElapsedTime() {
        return (int)(this.getElapsedMilis() / 1000L);
    }

    private long getElapsedMilis() {
        switch (this.status.getStatus()) {
            case NOT_STARTED: {
                return 0L;
            }
            case FINISHED: 
            case CANCELLED: {
                return this.stopTime - this.startTime;
            }
        }
        return System.currentTimeMillis() - this.startTime;
    }

    void registerStart(int fileSize) {
        this.startTime = System.currentTimeMillis();
        this.fileSize = fileSize;
    }

    void registerStop() {
        this.stopTime = System.currentTimeMillis();
    }
}

